/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowToggleWatchedFlagAction
extends TmmAction {
    private static final long serialVersionUID = 5762347331284295996L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowToggleWatchedFlagAction() {
        this.putValue("Name", BUNDLE.getString("tvshowepisode.togglewatchedflag"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, 3));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShowEpisode> selectedEpisodes = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        if (selectedEpisodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        for (TvShowEpisode episode : selectedEpisodes) {
            episode.setWatched(!episode.isWatched());
            episode.writeNFO();
            episode.saveToDb();
        }
    }
}

