/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRemoveAction
extends TmmAction {
    private static final long serialVersionUID = -2355545751433709417L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowRemoveAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.remove"));
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.remove"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke('\u007f'));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        for (Object obj : selectedObjects) {
            if (obj instanceof TvShow) {
                TvShow tvShow = (TvShow)obj;
                TvShowList.getInstance().removeTvShow(tvShow);
            }
            if (obj instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj;
                ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(season.getEpisodes());
                for (TvShowEpisode episode : episodes) {
                    season.getTvShow().removeEpisode(episode);
                }
            }
            if (!(obj instanceof TvShowEpisode)) continue;
            TvShowEpisode tvShowEpisode = (TvShowEpisode)obj;
            tvShowEpisode.getTvShow().removeEpisode(tvShowEpisode);
        }
    }
}

