/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowKodiRefreshNfoAction
extends TmmAction {
    private static final long serialVersionUID = -3911290901017607679L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowKodiRefreshNfoAction() {
        this.putValue("SwingLargeIconKey", IconManager.NFO);
        this.putValue("SmallIcon", IconManager.NFO);
        this.putValue("Name", BUNDLE.getString("kodi.rpc.refreshnfo"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        MediaEntity me;
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        ArrayList<TvShowEpisode> eps = new ArrayList<TvShowEpisode>();
        HashSet<TvShow> shows = new HashSet<TvShow>();
        for (Object object : selectedObjects) {
            if (object instanceof TvShow) {
                TvShow show = (TvShow)object;
                shows.add(show);
            }
            if (object instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)object;
                eps.add(episode);
            }
            if (!(object instanceof TvShowSeason)) continue;
            TvShowSeason season = (TvShowSeason)object;
            eps.addAll(season.getEpisodes());
        }
        for (int i = eps.size() - 1; i >= 0; --i) {
            TvShowEpisode tvShowEpisode = (TvShowEpisode)eps.get(i);
            if (!shows.contains(tvShowEpisode.getTvShow())) continue;
            eps.remove(i);
        }
        for (Object e2 : shows) {
            me = (MediaEntity)e2;
            KodiRPC.getInstance().refreshFromNfo(me);
        }
        for (Object e3 : eps) {
            me = (MediaEntity)e3;
            KodiRPC.getInstance().refreshFromNfo(me);
        }
    }
}

