/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowExporterDialog;

public class TvShowExportAction
extends TmmAction {
    private static final long serialVersionUID = 6746506855715337027L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowExportAction() {
        this.putValue("SwingLargeIconKey", IconManager.EXPORT);
        this.putValue("SmallIcon", IconManager.EXPORT);
        this.putValue("Name", BUNDLE.getString("tvshow.export"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 3));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        TvShowExporterDialog dialog = new TvShowExporterDialog(selectedTvShows);
        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
        dialog.setVisible(true);
    }
}

