/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowEditorDialog;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowEpisodeEditorDialog;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowSeasonEditorDialog;

public class TvShowEditAction
extends TmmAction {
    private static final long serialVersionUID = -3911290901017607679L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowEditAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.edit"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.edit"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 3));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        int selectedCount = selectedObjects.size();
        int index = 0;
        if (selectedObjects.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        do {
            TmmDialog editor;
            Object obj;
            if ((obj = selectedObjects.get(index)) instanceof TvShow) {
                TvShow tvShow = (TvShow)obj;
                editor = new TvShowEditorDialog(tvShow, index, selectedCount);
                editor.setVisible(true);
                if (!((TvShowEditorDialog)editor).isContinueQueue()) break;
                index = ((TvShowEditorDialog)editor).isNavigateBack() ? --index : ++index;
            }
            if (obj instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj;
                editor = new TvShowSeasonEditorDialog(season, index, selectedCount);
                editor.setVisible(true);
                if (!((TvShowSeasonEditorDialog)editor).isContinueQueue()) break;
                index = ((TvShowSeasonEditorDialog)editor).isNavigateBack() ? --index : ++index;
            }
            if (!(obj instanceof TvShowEpisode)) continue;
            TvShowEpisode tvShowEpisode = (TvShowEpisode)obj;
            editor = new TvShowEpisodeEditorDialog(tvShowEpisode, index, selectedCount);
            editor.setVisible(true);
            if (!((TvShowEpisodeEditorDialog)editor).isContinueQueue()) break;
            if (((TvShowEpisodeEditorDialog)editor).isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < selectedCount);
    }
}

