/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;

public class TvShowSelectionModel
extends AbstractModelObject {
    private static final String SELECTED_TV_SHOW = "selectedTvShow";
    private TvShow selectedTvShow;
    private TvShow initalTvShow;
    private PropertyChangeListener propertyChangeListener;
    private TmmTreeTable treeTable;

    public TvShowSelectionModel() {
        this.selectedTvShow = this.initalTvShow = new TvShow();
        this.propertyChangeListener = this::firePropertyChange;
    }

    public void setTreeTable(TmmTreeTable treeTable) {
        this.treeTable = treeTable;
    }

    public void setSelectedTvShow(TvShow tvShow) {
        if (tvShow == this.selectedTvShow) {
            return;
        }
        TvShow oldValue = this.selectedTvShow;
        this.selectedTvShow = tvShow != null ? tvShow : this.initalTvShow;
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.selectedTvShow != null) {
            this.selectedTvShow.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.firePropertyChange(SELECTED_TV_SHOW, oldValue, this.selectedTvShow);
    }

    public TvShow getSelectedTvShow() {
        return this.selectedTvShow;
    }

    public List<TvShow> getSelectedTvShows() {
        ArrayList<TvShow> selectedTvShows = new ArrayList<TvShow>();
        for (Object obj : this.getSelectedObjects()) {
            if (!(obj instanceof TvShow)) continue;
            selectedTvShows.add((TvShow)obj);
        }
        return selectedTvShows;
    }

    public List<TvShowEpisode> getSelectedEpisodes() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        for (Object obj : this.getSelectedObjects()) {
            if (obj instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)obj;
                if (episode.isDummy() || episodes.contains(episode)) continue;
                episodes.add(episode);
                continue;
            }
            if (obj instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj;
                for (TvShowEpisode episode : season.getEpisodes()) {
                    if (episode.isDummy() || episodes.contains(episode)) continue;
                    episodes.add(episode);
                }
                continue;
            }
            if (!(obj instanceof TvShow)) continue;
            TvShow tvShow = (TvShow)obj;
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                if (episode.isDummy() || episodes.contains(episode)) continue;
                episodes.add(episode);
            }
        }
        return episodes;
    }

    public List<Object> getSelectedObjects() {
        return this.getSelectedObjects(false);
    }

    public List<Object> getSelectedObjects(boolean withDummy) {
        int[] rows;
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (int row : rows = this.treeTable.getSelectedRows()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeTable.getValueAt(row, 0);
            if (node == null) continue;
            Object userObject = node.getUserObject();
            if (userObject instanceof TvShow) {
                selectedObjects.add(userObject);
                continue;
            }
            if (userObject instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)userObject;
                if (!season.isDummy()) {
                    selectedObjects.add(userObject);
                    continue;
                }
                if (!season.isDummy() || !withDummy) continue;
                selectedObjects.add(userObject);
                continue;
            }
            if (!(userObject instanceof TvShowEpisode)) continue;
            TvShowEpisode episode = (TvShowEpisode)userObject;
            if (!episode.isDummy()) {
                selectedObjects.add(userObject);
                continue;
            }
            if (!episode.isDummy() || !withDummy) continue;
            selectedObjects.add(userObject);
        }
        return selectedObjects;
    }
}

