/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.text.DateFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.panels.RoundedPanel;

public class MessagePanel
extends JPanel {
    private static final long serialVersionUID = -7224510527137312686L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private JLabel lblTitle;
    private JTextArea taMessage;
    private JLabel lblIcon;
    private JLabel lblDate;

    public MessagePanel(Message message) {
        this.setOpaque(false);
        this.initComponents();
        DateFormat dateFormat = TmmDateFormat.SHORT_DATE_MEDIUM_TIME_FORMAT;
        this.lblDate.setText(dateFormat.format(message.getMessageDate()));
        String text = "";
        if (message.getMessageSender() instanceof MediaEntity) {
            MediaEntity me = (MediaEntity)message.getMessageSender();
            text = me.getTitle();
        } else if (message.getMessageSender() instanceof MediaFile) {
            MediaFile mf = (MediaFile)message.getMessageSender();
            text = mf.getFilename();
        } else {
            try {
                text = Utils.replacePlaceholders(BUNDLE.getString(message.getMessageSender().toString()), message.getSenderParams());
            }
            catch (Exception e) {
                text = String.valueOf(message.getMessageSender());
            }
        }
        this.lblTitle.setText(text);
        text = "";
        try {
            text = Utils.replacePlaceholders(BUNDLE.getString(message.getMessageId()), message.getIdParams());
        }
        catch (Exception e) {
            text = message.getMessageId();
        }
        this.taMessage.setText(text);
        switch (message.getMessageLevel()) {
            case ERROR: {
                this.lblIcon.setIcon(IconManager.ERROR);
                break;
            }
            case WARN: {
                this.lblIcon.setIcon(IconManager.WARN);
                break;
            }
            case INFO: {
                this.lblIcon.setIcon(IconManager.INFO);
                break;
            }
            default: {
                this.lblIcon.setIcon(null);
            }
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[300lp:450lp,grow]", "[][]"));
        this.lblDate = new JLabel("");
        this.add((Component)this.lblDate, "cell 0 0,aligny top");
        RoundedPanel innerPanel = new RoundedPanel(){
            private static final long serialVersionUID = -6407635030887890673L;
            {
                this.arcs = new Dimension(10, 10);
                this.drawShadow = false;
            }
        };
        this.add((Component)innerPanel, "cell 0 1,growx");
        innerPanel.setLayout((LayoutManager)new MigLayout("", "[1px][][300lp:350lp,grow]", "[][]"));
        this.lblIcon = new JLabel("");
        this.lblIcon.setHorizontalAlignment(0);
        innerPanel.add((Component)this.lblIcon, "cell 1 0,alignx center,aligny center");
        this.lblTitle = new JLabel();
        TmmFontHelper.changeFont((JComponent)this.lblTitle, 1);
        innerPanel.add((Component)this.lblTitle, "cell 2 0,growx");
        this.taMessage = new ReadOnlyTextArea();
        innerPanel.add((Component)this.taMessage, "cell 2 1,wmin 0,grow");
    }
}

