/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.ui.converter.CertificationImageConverter;

public class MediaInformationLogosPanel
extends JPanel {
    private static final long serialVersionUID = -3403472105793548302L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInformationLogosPanel.class);
    private final String imageSource;
    private IMediaInformation mediaInformationSource;
    private CertificationImageConverter certificationImageConverter = new CertificationImageConverter();
    private JLabel lblCertification = new JLabel();
    private JLabel lblVideoFormat = new JLabel();
    private JLabel lblAspectRatio = new JLabel();
    private JLabel lblVideoCodec = new JLabel();
    private JLabel lblVideo3d = new JLabel();
    private JLabel lblAudioCodec = new JLabel();
    private JLabel lblAudioChannels = new JLabel();
    private JLabel lblContainer = new JLabel();
    private JLabel lblSource = new JLabel();

    public MediaInformationLogosPanel() {
        this.imageSource = "/org/tinymediamanager/ui/plaf/" + Settings.getInstance().getTheme().toLowerCase(Locale.ROOT) + "/images";
        this.setLayout((LayoutManager)new MigLayout("hidemode 2, insets n n n 15lp", "[][][][][][10lp][][][10lp][][]", "[]"));
        this.add((Component)this.lblCertification, "cell 0 0, gapright 15lp");
        this.add((Component)this.lblVideoFormat, "cell 1 0");
        this.add((Component)this.lblAspectRatio, "cell 2 0");
        this.add((Component)this.lblVideoCodec, "cell 3 0");
        this.add((Component)this.lblVideo3d, "cell 4 0");
        this.add((Component)this.lblAudioChannels, "cell 6 0");
        this.add((Component)this.lblAudioCodec, "cell 7 0");
        this.add((Component)this.lblSource, "cell 9 0");
    }

    public void setMediaInformationSource(IMediaInformation source) {
        this.mediaInformationSource = source;
        this.setIcon(this.lblCertification, this.getCertificationIcon());
        this.setIcon(this.lblVideoFormat, this.getVideoFormatIcon());
        this.setIcon(this.lblAspectRatio, this.getAspectRatioIcon());
        this.setIcon(this.lblVideoCodec, this.getVideoCodecIcon());
        this.setIcon(this.lblVideo3d, this.getVideo3dIcon());
        this.setIcon(this.lblAudioCodec, this.getAudioCodecIcon());
        this.setIcon(this.lblAudioChannels, this.getAudioChannelsIcon());
        this.setIcon(this.lblContainer, this.getContainerIcon());
        this.setIcon(this.lblSource, this.getSourceIcon());
    }

    private void setIcon(JLabel label, Icon icon) {
        label.setIcon(icon);
        if (icon != null) {
            label.setVisible(true);
        } else {
            label.setVisible(false);
        }
    }

    private Icon getCertificationIcon() {
        Icon icon = this.certificationImageConverter.convertForward(this.mediaInformationSource.getCertification());
        if (icon == null || icon == CertificationImageConverter.emptyImage) {
            return null;
        }
        return icon;
    }

    private Icon getVideoFormatIcon() {
        String videoFormat = this.mediaInformationSource.getMediaInfoVideoFormat();
        if (StringUtils.isEmpty((CharSequence)videoFormat)) {
            return null;
        }
        try {
            URL file = this.getClass().getResource(this.imageSource + "/video/format/" + videoFormat + ".png");
            if (file == null) {
                file = this.getClass().getResource(this.imageSource + "/video/format/" + videoFormat.replaceAll("[pi]", "") + ".png");
            }
            if (file != null) {
                return new ImageIcon(file);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return null;
    }

    private Icon getAspectRatioIcon() {
        float aspectRatio = this.mediaInformationSource.getMediaInfoAspectRatio();
        if (aspectRatio == 0.0f) {
            return null;
        }
        try {
            String ratio = String.valueOf(aspectRatio);
            URL file = this.getClass().getResource(this.imageSource + "/aspectratio/" + ratio + ".png");
            if (file != null) {
                return new ImageIcon(file);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return null;
    }

    private Icon getVideoCodecIcon() {
        String videoCodec = this.mediaInformationSource.getMediaInfoVideoCodec();
        if (StringUtils.isEmpty((CharSequence)videoCodec)) {
            return null;
        }
        try {
            URL file = this.getClass().getResource(this.imageSource + "/video/codec/" + videoCodec.toLowerCase(Locale.ROOT) + ".png");
            if (file != null) {
                return new ImageIcon(file);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return null;
    }

    private Icon getAudioCodecIcon() {
        String audioCodec = this.mediaInformationSource.getMediaInfoAudioCodec();
        if (StringUtils.isEmpty((CharSequence)audioCodec)) {
            return null;
        }
        try {
            URL file = this.getClass().getResource(this.imageSource + "/audio/codec/" + audioCodec.toLowerCase(Locale.ROOT) + ".png");
            if (file == null) {
                file = this.getClass().getResource(this.imageSource + "/audio/codec/" + audioCodec.toLowerCase(Locale.ROOT).replaceAll("\\p{Punct}", "") + ".png");
            }
            if (file != null) {
                return new ImageIcon(file);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return null;
    }

    private Icon getAudioChannelsIcon() {
        String audioChannels = this.mediaInformationSource.getMediaInfoAudioChannels();
        if (StringUtils.isBlank((CharSequence)audioChannels)) {
            return null;
        }
        int audioChannelsInt = 0;
        try {
            audioChannelsInt = Integer.parseInt(audioChannels.replace("ch", ""));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            URL file = this.getClass().getResource(this.imageSource + "/audio/channels/" + audioChannels + ".png");
            if (audioChannelsInt == 2) {
                file = this.getClass().getResource(this.imageSource + "/audio/channels/2.0ch.png");
            }
            if (file == null && audioChannelsInt > 0) {
                String channels = audioChannelsInt - 1 + ".1ch";
                file = this.getClass().getResource(this.imageSource + "/audio/channels/" + channels + ".png");
            }
            if (file != null) {
                return new ImageIcon(file);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return null;
    }

    private Icon getVideo3dIcon() {
        if (!this.mediaInformationSource.isVideoIn3D()) {
            return null;
        }
        try {
            URL file = this.getClass().getResource(this.imageSource + "/video/3d.png");
            if (file != null) {
                return new ImageIcon(file);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return null;
    }

    private Icon getContainerIcon() {
        String container = this.mediaInformationSource.getMediaInfoContainerFormat();
        if (StringUtils.isEmpty((CharSequence)container)) {
            return null;
        }
        try {
            URL file = this.getClass().getResource(this.imageSource + "/container/" + container.toLowerCase(Locale.ROOT) + ".png");
            if (file != null) {
                return new ImageIcon(file);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return null;
    }

    private Icon getSourceIcon() {
        MediaSource source = this.mediaInformationSource.getMediaInfoSource();
        if (source == MediaSource.UNKNOWN) {
            return null;
        }
        try {
            URL file = this.getClass().getResource(this.imageSource + "/source/" + source.name().toLowerCase(Locale.ROOT) + ".png");
            if (file != null) {
                return new ImageIcon(file);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return null;
    }
}

