/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.trakttv.ClearTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;

public class MovieSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -4173835431245178069L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final MovieSettings settings = MovieModuleManager.SETTINGS;
    private JButton btnClearTraktData;
    private JCheckBox chckbxTraktSync;
    private JCheckBox chckbxRenameAfterScrape;
    private JCheckBox chckbxPersistUiFilters;
    private JCheckBox chckbxBuildImageCache;
    private JCheckBox chckbxRuntimeFromMi;
    private JCheckBox chckbxPersistUiSorting;
    private JCheckBox chckbxShowLogos;
    private JButton btnPresetKodi;
    private JButton btnPresetXbmc;
    private JButton btnPresetMediaPortal1;
    private JButton btnPresetMediaPortal2;
    private JButton btnPresetPlex;
    private JCheckBox chckbxPersonalRatingFirst;
    private AutocompleteComboBox<String> cbRating;
    private JCheckBox chckbxIncludeExternalAudioStreams;
    private JCheckBox chckbxCheckPoster;
    private JCheckBox chckbxCheckFanart;
    private JCheckBox chckbxCheckBanner;
    private JCheckBox chckbxCheckClearart;
    private JCheckBox chckbxCheckThumb;
    private JCheckBox chckbxCheckLogo;
    private JCheckBox chckbxCheckClearlogo;
    private JCheckBox chckbxCheckDiscart;
    private ItemListener checkBoxListener = e -> this.checkChanges();

    public MovieSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnClearTraktData.addActionListener(e -> {
            int confirm = JOptionPane.showOptionDialog(null, BUNDLE.getString("Settings.trakt.clearmovies.hint"), BUNDLE.getString("Settings.trakt.clearmovies"), 0, 3, null, null, null);
            if (confirm == 0) {
                ClearTraktTvTask task = new ClearTraktTvTask(true, false);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
        });
        this.btnPresetXbmc.addActionListener(evt -> this.settings.setDefaultSettingsForXbmc());
        this.btnPresetKodi.addActionListener(evt -> this.settings.setDefaultSettingsForKodi());
        this.btnPresetMediaPortal1.addActionListener(evt -> this.settings.setDefaultSettingsForMediaPortal1());
        this.btnPresetMediaPortal2.addActionListener(evt -> this.settings.setDefaultSettingsForMediaPortal2());
        this.btnPresetPlex.addActionListener(evt -> this.settings.setDefaultSettingsForPlex());
        this.buildCheckBoxes();
    }

    private void checkChanges() {
        this.settings.clearCheckImagesMovie();
        if (this.chckbxCheckPoster.isSelected()) {
            this.settings.addCheckImagesMovie(MediaArtwork.MediaArtworkType.POSTER);
        }
        if (this.chckbxCheckFanart.isSelected()) {
            this.settings.addCheckImagesMovie(MediaArtwork.MediaArtworkType.BACKGROUND);
        }
        if (this.chckbxCheckBanner.isSelected()) {
            this.settings.addCheckImagesMovie(MediaArtwork.MediaArtworkType.BANNER);
        }
        if (this.chckbxCheckClearart.isSelected()) {
            this.settings.addCheckImagesMovie(MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (this.chckbxCheckThumb.isSelected()) {
            this.settings.addCheckImagesMovie(MediaArtwork.MediaArtworkType.THUMB);
        }
        if (this.chckbxCheckLogo.isSelected()) {
            this.settings.addCheckImagesMovie(MediaArtwork.MediaArtworkType.LOGO);
        }
        if (this.chckbxCheckClearlogo.isSelected()) {
            this.settings.addCheckImagesMovie(MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (this.chckbxCheckDiscart.isSelected()) {
            this.settings.addCheckImagesMovie(MediaArtwork.MediaArtworkType.DISC);
        }
    }

    private void buildCheckBoxes() {
        this.chckbxCheckPoster.removeItemListener(this.checkBoxListener);
        this.chckbxCheckFanart.removeItemListener(this.checkBoxListener);
        this.chckbxCheckBanner.removeItemListener(this.checkBoxListener);
        this.chckbxCheckClearart.removeItemListener(this.checkBoxListener);
        this.chckbxCheckThumb.removeItemListener(this.checkBoxListener);
        this.chckbxCheckLogo.removeItemListener(this.checkBoxListener);
        this.chckbxCheckClearlogo.removeItemListener(this.checkBoxListener);
        this.chckbxCheckDiscart.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.chckbxCheckPoster, this.chckbxCheckFanart, this.chckbxCheckBanner, this.chckbxCheckClearart, this.chckbxCheckThumb, this.chckbxCheckLogo, this.chckbxCheckClearlogo, this.chckbxCheckDiscart);
        for (MediaArtwork.MediaArtworkType type : this.settings.getCheckImagesMovie()) {
            switch (type) {
                case POSTER: {
                    this.chckbxCheckPoster.setSelected(true);
                    break;
                }
                case BACKGROUND: {
                    this.chckbxCheckFanart.setSelected(true);
                    break;
                }
                case BANNER: {
                    this.chckbxCheckBanner.setSelected(true);
                    break;
                }
                case CLEARART: {
                    this.chckbxCheckClearart.setSelected(true);
                    break;
                }
                case THUMB: {
                    this.chckbxCheckThumb.setSelected(true);
                    break;
                }
                case LOGO: {
                    this.chckbxCheckLogo.setSelected(true);
                    break;
                }
                case CLEARLOGO: {
                    this.chckbxCheckClearlogo.setSelected(true);
                    break;
                }
                case DISC: {
                    this.chckbxCheckDiscart.setSelected(true);
                    break;
                }
            }
        }
        this.chckbxCheckPoster.addItemListener(this.checkBoxListener);
        this.chckbxCheckFanart.addItemListener(this.checkBoxListener);
        this.chckbxCheckBanner.addItemListener(this.checkBoxListener);
        this.chckbxCheckClearart.addItemListener(this.checkBoxListener);
        this.chckbxCheckThumb.addItemListener(this.checkBoxListener);
        this.chckbxCheckLogo.addItemListener(this.checkBoxListener);
        this.chckbxCheckClearlogo.addItemListener(this.checkBoxListener);
        this.chckbxCheckDiscart.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkbox : checkBoxes) {
            checkbox.setSelected(false);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][][15lp!][]"));
        JPanel panelUiSettings = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblUiSettings = new TmmLabel(BUNDLE.getString("Settings.ui"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelUiSettings, lblUiSettings, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        this.chckbxPersistUiFilters = new JCheckBox(BUNDLE.getString("Settings.movie.persistuifilter"));
        panelUiSettings.add((Component)this.chckbxPersistUiFilters, "cell 1 0 2 1");
        this.chckbxPersistUiSorting = new JCheckBox(BUNDLE.getString("Settings.movie.persistuisorting"));
        panelUiSettings.add((Component)this.chckbxPersistUiSorting, "cell 1 1 2 1");
        this.chckbxShowLogos = new JCheckBox(BUNDLE.getString("Settings.showlogos"));
        panelUiSettings.add((Component)this.chckbxShowLogos, "cell 1 2 2 1");
        JLabel lblRating = new JLabel(BUNDLE.getString("Settings.preferredrating"));
        panelUiSettings.add((Component)lblRating, "cell 1 3 2 1");
        this.cbRating = new AutocompleteComboBox<String>(Arrays.asList("imdb", "tmdb", "rottenTomatoes"));
        panelUiSettings.add(this.cbRating, "cell 1 3");
        this.chckbxPersonalRatingFirst = new JCheckBox(BUNDLE.getString("Settings.personalratingfirst"));
        panelUiSettings.add((Component)this.chckbxPersonalRatingFirst, "cell 2 4 2 1");
        JPanel panelAutomaticTasks = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblAutomaticTasksT = new TmmLabel(BUNDLE.getString("Settings.automatictasks"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelAutomaticTasks, lblAutomaticTasksT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        this.chckbxRenameAfterScrape = new JCheckBox(BUNDLE.getString("Settings.movie.automaticrename"));
        panelAutomaticTasks.add((Component)this.chckbxRenameAfterScrape, "cell 1 0 2 1");
        JLabel lblAutomaticRenameHint = new JLabel(IconManager.HINT);
        lblAutomaticRenameHint.setToolTipText(BUNDLE.getString("Settings.movie.automaticrename.desc"));
        panelAutomaticTasks.add((Component)lblAutomaticRenameHint, "cell 1 0 2 1");
        this.chckbxTraktSync = new JCheckBox(BUNDLE.getString("Settings.trakt"));
        panelAutomaticTasks.add((Component)this.chckbxTraktSync, "cell 1 1 2 1");
        this.btnClearTraktData = new JButton(BUNDLE.getString("Settings.trakt.clearmovies"));
        panelAutomaticTasks.add((Component)this.btnClearTraktData, "cell 1 1 2 1");
        JPanel panelMisc = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblMiscT = new TmmLabel(BUNDLE.getString("Settings.misc"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        this.chckbxBuildImageCache = new JCheckBox(BUNDLE.getString("Settings.imagecacheimport"));
        panelMisc.add((Component)this.chckbxBuildImageCache, "cell 1 0 2 1");
        JLabel lblBuildImageCacheHint = new JLabel(IconManager.HINT);
        lblBuildImageCacheHint.setToolTipText(BUNDLE.getString("Settings.imagecacheimporthint"));
        panelMisc.add((Component)lblBuildImageCacheHint, "cell 1 0 2 1");
        this.chckbxRuntimeFromMi = new JCheckBox(BUNDLE.getString("Settings.runtimefrommediafile"));
        panelMisc.add((Component)this.chckbxRuntimeFromMi, "cell 1 1 2 1");
        this.chckbxIncludeExternalAudioStreams = new JCheckBox(BUNDLE.getString("Settings.includeexternalstreamsinnfo"));
        panelMisc.add((Component)this.chckbxIncludeExternalAudioStreams, "cell 1 2 2 1");
        JLabel lblCheckImages = new JLabel(BUNDLE.getString("Settings.checkimages"));
        panelMisc.add((Component)lblCheckImages, "cell 1 3 2 1");
        JPanel panelCheckImages = new JPanel();
        panelCheckImages.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "", ""));
        panelMisc.add((Component)panelCheckImages, "cell 2 4");
        this.chckbxCheckPoster = new JCheckBox(BUNDLE.getString("mediafiletype.poster"));
        panelCheckImages.add((Component)this.chckbxCheckPoster, "cell 0 0");
        this.chckbxCheckFanart = new JCheckBox(BUNDLE.getString("mediafiletype.fanart"));
        panelCheckImages.add((Component)this.chckbxCheckFanart, "cell 1 0");
        this.chckbxCheckBanner = new JCheckBox(BUNDLE.getString("mediafiletype.banner"));
        panelCheckImages.add((Component)this.chckbxCheckBanner, "cell 2 0");
        this.chckbxCheckClearart = new JCheckBox(BUNDLE.getString("mediafiletype.clearart"));
        panelCheckImages.add((Component)this.chckbxCheckClearart, "cell 3 0");
        this.chckbxCheckThumb = new JCheckBox(BUNDLE.getString("mediafiletype.thumb"));
        panelCheckImages.add((Component)this.chckbxCheckThumb, "cell 4 0");
        this.chckbxCheckLogo = new JCheckBox(BUNDLE.getString("mediafiletype.logo"));
        panelCheckImages.add((Component)this.chckbxCheckLogo, "cell 5 0");
        this.chckbxCheckClearlogo = new JCheckBox(BUNDLE.getString("mediafiletype.clearlogo"));
        panelCheckImages.add((Component)this.chckbxCheckClearlogo, "cell 6 0");
        this.chckbxCheckDiscart = new JCheckBox(BUNDLE.getString("mediafiletype.disc"));
        panelCheckImages.add((Component)this.chckbxCheckDiscart, "cell 7 0");
        JPanel panelPresets = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][15lp][][][grow]", "[]"));
        TmmLabel lblPresets = new TmmLabel(BUNDLE.getString("Settings.preset"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelPresets, lblPresets, true);
        this.add((Component)collapsiblePanel, "cell 0 6,growx,wmin 0");
        JLabel lblPresetHintT = new JLabel(BUNDLE.getString("Settings.preset.desc"));
        panelPresets.add((Component)lblPresetHintT, "cell 1 0 3 1");
        this.btnPresetKodi = new JButton("Kodi v17+");
        panelPresets.add((Component)this.btnPresetKodi, "cell 2 1,growx");
        this.btnPresetXbmc = new JButton("XBMC/Kodi <v17");
        panelPresets.add((Component)this.btnPresetXbmc, "cell 3 1,growx");
        this.btnPresetMediaPortal1 = new JButton("MediaPortal 1.x");
        panelPresets.add((Component)this.btnPresetMediaPortal1, "cell 2 2,growx");
        this.btnPresetMediaPortal2 = new JButton("MediaPortal 2.x");
        panelPresets.add((Component)this.btnPresetMediaPortal2, "cell 3 2,growx");
        this.btnPresetPlex = new JButton("Plex");
        panelPresets.add((Component)this.btnPresetPlex, "cell 2 3,growx");
    }

    protected void initDataBindings() {
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"storeUiFilters");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.chckbxPersistUiFilters, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"renameAfterScrape");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, (Object)this.chckbxRenameAfterScrape, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"syncTrakt");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.chckbxTraktSync, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty movieSettingsBeanProperty_3 = BeanProperty.create((String)"buildImageCacheOnImport");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_3, (Object)this.chckbxBuildImageCache, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_4 = BeanProperty.create((String)"runtimeFromMediaInfo");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_4, (Object)this.chckbxRuntimeFromMi, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty movieSettingsBeanProperty_5 = BeanProperty.create((String)"storeUiSorting");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_5, (Object)this.chckbxPersistUiSorting, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSettingsBeanProperty_7 = BeanProperty.create((String)"preferPersonalRating");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_7, (Object)this.chckbxPersonalRatingFirst, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty movieSettingsBeanProperty_8 = BeanProperty.create((String)"preferredRating");
        BeanProperty autocompleteComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_8, this.cbRating, (Property)autocompleteComboBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty movieSettingsBeanProperty_9 = BeanProperty.create((String)"includeExternalAudioStreams");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_9, (Object)this.chckbxIncludeExternalAudioStreams, (Property)jCheckBoxBeanProperty);
        autoBinding_9.bind();
        BeanProperty movieSettingsBeanProperty_10 = BeanProperty.create((String)"showLogosPanel");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_10, (Object)this.chckbxShowLogos, (Property)jCheckBoxBeanProperty);
        autoBinding_10.bind();
    }
}

