/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.panels.MovieScraperMetadataPanel;

class MovieScraperOptionsSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -299825914193235308L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.SETTINGS;
    private JSlider sliderThreshold;
    private JCheckBox chckbxAutomaticallyScrapeImages;
    private JCheckBox chckbxImageLanguage;
    private JComboBox<MediaLanguages> cbScraperLanguage;
    private JComboBox<CountryCode> cbCertificationCountry;
    private JCheckBox chckbxScraperFallback;
    private JCheckBox chckbxCapitalizeWords;

    MovieScraperOptionsSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(100, new JLabel("1.0"));
        labelTable.put(75, new JLabel("0.75"));
        labelTable.put(50, new JLabel("0.50"));
        labelTable.put(25, new JLabel("0.25"));
        labelTable.put(0, new JLabel("0.0"));
        this.sliderThreshold.setLabelTable(labelTable);
        this.sliderThreshold.setValue((int)(this.settings.getScraperThreshold() * 100.0));
        this.sliderThreshold.addChangeListener(arg0 -> this.settings.setScraperThreshold((double)this.sliderThreshold.getValue() / 100.0));
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow,shrink 0]", "[][]15lp![][15lp!][][15lp!][]"));
        JPanel panelOptions = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblOptions = new TmmLabel(BUNDLE.getString("Settings.advancedoptions"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptions, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblScraperLanguage = new JLabel(BUNDLE.getString("Settings.preferredLanguage"));
        panelOptions.add((Component)lblScraperLanguage, "cell 1 0 2 1");
        this.cbScraperLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelOptions.add(this.cbScraperLanguage, "cell 1 0");
        JLabel lblCountry = new JLabel(BUNDLE.getString("Settings.certificationCountry"));
        panelOptions.add((Component)lblCountry, "cell 1 1 2 1");
        this.cbCertificationCountry = new JComboBox<CountryCode>(CountryCode.values());
        panelOptions.add(this.cbCertificationCountry, "cell 1 1");
        this.chckbxScraperFallback = new JCheckBox(BUNDLE.getString("Settings.scraperfallback"));
        panelOptions.add((Component)this.chckbxScraperFallback, "cell 1 2 2 1");
        this.chckbxCapitalizeWords = new JCheckBox(BUNDLE.getString("Settings.scraper.capitalizeWords"));
        panelOptions.add((Component)this.chckbxCapitalizeWords, "cell 1 3 2 1");
        JPanel panelDefaults = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblDefaultsT = new TmmLabel(BUNDLE.getString("scraper.metadata.defaults"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelDefaults, lblDefaultsT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        MovieScraperMetadataPanel movieScraperMetadataPanel = new MovieScraperMetadataPanel(this.settings.getMovieScraperMetadataConfig());
        panelDefaults.add((Component)movieScraperMetadataPanel, "cell 1 0 2 1,grow");
        JPanel panelImages = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblImagesT = new TmmLabel(BUNDLE.getString("Settings.images"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelImages, lblImagesT, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        this.chckbxAutomaticallyScrapeImages = new JCheckBox(BUNDLE.getString("Settings.default.autoscrape"));
        panelImages.add((Component)this.chckbxAutomaticallyScrapeImages, "cell 1 0 2 1");
        this.chckbxImageLanguage = new JCheckBox(BUNDLE.getString("Settings.default.autoscrape.language"));
        panelImages.add((Component)this.chckbxImageLanguage, "cell 1 1 2 1");
        JPanel panelAutomaticScrape = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][][300lp][grow]", ""));
        TmmLabel lblAutomaticScrapeT = new TmmLabel(BUNDLE.getString("Settings.automaticscraper"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelAutomaticScrape, lblAutomaticScrapeT, true);
        this.add((Component)collapsiblePanel, "cell 0 6,growx,wmin 0");
        JLabel lblScraperThreshold = new JLabel(BUNDLE.getString("Settings.scraperTreshold"));
        panelAutomaticScrape.add((Component)lblScraperThreshold, "cell 1 0,aligny top");
        this.sliderThreshold = new JSlider();
        this.sliderThreshold.setMinorTickSpacing(5);
        this.sliderThreshold.setMajorTickSpacing(10);
        this.sliderThreshold.setPaintTicks(true);
        this.sliderThreshold.setPaintLabels(true);
        panelAutomaticScrape.add((Component)this.sliderThreshold, "cell 2 0,growx,aligny top");
        ReadOnlyTextArea tpScraperThresholdHint = new ReadOnlyTextArea(BUNDLE.getString("Settings.scraperTreshold.hint"));
        TmmFontHelper.changeFont((JComponent)tpScraperThresholdHint, TmmFontHelper.L2);
        panelAutomaticScrape.add((Component)tpScraperThresholdHint, "cell 1 1 3 1,growx");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"scrapeBestImage");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxAutomaticallyScrapeImages, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxAutomaticallyScrapeImages, (Property)jCheckBoxBeanProperty, (Object)this.chckbxImageLanguage, (Property)jCheckBoxBeanProperty_1);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"imageLanguagePriority");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, (Object)this.chckbxImageLanguage, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"scraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"certificationCountry");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, this.cbCertificationCountry, (Property)jComboBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"scraperFallback");
        BeanProperty jCheckBoxBeanProperty_2 = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxScraperFallback, (Property)jCheckBoxBeanProperty_2);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"capitalWordsInTitles");
        BeanProperty jCheckBoxBeanProperty_3 = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.chckbxCapitalizeWords, (Property)jCheckBoxBeanProperty_3);
        autoBinding_2.bind();
    }
}

