/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.TmmLabel;

class MovieImageExtraPanel
extends JPanel {
    private static final long serialVersionUID = 7312645402037806284L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.SETTINGS;
    private JCheckBox cbActorImages;
    private JCheckBox chckbxEnableExtrathumbs;
    private JCheckBox chckbxEnableExtrafanart;
    private JCheckBox chckbxResizeExtrathumbsTo;
    private JSpinner spExtrathumbWidth;
    private JSpinner spDownloadCountExtrathumbs;
    private JSpinner spDownloadCountExtrafanart;
    private JCheckBox chckbxStoreMoviesetArtwork;
    private JTextField tfMovieSetArtworkFolder;
    private JCheckBox chckbxMovieSetArtwork;
    private JButton btnSelectFolder;

    MovieImageExtraPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnSelectFolder.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("movieset.folderchooser.path");
            Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.movieset.folderchooser"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                this.tfMovieSetArtworkFolder.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("movieset.folderchooser.path", file.toAbsolutePath().toString());
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JPanel panelExtra = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp][grow]", ""));
        TmmLabel lblExtra = new TmmLabel(BUNDLE.getString("Settings.extraartwork"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelExtra, lblExtra, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.chckbxEnableExtrathumbs = new JCheckBox(BUNDLE.getString("Settings.enable.extrathumbs"));
        panelExtra.add((Component)this.chckbxEnableExtrathumbs, "cell 1 0 2 1");
        this.chckbxResizeExtrathumbsTo = new JCheckBox(BUNDLE.getString("Settings.resize.extrathumbs"));
        panelExtra.add((Component)this.chckbxResizeExtrathumbsTo, "cell 2 1");
        this.spExtrathumbWidth = new JSpinner();
        this.spExtrathumbWidth.setMinimumSize(new Dimension(60, 20));
        panelExtra.add((Component)this.spExtrathumbWidth, "cell 2 1");
        JLabel lblDownload = new JLabel(BUNDLE.getString("Settings.amount.autodownload"));
        panelExtra.add((Component)lblDownload, "cell 2 2");
        this.spDownloadCountExtrathumbs = new JSpinner();
        this.spDownloadCountExtrathumbs.setMinimumSize(new Dimension(60, 20));
        panelExtra.add((Component)this.spDownloadCountExtrathumbs, "cell 2 2");
        this.chckbxEnableExtrafanart = new JCheckBox(BUNDLE.getString("Settings.enable.extrafanart"));
        panelExtra.add((Component)this.chckbxEnableExtrafanart, "cell 1 3 2 1");
        JLabel lblDownloadCount = new JLabel(BUNDLE.getString("Settings.amount.autodownload"));
        panelExtra.add((Component)lblDownloadCount, "cell 2 4");
        this.spDownloadCountExtrafanart = new JSpinner();
        this.spDownloadCountExtrafanart.setMinimumSize(new Dimension(60, 20));
        panelExtra.add((Component)this.spDownloadCountExtrafanart, "cell 2 4");
        this.cbActorImages = new JCheckBox(BUNDLE.getString("Settings.actor.download"));
        panelExtra.add((Component)this.cbActorImages, "cell 1 5 2 1");
        this.chckbxMovieSetArtwork = new JCheckBox(BUNDLE.getString("Settings.movieset.store.movie"));
        panelExtra.add((Component)this.chckbxMovieSetArtwork, "cell 1 6 2 1");
        this.chckbxStoreMoviesetArtwork = new JCheckBox(BUNDLE.getString("Settings.movieset.store"));
        panelExtra.add((Component)this.chckbxStoreMoviesetArtwork, "cell 1 7 2 1");
        JLabel lblFoldername = new JLabel(BUNDLE.getString("Settings.movieset.foldername"));
        panelExtra.add((Component)lblFoldername, "cell 2 8");
        this.tfMovieSetArtworkFolder = new JTextField();
        panelExtra.add((Component)this.tfMovieSetArtworkFolder, "cell 2 8");
        this.tfMovieSetArtworkFolder.setColumns(40);
        this.btnSelectFolder = new JButton(BUNDLE.getString("Settings.movieset.buttonselect"));
        panelExtra.add((Component)this.btnSelectFolder, "cell 2 8");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"writeActorImages");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.cbActorImages, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"imageExtraFanart");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"imageExtraThumbs");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"imageExtraThumbsSize");
        BeanProperty jSpinnerBeanProperty_1 = BeanProperty.create((String)"value");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, (Object)this.spExtrathumbWidth, (Property)jSpinnerBeanProperty_1);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"imageExtraThumbsResize");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, (Object)this.chckbxResizeExtrathumbsTo, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"imageExtraThumbsCount");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, (Object)this.spDownloadCountExtrathumbs, (Property)jSpinnerBeanProperty_1);
        autoBinding_12.bind();
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"imageExtraFanartCount");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, (Object)this.spDownloadCountExtrafanart, (Property)jSpinnerBeanProperty_1);
        autoBinding_13.bind();
        BeanProperty jSpinnerBeanProperty = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.spDownloadCountExtrafanart, (Property)jSpinnerBeanProperty);
        autoBinding_14.bind();
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty, (Object)this.spDownloadCountExtrathumbs, (Property)jSpinnerBeanProperty);
        autoBinding_15.bind();
        BeanProperty settingsBeanProperty_12 = BeanProperty.create((String)"movieSetArtworkFolder");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_16 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_12, (Object)this.tfMovieSetArtworkFolder, (Property)jTextFieldBeanProperty);
        autoBinding_16.bind();
        BeanProperty settingsBeanProperty_13 = BeanProperty.create((String)"enableMovieSetArtworkFolder");
        AutoBinding autoBinding_17 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_13, (Object)this.chckbxStoreMoviesetArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_17.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty, (Object)this.chckbxResizeExtrathumbsTo, (Property)jCheckBoxBeanProperty_1);
        autoBinding_8.bind();
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty, (Object)this.spExtrathumbWidth, (Property)jSpinnerBeanProperty);
        autoBinding_9.bind();
        BeanProperty settingsBeanProperty_18 = BeanProperty.create((String)"enableMovieSetArtworkMovieFolder");
        AutoBinding autoBinding_22 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_18, (Object)this.chckbxMovieSetArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_22.bind();
    }
}

