/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.TmmLabel;

class MovieDatasourceSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -7580437046944123496L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.SETTINGS;
    private JTextField tfAddBadword;
    private JList<String> listBadWords;
    private JList<String> listDatasources;
    private JList<String> listSkipFolder;
    private JButton btnRemoveDatasource;
    private JButton btnAddDatasource;
    private JButton btnAddSkipFolder;
    private JButton btnRemoveSkipFolder;
    private JButton btnRemoveBadWord;
    private JButton btnAddBadWord;

    MovieDatasourceSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnRemoveDatasource.addActionListener(arg0 -> {
            int row = this.listDatasources.getSelectedIndex();
            if (row != -1) {
                String path = MovieModuleManager.SETTINGS.getMovieDataSource().get(row);
                Object[] choices = new String[]{BUNDLE.getString("Button.continue"), BUNDLE.getString("Button.abort")};
                int decision = JOptionPane.showOptionDialog(null, String.format(BUNDLE.getString("Settings.movie.datasource.remove.info"), path), BUNDLE.getString("Settings.datasource.remove"), 0, -1, null, choices, BUNDLE.getString("Button.abort"));
                if (decision == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    MovieModuleManager.SETTINGS.removeMovieDataSources(path);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.btnAddDatasource.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("movie.datasource.path");
            Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.datasource.folderchooser"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                this.settings.addMovieDataSources(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("movie.datasource.path", file.toAbsolutePath().toString());
            }
        });
        this.btnAddSkipFolder.addActionListener(e -> {
            String path = TmmProperties.getInstance().getProperty("movie.ignore.path");
            Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.ignore"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                this.settings.addSkipFolder(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("movie.ignore.path", file.toAbsolutePath().toString());
            }
        });
        this.btnRemoveSkipFolder.addActionListener(e -> {
            int row = this.listSkipFolder.getSelectedIndex();
            if (row != -1) {
                String ingore = this.settings.getSkipFolder().get(row);
                this.settings.removeSkipFolder(ingore);
            }
        });
        this.btnAddBadWord.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfAddBadword.getText())) {
                MovieModuleManager.SETTINGS.addBadWord(this.tfAddBadword.getText());
                this.tfAddBadword.setText("");
            }
        });
        this.btnRemoveBadWord.addActionListener(arg0 -> {
            int row = this.listBadWords.getSelectedIndex();
            if (row != -1) {
                String badWord = MovieModuleManager.SETTINGS.getBadWord().get(row);
                MovieModuleManager.SETTINGS.removeBadWord(badWord);
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][]"));
        JPanel panelDatasources = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][400lp][][grow]", "[150lp,grow]"));
        TmmLabel lblDatasourcesT = new TmmLabel(BUNDLE.getString("Settings.source"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelDatasources, lblDatasourcesT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JScrollPane scrollPaneDataSources = new JScrollPane();
        panelDatasources.add((Component)scrollPaneDataSources, "cell 1 0,grow");
        this.listDatasources = new JList();
        this.listDatasources.setSelectionMode(0);
        scrollPaneDataSources.setViewportView(this.listDatasources);
        this.btnAddDatasource = new JButton(IconManager.ADD_INV);
        panelDatasources.add((Component)this.btnAddDatasource, "flowy, cell 2 0, aligny top, growx");
        this.btnAddDatasource.setToolTipText(BUNDLE.getString("Button.add"));
        this.btnRemoveDatasource = new JButton(IconManager.REMOVE_INV);
        panelDatasources.add((Component)this.btnRemoveDatasource, "flowy, cell 2 0, aligny top, growx");
        this.btnRemoveDatasource.setToolTipText(BUNDLE.getString("Button.remove"));
        JPanel panelIgnore = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][400lp][][grow]", "[100lp,grow]"));
        TmmLabel lblIgnoreT = new TmmLabel(BUNDLE.getString("Settings.ignore"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelIgnore, lblIgnoreT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        JScrollPane scrollPaneIgnore = new JScrollPane();
        panelIgnore.add((Component)scrollPaneIgnore, "cell 1 0,grow");
        this.listSkipFolder = new JList();
        scrollPaneIgnore.setViewportView(this.listSkipFolder);
        this.btnAddSkipFolder = new JButton(IconManager.ADD_INV);
        panelIgnore.add((Component)this.btnAddSkipFolder, "flowy, cell 2 0, aligny top, growx");
        this.btnAddSkipFolder.setToolTipText(BUNDLE.getString("Settings.addignore"));
        this.btnRemoveSkipFolder = new JButton(IconManager.REMOVE_INV);
        panelIgnore.add((Component)this.btnRemoveSkipFolder, "flowy, cell 2 0, aligny top, growx");
        this.btnRemoveSkipFolder.setToolTipText(BUNDLE.getString("Settings.removeignore"));
        JPanel panelBadWords = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][100lp][][grow]", "[][100lp,grow][]"));
        TmmLabel lblBadWordsT = new TmmLabel(BUNDLE.getString("Settings.movie.badwords"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelBadWords, lblBadWordsT, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        JLabel lblBadWordsDesc = new JLabel(BUNDLE.getString("Settings.movie.badwords.hint"));
        panelBadWords.add((Component)lblBadWordsDesc, "cell 1 0 3 1");
        JScrollPane scrollPaneBadWords = new JScrollPane();
        panelBadWords.add((Component)scrollPaneBadWords, "cell 1 1,grow");
        this.listBadWords = new JList();
        scrollPaneBadWords.setViewportView(this.listBadWords);
        this.btnRemoveBadWord = new JButton(IconManager.REMOVE_INV);
        panelBadWords.add((Component)this.btnRemoveBadWord, "cell 2 1,aligny bottom");
        this.btnRemoveBadWord.setToolTipText(BUNDLE.getString("Button.remove"));
        this.tfAddBadword = new JTextField();
        panelBadWords.add((Component)this.tfAddBadword, "cell 1 2,growx");
        this.btnAddBadWord = new JButton(IconManager.ADD_INV);
        panelBadWords.add((Component)this.btnAddBadWord, "cell 2 2, growx");
        this.btnAddBadWord.setToolTipText(BUNDLE.getString("Button.add"));
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"badWord");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, this.listBadWords);
        jListBinding.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"movieDataSource");
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, this.listDatasources);
        jListBinding_1.bind();
        BeanProperty settingsBeanProperty_12 = BeanProperty.create((String)"skipFolder");
        JListBinding jListBinding_2 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_12, this.listSkipFolder);
        jListBinding_2.bind();
    }
}

