/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.panels;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.StarRater;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.converter.RatingConverter;
import org.tinymediamanager.ui.converter.RuntimeConverter;
import org.tinymediamanager.ui.converter.VoteCountConverter;
import org.tinymediamanager.ui.converter.ZeroIdConverter;
import org.tinymediamanager.ui.movies.MovieOtherIdsConverter;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.panels.MovieDetailsPanel;
import org.tinymediamanager.ui.panels.MediaInformationLogosPanel;

public class MovieInformationPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieInformationPanel.class);
    private static final long serialVersionUID = -8527284262749511617L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.SETTINGS;
    private MovieSelectionModel movieSelectionModel;
    private final ImageIcon imageEmtpy = new ImageIcon();
    private ImageIcon imageUnwatched;
    private StarRater starRater;
    private JLabel lblMovieName;
    private JLabel lblRating;
    private JLabel lblVoteCount;
    private JLabel lblTagline;
    private JLabel lblYear;
    private LinkLabel lblImdbid;
    private JLabel lblRunningTime;
    private LinkLabel lblTmdbid;
    private JLabel lblGenres;
    private JTextArea taPlot;
    private ImageLabel lblMoviePoster;
    private JLabel lblPosterSize;
    private ImageLabel lblMovieFanart;
    private JLabel lblFanartSize;
    private JLabel lblCertification;
    private JLabel lblOtherIds;
    private MediaInformationLogosPanel panelLogos;
    private JSeparator sepLogos;
    private JLabel lblOriginalTitle;
    private JButton btnPlay;

    public MovieInformationPanel(MovieSelectionModel movieSelectionModel) {
        this.movieSelectionModel = movieSelectionModel;
        try {
            this.imageUnwatched = new ImageIcon(MovieInformationPanel.class.getResource("/org/tinymediamanager/ui/images/unwatched.png"));
        }
        catch (Exception e2) {
            this.imageUnwatched = this.imageEmtpy;
        }
        this.initComponents();
        this.initDataBindings();
        this.lblTmdbid.addActionListener(arg0 -> {
            String url = "http://www.themoviedb.org/movie/" + this.lblTmdbid.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to tmdbid", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblImdbid.addActionListener(arg0 -> {
            String url = "http://www.imdb.com/title/" + this.lblImdbid.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to imdbid", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            Movie movie;
            MovieSelectionModel selectionModel;
            Movie movie2;
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source instanceof MovieSelectionModel && (movie2 = (selectionModel = (MovieSelectionModel)source).getSelectedMovie()) != null && movie2 != selectionModel.initialMovie) {
                this.setPoster(movie2);
                this.setFanart(movie2);
                this.panelLogos.setMediaInformationSource(movie2);
            }
            if ((source instanceof Movie || source instanceof MediaFile) && (movie = movieSelectionModel.getSelectedMovie()) != null) {
                this.panelLogos.setMediaInformationSource(movie);
            }
            if (source instanceof Movie && "fanart".equals(property)) {
                movie = (Movie)source;
                this.setFanart(movie);
            }
            if (source instanceof Movie && "poster".equals(property)) {
                movie = (Movie)source;
                this.setPoster(movie);
            }
        };
        movieSelectionModel.addPropertyChangeListener(propertyChangeListener);
        this.btnPlay.addActionListener(e -> {
            MediaFile mf = movieSelectionModel.getSelectedMovie().getMainVideoFile();
            if (StringUtils.isNotBlank((CharSequence)mf.getFilename())) {
                try {
                    TmmUIHelper.openFile(mf.getFileAsPath());
                }
                catch (Exception ex) {
                    LOGGER.error("open file", (Object)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
    }

    private void initComponents() {
        this.putClientProperty("class", "roundedPanel");
        this.setLayout((LayoutManager)new MigLayout("", "[100lp:100lp,grow][300lp:300lp,grow 350]", "[200lp:n,grow][][shrink 0][][]"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new ColumnLayout());
        this.add((Component)panelLeft, "cell 0 0 1 5,grow");
        this.lblMoviePoster = new ImageLabel(false, false, true);
        this.lblMoviePoster.setDesiredAspectRatio(0.6666667f);
        this.lblMoviePoster.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblMoviePoster);
        this.lblMoviePoster.enableLightbox();
        this.lblPosterSize = new JLabel(BUNDLE.getString("mediafiletype.poster"));
        panelLeft.add(this.lblPosterSize);
        panelLeft.add(Box.createVerticalStrut(20));
        this.lblMovieFanart = new ImageLabel(false, false, true);
        this.lblMovieFanart.setDesiredAspectRatio(1.7777778f);
        this.lblMovieFanart.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblMovieFanart);
        this.lblMovieFanart.enableLightbox();
        this.lblFanartSize = new JLabel(BUNDLE.getString("mediafiletype.fanart"));
        panelLeft.add(this.lblFanartSize);
        JPanel panelTopRight = new JPanel();
        this.add((Component)panelTopRight, "cell 1 0,grow");
        panelTopRight.setLayout((LayoutManager)new MigLayout("insets 0 n n n, hidemode 2", "[grow][]", "[][][shrink 0][][shrink 0][][shrink 0][][shrink 0][][][][20lp:40lp,grow]"));
        this.lblMovieName = new TmmLabel("", 1.33);
        panelTopRight.add((Component)this.lblMovieName, "flowx,cell 0 0,wmin 0,grow");
        this.btnPlay = new FlatButton(IconManager.PLAY_LARGE);
        panelTopRight.add((Component)this.btnPlay, "cell 1 0 1 2,aligny top");
        this.lblOriginalTitle = new JLabel("");
        panelTopRight.add((Component)this.lblOriginalTitle, "cell 0 1,growx,wmin 0");
        panelTopRight.add((Component)new JSeparator(), "cell 0 2 2 1,growx");
        JPanel panelTopDetails = new JPanel();
        panelTopRight.add((Component)panelTopDetails, "cell 0 3 2 1,grow");
        panelTopDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][grow][][grow 200]", "[]2lp[]2lp[]2lp[]"));
        TmmLabel lblYearT = new TmmLabel(BUNDLE.getString("metatag.year"));
        panelTopDetails.add((Component)lblYearT, "cell 0 0");
        this.lblYear = new JLabel("");
        panelTopDetails.add((Component)this.lblYear, "cell 1 0,growx");
        TmmLabel lblImdbIdT = new TmmLabel(BUNDLE.getString("metatag.imdb"));
        panelTopDetails.add((Component)lblImdbIdT, "cell 2 0");
        this.lblImdbid = new LinkLabel("");
        panelTopDetails.add((Component)this.lblImdbid, "cell 3 0");
        TmmLabel lblCertificationT = new TmmLabel(BUNDLE.getString("metatag.certification"));
        panelTopDetails.add((Component)lblCertificationT, "cell 0 1");
        this.lblCertification = new JLabel("");
        panelTopDetails.add((Component)this.lblCertification, "cell 1 1,growx");
        TmmLabel lblTmdbIdT = new TmmLabel(BUNDLE.getString("metatag.tmdb"));
        panelTopDetails.add((Component)lblTmdbIdT, "cell 2 1");
        this.lblTmdbid = new LinkLabel("");
        panelTopDetails.add((Component)this.lblTmdbid, "cell 3 1");
        TmmLabel lblRunningTimeT = new TmmLabel(BUNDLE.getString("metatag.runtime"));
        panelTopDetails.add((Component)lblRunningTimeT, "cell 0 2");
        this.lblRunningTime = new JLabel("");
        panelTopDetails.add((Component)this.lblRunningTime, "cell 1 2");
        TmmLabel lblOtherIdsT = new TmmLabel(BUNDLE.getString("metatag.otherids"));
        panelTopDetails.add((Component)lblOtherIdsT, "cell 2 2");
        this.lblOtherIds = new JLabel("");
        panelTopDetails.add((Component)this.lblOtherIds, "cell 3 2, wmin 0");
        TmmLabel lblGenresT = new TmmLabel(BUNDLE.getString("metatag.genre"));
        panelTopDetails.add((Component)lblGenresT, "cell 0 3");
        this.lblGenres = new JLabel("");
        panelTopDetails.add((Component)this.lblGenres, "cell 1 3 3 1, growx, wmin 0");
        panelTopRight.add((Component)new JSeparator(), "cell 0 4 2 1,growx");
        this.starRater = new StarRater(10, 1);
        panelTopRight.add((Component)this.starRater, "flowx,cell 0 5 2 1,aligny center");
        this.starRater.setEnabled(false);
        this.lblRating = new JLabel("");
        panelTopRight.add((Component)this.lblRating, "cell 0 5,aligny center");
        this.lblVoteCount = new JLabel("");
        panelTopRight.add((Component)this.lblVoteCount, "cell 0 5,aligny center");
        this.sepLogos = new JSeparator();
        panelTopRight.add((Component)this.sepLogos, "cell 0 6 2 1,growx");
        this.panelLogos = new MediaInformationLogosPanel();
        panelTopRight.add((Component)this.panelLogos, "cell 0 7 2 1,wmin 0");
        panelTopRight.add((Component)new JSeparator(), "cell 0 8 2 1,growx");
        TmmLabel lblTaglineT = new TmmLabel(BUNDLE.getString("metatag.tagline"));
        panelTopRight.add((Component)lblTaglineT, "cell 0 9 2 1,alignx left,aligny top");
        this.lblTagline = new JLabel();
        panelTopRight.add((Component)this.lblTagline, "cell 0 10 2 1,growx,wmin 0,aligny top");
        TmmLabel lblPlotT = new TmmLabel(BUNDLE.getString("metatag.plot"));
        panelTopRight.add((Component)lblPlotT, "cell 0 11 2 1,alignx left,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(null);
        panelTopRight.add((Component)scrollPane, "cell 0 12 2 1,grow");
        this.taPlot = new ReadOnlyTextArea();
        this.taPlot.setBorder(null);
        scrollPane.setViewportView(this.taPlot);
        this.add((Component)new JSeparator(), "cell 1 2,growx");
        MovieDetailsPanel panelBottomRight = new MovieDetailsPanel(this.movieSelectionModel);
        this.add((Component)panelBottomRight, "cell 1 4,grow");
    }

    private void setPoster(Movie movie) {
        this.lblMoviePoster.clearImage();
        this.lblMoviePoster.setImagePath(movie.getArtworkFilename(MediaFileType.POSTER));
        Dimension posterSize = movie.getArtworkDimension(MediaFileType.POSTER);
        if (posterSize.width > 0 && posterSize.height > 0) {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster") + " - " + posterSize.width + "x" + posterSize.height);
        } else {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster"));
        }
    }

    private void setFanart(Movie movie) {
        this.lblMovieFanart.clearImage();
        this.lblMovieFanart.setImagePath(movie.getArtworkFilename(MediaFileType.FANART));
        Dimension fanartSize = movie.getArtworkDimension(MediaFileType.FANART);
        if (fanartSize.width > 0 && fanartSize.height > 0) {
            this.lblFanartSize.setText(BUNDLE.getString("mediafiletype.fanart") + " - " + fanartSize.width + "x" + fanartSize.height);
        } else {
            this.lblFanartSize.setText(BUNDLE.getString("mediafiletype.fanart"));
        }
    }

    protected void initDataBindings() {
        BeanProperty movieSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedMovie.rating.votes");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_2, (Object)this.lblVoteCount, (Property)jLabelBeanProperty);
        autoBinding_2.setConverter((Converter)new VoteCountConverter());
        autoBinding_2.bind();
        BeanProperty movieSelectionModelBeanProperty_8 = BeanProperty.create((String)"selectedMovie.year");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_8, (Object)this.lblYear, (Property)jLabelBeanProperty);
        autoBinding_9.bind();
        BeanProperty movieSelectionModelBeanProperty_12 = BeanProperty.create((String)"selectedMovie.imdbId");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_12, (Object)this.lblImdbid, (Property)jLabelBeanProperty);
        autoBinding_10.bind();
        BeanProperty movieSelectionModelBeanProperty_13 = BeanProperty.create((String)"selectedMovie.runtime");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_13, (Object)this.lblRunningTime, (Property)jLabelBeanProperty);
        autoBinding_14.setConverter((Converter)new RuntimeConverter());
        autoBinding_14.bind();
        BeanProperty movieSelectionModelBeanProperty_15 = BeanProperty.create((String)"selectedMovie.tmdbId");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_15, (Object)this.lblTmdbid, (Property)jLabelBeanProperty);
        autoBinding_7.setConverter((Converter)new ZeroIdConverter());
        autoBinding_7.bind();
        BeanProperty movieSelectionModelBeanProperty_16 = BeanProperty.create((String)"selectedMovie.genresAsString");
        AutoBinding autoBinding_17 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_16, (Object)this.lblGenres, (Property)jLabelBeanProperty);
        autoBinding_17.bind();
        BeanProperty movieSelectionModelBeanProperty_14 = BeanProperty.create((String)"selectedMovie.plot");
        BeanProperty jTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_18 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_14, (Object)this.taPlot, (Property)jTextAreaBeanProperty);
        autoBinding_18.bind();
        BeanProperty movieSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedMovie.tagline");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_3, (Object)this.lblTagline, (Property)jLabelBeanProperty);
        autoBinding_4.bind();
        BeanProperty movieSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedMovie.title");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_4, (Object)this.lblMovieName, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovie.certification.name");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty, (Object)this.lblCertification, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty movieSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedMovie.originalTitle");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_6, (Object)this.lblOriginalTitle, (Property)jLabelBeanProperty);
        autoBinding_8.bind();
        BeanProperty movieSelectionModelBeanProperty_5 = BeanProperty.create((String)"selectedMovie.ids");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_5, (Object)this.lblOtherIds, (Property)jLabelBeanProperty);
        autoBinding_6.setConverter((Converter)new MovieOtherIdsConverter());
        autoBinding_6.bind();
        BeanProperty movieSelectionModelBeanProperty_7 = BeanProperty.create((String)"selectedMovie.rating.ratingNormalized");
        BeanProperty starRaterBeanProperty = BeanProperty.create((String)"rating");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_7, (Object)this.starRater, (Property)starRaterBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSelectionModelBeanProperty_9 = BeanProperty.create((String)"selectedMovie.rating");
        BeanProperty jLabelBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_9, (Object)this.lblRating, (Property)jLabelBeanProperty_1);
        autoBinding_1.setConverter((Converter)new RatingConverter());
        autoBinding_1.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"showLogosPanel");
        BeanProperty jSeparatorBeanProperty = BeanProperty.create((String)"visible");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.sepLogos, (Property)jSeparatorBeanProperty);
        autoBinding_11.bind();
        BeanProperty mediaInformationLogosPanelBeanProperty = BeanProperty.create((String)"visible");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.panelLogos, (Property)mediaInformationLogosPanelBeanProperty);
        autoBinding_12.bind();
    }
}

