/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.panels.ImagePanel;

public class MovieArtworkPanel
extends JPanel {
    private static final long serialVersionUID = -7478111154774646873L;
    private final List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    private ImagePanel imagePanel;

    public MovieArtworkPanel(MovieSelectionModel selectionModel) {
        this.initComponents();
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source instanceof MovieSelectionModel || source instanceof Movie && "mediaFiles".equals(property)) {
                List<MediaFile> list = this.mediaFiles;
                synchronized (list) {
                    this.mediaFiles.clear();
                    for (MediaFile mediafile : selectionModel.getSelectedMovie().getMediaFiles()) {
                        if (!mediafile.isGraphic()) continue;
                        this.mediaFiles.add(mediafile);
                    }
                    this.imagePanel.rebuildPanel();
                }
            }
        };
        selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[400lp,grow]", "[300lp:400lp,grow]"));
        this.imagePanel = new ImagePanel(this.mediaFiles);
        this.imagePanel.setMaxWidth(400);
        this.imagePanel.setMaxHeight(200);
        this.add((Component)this.imagePanel, "cell 0 0,grow");
    }
}

