/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieTagFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private TmmTableFormat.StringComparator comparator;
    private MovieList movieList = MovieList.getInstance();

    public MovieTagFilter() {
        this.comparator = new TmmTableFormat.StringComparator();
        this.buildAndInstallTagsArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallTagsArray();
        this.movieList.addPropertyChangeListener("tag", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "movieTag";
    }

    @Override
    public boolean accept(Movie movie) {
        List tags = this.checkComboBox.getSelectedItems();
        if (tags.isEmpty() && movie.getTags().isEmpty()) {
            return true;
        }
        for (String tag : movie.getTags()) {
            if (!tags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("movieextendedsearch.tag"));
    }

    private void buildAndInstallTagsArray() {
        ArrayList<String> tags = new ArrayList<String>(this.movieList.getTagsInMovies());
        tags.sort(this.comparator);
        this.setValues(tags);
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

