/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieMediaSourceFilter
extends AbstractCheckComboBoxMovieUIFilter<MediaSource> {
    public MovieMediaSourceFilter() {
        this.setValues(MediaSource.values());
        MediaSource.addListener(evt -> SwingUtilities.invokeLater(() -> this.setValues(MediaSource.values())));
    }

    @Override
    public String getId() {
        return "movieMediaSource";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains((Object)movie.getMediaSource());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.source"));
    }

    @Override
    protected String parseTypeToString(MediaSource type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaSource parseStringToType(String string) throws Exception {
        return MediaSource.getMediaSource(string);
    }
}

