/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieEditionFilter
extends AbstractCheckComboBoxMovieUIFilter<MovieEdition> {
    private final MovieEdition.MovieEditionComparator comparator = new MovieEdition.MovieEditionComparator();

    public MovieEditionFilter() {
        this.buildAndInstallEditionArray();
        MovieEdition.addListener(evt -> SwingUtilities.invokeLater(this::buildAndInstallEditionArray));
    }

    @Override
    public String getId() {
        return "movieCertification";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains((Object)movie.getEdition());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.edition"));
    }

    private void buildAndInstallEditionArray() {
        ArrayList<MovieEdition> editions = new ArrayList<MovieEdition>();
        for (MovieEdition movieEdition : MovieEdition.values()) {
            if (!StringUtils.isNotBlank((CharSequence)movieEdition.toString())) continue;
            editions.add(movieEdition);
        }
        editions.sort(this.comparator);
        this.setValues(editions);
    }

    @Override
    protected String parseTypeToString(MovieEdition type) throws Exception {
        return type.name();
    }

    @Override
    protected MovieEdition parseStringToType(String string) throws Exception {
        return MovieEdition.getMovieEditionFromString(string);
    }
}

