/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.MediaScraperComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.panels.MovieScraperMetadataPanel;

public class MovieScrapeMetadataDialog
extends TmmDialog {
    private static final long serialVersionUID = 3826984454317979241L;
    private MovieSearchAndScrapeOptions movieSearchAndScrapeConfig = new MovieSearchAndScrapeOptions();
    private MediaScraperComboBox cbMetadataScraper;
    private MediaScraperCheckComboBox cbArtworkScraper;
    private MediaScraperCheckComboBox cbTrailerScraper;
    private boolean startScrape = false;

    public MovieScrapeMetadataDialog(String title) {
        super(title, "updateMetadata");
        MediaScraper defaultScraper = MediaScraper.getMediaScraperById(MovieModuleManager.SETTINGS.getMovieScraper(), ScraperType.MOVIE);
        ArrayList<MediaScraper> selectedArtworkScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper mediaScraper : MovieList.getInstance().getAvailableArtworkScrapers()) {
            if (!MovieModuleManager.SETTINGS.getArtworkScrapers().contains(mediaScraper.getId())) continue;
            selectedArtworkScrapers.add(mediaScraper);
        }
        ArrayList<MediaScraper> selectedTrailerScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper trailerScraper : MovieList.getInstance().getAvailableTrailerScrapers()) {
            if (!MovieModuleManager.SETTINGS.getTrailerScrapers().contains(trailerScraper.getId())) continue;
            selectedTrailerScrapers.add(trailerScraper);
        }
        MovieScraperMetadataConfig movieScraperMetadataConfig = MovieModuleManager.SETTINGS.getMovieScraperMetadataConfig();
        MovieScraperMetadataConfig scraperMetadataConfig = new MovieScraperMetadataConfig();
        scraperMetadataConfig.setTitle(movieScraperMetadataConfig.isTitle());
        scraperMetadataConfig.setOriginalTitle(movieScraperMetadataConfig.isOriginalTitle());
        scraperMetadataConfig.setTagline(movieScraperMetadataConfig.isTagline());
        scraperMetadataConfig.setPlot(movieScraperMetadataConfig.isPlot());
        scraperMetadataConfig.setRating(movieScraperMetadataConfig.isRating());
        scraperMetadataConfig.setRuntime(movieScraperMetadataConfig.isRuntime());
        scraperMetadataConfig.setYear(movieScraperMetadataConfig.isYear());
        scraperMetadataConfig.setCertification(movieScraperMetadataConfig.isCertification());
        scraperMetadataConfig.setCast(movieScraperMetadataConfig.isCast());
        scraperMetadataConfig.setCountry(movieScraperMetadataConfig.isCountry());
        scraperMetadataConfig.setStudio(movieScraperMetadataConfig.isStudio());
        scraperMetadataConfig.setGenres(movieScraperMetadataConfig.isGenres());
        scraperMetadataConfig.setArtwork(movieScraperMetadataConfig.isArtwork());
        scraperMetadataConfig.setTrailer(movieScraperMetadataConfig.isTrailer());
        scraperMetadataConfig.setCollection(movieScraperMetadataConfig.isCollection());
        scraperMetadataConfig.setTags(movieScraperMetadataConfig.isTags());
        this.movieSearchAndScrapeConfig.setScraperMetadataConfig(scraperMetadataConfig);
        JPanel panelCenter = new JPanel();
        this.getContentPane().add((Component)panelCenter, "Center");
        panelCenter.setLayout((LayoutManager)new MigLayout("", "[][300lp,grow]", "[][][][20lp:n][shrink 0][][]"));
        TmmLabel lblMetadataScraperT = new TmmLabel(BUNDLE.getString("scraper.metadata"));
        panelCenter.add((Component)lblMetadataScraperT, "cell 0 0,alignx right");
        this.cbMetadataScraper = new MediaScraperComboBox(MovieList.getInstance().getAvailableMediaScrapers());
        panelCenter.add((Component)this.cbMetadataScraper, "cell 1 0,growx");
        this.cbMetadataScraper.setSelectedItem(defaultScraper);
        TmmLabel lblArtworkScraper = new TmmLabel(BUNDLE.getString("scraper.artwork"));
        panelCenter.add((Component)lblArtworkScraper, "cell 0 1,alignx right");
        this.cbArtworkScraper = new MediaScraperCheckComboBox(MovieList.getInstance().getAvailableArtworkScrapers());
        panelCenter.add((Component)this.cbArtworkScraper, "cell 1 1,growx");
        TmmLabel lblTrailerScraper = new TmmLabel(BUNDLE.getString("scraper.trailer"));
        panelCenter.add((Component)lblTrailerScraper, "cell 0 2,alignx right");
        this.cbTrailerScraper = new MediaScraperCheckComboBox(MovieList.getInstance().getAvailableTrailerScrapers());
        panelCenter.add((Component)this.cbTrailerScraper, "cell 1 2,growx");
        JSeparator separator = new JSeparator();
        panelCenter.add((Component)separator, "cell 0 4 2 1,growx");
        TmmLabel lblScrapeFollowingItems = new TmmLabel(BUNDLE.getString("scraper.metadata.select"));
        panelCenter.add((Component)lblScrapeFollowingItems, "cell 0 5 2 1,growx");
        MovieScraperMetadataPanel panelScraperMetadataSetting = new MovieScraperMetadataPanel(this.movieSearchAndScrapeConfig.getScraperMetadataConfig());
        panelCenter.add((Component)panelScraperMetadataSetting, "cell 0 6 2 1,grow");
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(e -> {
            this.startScrape = false;
            this.setVisible(false);
        });
        this.addButton(btnCancel);
        JButton btnStart = new JButton(BUNDLE.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY_INV);
        btnStart.addActionListener(e -> {
            this.startScrape = true;
            this.setVisible(false);
        });
        this.addDefaultButton(btnStart);
        if (!selectedArtworkScrapers.isEmpty()) {
            this.cbArtworkScraper.setSelectedItems(selectedArtworkScrapers);
        }
        if (!selectedTrailerScrapers.isEmpty()) {
            this.cbTrailerScraper.setSelectedItems(selectedTrailerScrapers);
        }
    }

    public MovieSearchAndScrapeOptions getMovieSearchAndScrapeConfig() {
        this.movieSearchAndScrapeConfig.setMetadataScraper((MediaScraper)this.cbMetadataScraper.getSelectedItem());
        for (MediaScraper scraper : this.cbArtworkScraper.getSelectedItems()) {
            this.movieSearchAndScrapeConfig.addArtworkScraper(scraper);
        }
        for (MediaScraper scraper : this.cbTrailerScraper.getSelectedItems()) {
            this.movieSearchAndScrapeConfig.addTrailerScraper(scraper);
        }
        return this.movieSearchAndScrapeConfig;
    }

    public boolean shouldStartScrape() {
        return this.startScrape;
    }
}

