/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieTrailerDownloadAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieTrailerDownloadAction.class);
    private static final long serialVersionUID = -8668265401054434251L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieTrailerDownloadAction() {
        this.putValue("Name", BUNDLE.getString("movie.downloadtrailer"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.downloadtrailer"));
        this.putValue("SmallIcon", IconManager.DOWNLOAD);
        this.putValue("SwingLargeIconKey", IconManager.DOWNLOAD);
    }

    @Override
    protected void processAction(ActionEvent e) {
        int answer;
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        boolean existingTrailer = false;
        for (Movie movie : selectedMovies) {
            if (movie.getMediaFiles(MediaFileType.TRAILER).isEmpty()) continue;
            existingTrailer = true;
            break;
        }
        boolean overwriteTrailer = false;
        if (existingTrailer && (answer = JOptionPane.showConfirmDialog(MainWindow.getFrame(), BUNDLE.getString("movie.overwritetrailer"), BUNDLE.getString("movie.downloadtrailer"), 2)) == 0) {
            overwriteTrailer = true;
        }
        for (Movie movie : selectedMovies) {
            if (!movie.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !overwriteTrailer || movie.getTrailer().isEmpty()) continue;
            MovieHelpers.selectTrailerProvider(movie, LOGGER);
        }
    }
}

