/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieChooserDialog;

public class MovieSingleScrapeAction
extends TmmAction {
    private static final long serialVersionUID = 3066746719177708420L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSingleScrapeAction() {
        this.putValue("Name", BUNDLE.getString("movie.scrape.selected"));
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("ShortDescription", BUNDLE.getString("movie.scrape.selected"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 3));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        int selectedCount = selectedMovies.size();
        int index = 0;
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        do {
            Movie movie = (Movie)selectedMovies.get(index);
            MovieChooserDialog dialogMovieChooser = new MovieChooserDialog(movie, index, selectedCount);
            dialogMovieChooser.setVisible(true);
            if (!dialogMovieChooser.isContinueQueue()) break;
            if (dialogMovieChooser.isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < selectedCount);
    }
}

