/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieScrapeTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieScrapeMetadataDialog;

public class MovieSelectedScrapeMetadataAction
extends TmmAction {
    private static final long serialVersionUID = -4417368111497702010L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSelectedScrapeMetadataAction() {
        this.putValue("Name", BUNDLE.getString("movie.scrape.metadata"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.scrape.metadata.desc"));
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        MovieScrapeMetadataDialog dialog = new MovieScrapeMetadataDialog(BUNDLE.getString("movie.scrape.metadata"));
        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
        dialog.setVisible(true);
        MovieSearchAndScrapeOptions options = dialog.getMovieSearchAndScrapeConfig();
        if (dialog.shouldStartScrape()) {
            MovieScrapeTask scrapeTask = new MovieScrapeTask(selectedMovies, false, options);
            if (TmmTaskManager.getInstance().addMainTask(scrapeTask)) {
                JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
            }
        }
    }
}

