/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieRenamerPreviewDialog;

public class MovieRenamePreviewAction
extends TmmAction {
    private static final long serialVersionUID = 5158514686702295145L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieRenamePreviewAction() {
        this.putValue("Name", BUNDLE.getString("movie.renamepreview"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.renamepreview.hint"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        MovieRenamerPreviewDialog dialog = new MovieRenamerPreviewDialog(selectedMovies);
        dialog.setVisible(true);
    }
}

