/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieReadNfoAction
extends TmmAction {
    private static final long serialVersionUID = 2866581962767395824L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieReadNfoAction() {
        this.putValue("Name", BUNDLE.getString("movie.readnfo"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.readnfo.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(BUNDLE.getString("movie.readnfo"), selectedMovies.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (Movie movie : selectedMovies) {
                    Movie tempMovie = null;
                    for (MediaFile mf : movie.getMediaFiles(MediaFileType.NFO)) {
                        if (tempMovie == null) {
                            try {
                                tempMovie = MovieNfoParser.parseNfo(mf.getFileAsPath()).toMovie();
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (tempMovie == null) continue;
                        try {
                            tempMovie.merge(MovieNfoParser.parseNfo(mf.getFileAsPath()).toMovie());
                        }
                        catch (Exception exception) {}
                    }
                    if (tempMovie != null) {
                        movie.forceMerge(tempMovie);
                        movie.saveToDb();
                    }
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

