/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.WolDevice;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class WolDeviceDialog
extends TmmDialog {
    private static final long serialVersionUID = -8293021735704401080L;
    private WolDevice device = null;
    private JTextField tfName;
    private JTextField tfMacAddress;

    public WolDeviceDialog() {
        super(BUNDLE.getString("tmm.wakeonlandevice"), "wolDialog");
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][]", "[][]"));
        JLabel lblDeviceName = new JLabel(BUNDLE.getString("Settings.devicename"));
        panelContent.add((Component)lblDeviceName, "cell 0 0,alignx right");
        this.tfName = new JTextField();
        this.tfName.setColumns(20);
        panelContent.add((Component)this.tfName, "cell 1 0");
        JLabel lblMacAddress = new JLabel(BUNDLE.getString("Settings.macaddress"));
        panelContent.add((Component)lblMacAddress, "cell 0 1,alignx right");
        this.tfMacAddress = new JTextField();
        this.tfMacAddress.setColumns(20);
        panelContent.add((Component)this.tfMacAddress, "cell 1 1");
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setAction(new CancelAction());
        this.addButton(btnCancel);
        JButton btnSave = new JButton(BUNDLE.getString("Button.save"));
        btnSave.setAction(new SaveAction());
        this.addDefaultButton(btnSave);
    }

    public void setDevice(WolDevice device) {
        this.device = device;
        this.tfName.setText(device.getName());
        this.tfMacAddress.setText(device.getMacAddress());
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -8416641526799936831L;

        CancelAction() {
            this.putValue("Name", TmmDialog.BUNDLE.getString("Button.cancel"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WolDeviceDialog.this.setVisible(false);
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1740130137146252281L;

        SaveAction() {
            this.putValue("Name", TmmDialog.BUNDLE.getString("Button.save"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringUtils.isBlank((CharSequence)WolDeviceDialog.this.tfName.getText()) || StringUtils.isBlank((CharSequence)WolDeviceDialog.this.tfMacAddress.getText())) {
                JOptionPane.showMessageDialog(null, TmmDialog.BUNDLE.getString("message.missingitems"));
                return;
            }
            Pattern pattern = Pattern.compile("^([0-9a-fA-F]{2}[:-]){5}([0-9a-fA-F]{2})$");
            Matcher matcher = pattern.matcher(WolDeviceDialog.this.tfMacAddress.getText());
            if (!matcher.matches()) {
                JOptionPane.showMessageDialog(null, TmmDialog.BUNDLE.getString("message.invalidmac"));
                return;
            }
            if (WolDeviceDialog.this.device == null) {
                WolDeviceDialog.this.device = new WolDevice();
                Globals.settings.addWolDevice(WolDeviceDialog.this.device);
            }
            WolDeviceDialog.this.device.setName(WolDeviceDialog.this.tfName.getText());
            WolDeviceDialog.this.device.setMacAddress(WolDeviceDialog.this.tfMacAddress.getText());
            WolDeviceDialog.this.setVisible(false);
        }
    }
}

