/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.TmmWindowSaver;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.TaskListComponent;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TaskListDialog
extends TmmDialog
implements TmmTaskListener {
    private static final long serialVersionUID = 4151412495928010232L;
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static TaskListDialog instance;
    private final Map<TmmTaskHandle, TaskListComponent> taskMap = new HashMap<TmmTaskHandle, TaskListComponent>();
    private final HashSet<TaskListComponent> listComponents = new HashSet();
    private final TaskListComponent noActiveTask;
    private final JPanel panelContent;
    private final JScrollPane scrollPane;

    private TaskListDialog() {
        super(BUNDLE.getString("tasklist.title"), "taskList");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.panelContent = new JPanel();
        this.panelContent.setOpaque(false);
        this.noActiveTask = new TaskListComponent(BUNDLE.getString("task.nonerunning"));
        this.noActiveTask.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.panelContent.add(this.noActiveTask);
        GridLayout grid = new GridLayout(0, 1);
        grid.setHgap(0);
        grid.setVgap(5);
        this.panelContent.setLayout(grid);
        this.panelContent.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setViewportView(this.panelContent);
        JPanel rootPanel = new JPanel();
        rootPanel.setBackground(UIManager.getColor("Menu.background"));
        rootPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[]", "[100lp:300lp]"));
        rootPanel.add((Component)this.scrollPane, "cell 0 0, top");
        this.getContentPane().add(rootPanel);
        TmmTaskManager.getInstance().addTaskListener(this);
    }

    @Override
    protected void initBottomPanel() {
    }

    @Override
    public void dispose() {
        TmmWindowSaver.getInstance().saveSettings(this);
    }

    public static TaskListDialog getInstance() {
        if (instance == null) {
            instance = new TaskListDialog();
        }
        return instance;
    }

    @Override
    public void processTaskEvent(TmmTaskHandle task) {
        SwingUtilities.invokeLater(() -> {
            if (task.getState() == TmmTaskHandle.TaskState.CREATED || task.getState() == TmmTaskHandle.TaskState.QUEUED) {
                this.addListItem(task);
            } else if (task.getState() == TmmTaskHandle.TaskState.STARTED) {
                TaskListComponent comp = this.taskMap.get(task);
                if (comp == null) {
                    this.addListItem(task);
                    comp = this.taskMap.get(task);
                }
                comp.updateTaskInformation();
            } else if (task.getState() == TmmTaskHandle.TaskState.CANCELLED || task.getState() == TmmTaskHandle.TaskState.FINISHED) {
                this.removeListItem(task);
            }
        });
    }

    private void addListItem(TmmTaskHandle task) {
        TaskListComponent comp;
        if (this.taskMap.containsKey(task)) {
            comp = this.taskMap.get(task);
        } else {
            comp = new TaskListComponent(task);
            this.taskMap.put(task, comp);
        }
        this.panelContent.remove(this.noActiveTask);
        this.listComponents.add(comp);
        comp.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.panelContent.add(comp);
        if (this.isShowing()) {
            this.scrollPane.invalidate();
            this.pack();
        }
    }

    private void removeListItem(TmmTaskHandle task) {
        this.taskMap.remove(task);
        Iterator<TaskListComponent> it = this.listComponents.iterator();
        while (it.hasNext()) {
            TaskListComponent comp = it.next();
            if (comp.getHandle() != task) continue;
            this.panelContent.remove(comp);
            it.remove();
            break;
        }
        if (this.listComponents.isEmpty()) {
            this.panelContent.add(this.noActiveTask);
        }
        if (this.isShowing()) {
            this.scrollPane.invalidate();
            this.pack();
        }
    }
}

