/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.components.MediaRatingTable;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class RatingEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 535315882962742572L;
    private final MediaRatingTable.MediaRating ratingToEdit;
    private JTextField tfProviderId;
    private JSpinner spRating;
    private JSpinner spMaxValue;
    private JSpinner spVotes;

    public RatingEditorDialog(Window owner, String title, MediaRatingTable.MediaRating mediaRating) {
        super(owner, title, "ratingEditor");
        this.ratingToEdit = mediaRating;
        this.initComponents();
        this.tfProviderId.setText(this.ratingToEdit.key);
        this.spRating.setValue(Float.valueOf(this.ratingToEdit.value));
        this.spMaxValue.setValue(this.ratingToEdit.maxValue);
        this.spVotes.setValue(this.ratingToEdit.votes);
    }

    private void initComponents() {
        JPanel panelContent = new JPanel();
        this.getContentPane().add(panelContent);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][50lp][20lp:n][][50lp]", "[][][]"));
        JLabel lblProviderIdT = new JLabel(BUNDLE.getString("metatag.rating.source"));
        panelContent.add((Component)lblProviderIdT, "cell 0 0,alignx trailing");
        this.tfProviderId = new JTextField();
        panelContent.add((Component)this.tfProviderId, "cell 1 0 4 1,growx");
        this.tfProviderId.setColumns(10);
        JLabel lblRatingT = new JLabel(BUNDLE.getString("metatag.rating"));
        panelContent.add((Component)lblRatingT, "cell 0 1,alignx trailing");
        this.spRating = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 0.1));
        panelContent.add((Component)this.spRating, "cell 1 1,growx");
        JLabel lblMaxValue = new JLabel(BUNDLE.getString("metatag.rating.maxvalue"));
        panelContent.add((Component)lblMaxValue, "cell 3 1");
        this.spMaxValue = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
        panelContent.add((Component)this.spMaxValue, "cell 4 1,growx");
        JLabel lblVotes = new JLabel(BUNDLE.getString("metatag.rating.votes"));
        panelContent.add((Component)lblVotes, "cell 0 2");
        this.spVotes = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        panelContent.add((Component)this.spVotes, "cell 1 2,growx");
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.addActionListener(e -> this.setVisible(false));
        this.addButton(btnCancel);
        JButton btnOk = new JButton(BUNDLE.getString("Button.save"));
        btnOk.addActionListener(e -> {
            float rating = ((Double)this.spRating.getValue()).floatValue();
            int maxValue = (Integer)this.spMaxValue.getValue();
            if (StringUtils.isBlank((CharSequence)this.tfProviderId.getText())) {
                JOptionPane.showMessageDialog(this, BUNDLE.getString("id.empty"));
                return;
            }
            if (rating > (float)maxValue) {
                JOptionPane.showMessageDialog(this, BUNDLE.getString("rating.rating.higher.maxvalue"));
                return;
            }
            this.ratingToEdit.key = this.tfProviderId.getText();
            this.ratingToEdit.value = rating;
            this.ratingToEdit.maxValue = maxValue;
            this.ratingToEdit.votes = (Integer)this.spVotes.getValue();
            this.setVisible(false);
        });
        this.addDefaultButton(btnOk);
    }
}

