/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MessageDialog
extends TmmDialog {
    private static final long serialVersionUID = -9035402766767310658L;
    private JLabel lblImage;
    private JTextPane tpText;
    private JTextPane tpDescription;
    private JScrollPane scrollPane;
    private JTextPane textPane;

    public MessageDialog(Window owner, String title) {
        super(owner, title, "messageDialog");
        this.setModal(false);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        JPanel panelContent = new JPanel();
        panelContent.setLayout((LayoutManager)new MigLayout("hidemode 1", "[][500lp,grow]", "[][][300lp,grow]"));
        this.getContentPane().add((Component)panelContent, "Center");
        this.lblImage = new JLabel("");
        this.lblImage.setVisible(false);
        panelContent.add((Component)this.lblImage, "cell 0 0 1 2,grow");
        this.tpText = new ReadOnlyTextPane("");
        this.tpText.setVisible(false);
        panelContent.add((Component)this.tpText, "cell 1 0,growx");
        this.tpDescription = new ReadOnlyTextPane("");
        this.tpDescription.setEditable(true);
        this.tpDescription.setVisible(false);
        panelContent.add((Component)this.tpDescription, "cell 1 1,growx");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVisible(false);
        this.scrollPane.setPreferredSize(new Dimension(600, 200));
        panelContent.add((Component)this.scrollPane, "cell 0 2 2 1,grow");
        this.textPane = new JTextPane();
        this.textPane.setVisible(false);
        this.textPane.setEditable(false);
        this.scrollPane.setViewportView(this.textPane);
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
    }

    public void setImage(Icon icon) {
        this.lblImage.setIcon(icon);
        this.lblImage.setVisible(true);
    }

    public void setText(String text) {
        this.tpText.setText(text);
        this.tpText.setVisible(true);
    }

    public void setDescription(String description) {
        this.tpDescription.setText(description);
        this.tpDescription.setVisible(true);
    }

    public void setDetails(String details) {
        this.textPane.setText(details);
        this.textPane.setVisible(true);
        this.textPane.setCaretPosition(0);
        this.scrollPane.setVisible(true);
    }

    public static void showExceptionWindow(Throwable ex) {
        MessageDialog dialog = new MessageDialog(null, BUNDLE.getString("tmm.problemdetected"));
        dialog.setImage(IconManager.ERROR);
        String msg = ex.getLocalizedMessage();
        dialog.setText(msg != null ? msg : "");
        dialog.setDescription(BUNDLE.getString("tmm.uicrash"));
        dialog.setDetails(MessageDialog.stackStraceAsString(ex));
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
    }

    private static String stackStraceAsString(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

