/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.treetable;

import javax.swing.table.AbstractTableModel;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableModel;

class ConnectorTableModel
extends AbstractTableModel {
    private TmmTableFormat tableFormat;
    private TmmTreeTableModel treeTableModel;

    public ConnectorTableModel(TmmTableFormat tableFormat, TmmTreeTableModel treeTableModel) {
        this.tableFormat = tableFormat;
        this.treeTableModel = treeTableModel;
    }

    TmmTableFormat getTableFormat() {
        return this.tableFormat;
    }

    @Override
    public int getRowCount() {
        return -1;
    }

    @Override
    public int getColumnCount() {
        return this.tableFormat.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object node = this.getNodeForRow(rowIndex);
        if (node == null) {
            assert (false) : "Some node should exist on row " + rowIndex + " and on column " + columnIndex + ", but was null.";
            return null;
        }
        return this.tableFormat.getColumnValue(node, columnIndex);
    }

    public String getTooltipAt(int rowIndex, int columnIndex) {
        Object node = this.getNodeForRow(rowIndex);
        if (node == null) {
            assert (false) : "Some node should exist on row " + rowIndex + " and on column " + columnIndex + ", but was null.";
            return null;
        }
        return this.tableFormat.getColumnTooltip(node, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.tableFormat.getColumnName(column);
    }

    public Class getColumnClass(int columnIndex) {
        return this.tableFormat.getColumnClass(columnIndex);
    }

    private Object getNodeForRow(int row) {
        return this.treeTableModel.getValueAt(row, 0);
    }
}

