/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.tree;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;

public class TmmTreeTextFilter<E extends TmmTreeNode>
extends EnhancedTextField
implements ITmmTreeFilter<E> {
    private static final long serialVersionUID = 8492300503787395800L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    protected String filterText = "";

    public TmmTreeTextFilter() {
        super(BUNDLE.getString("tmm.searchfield"), IconManager.SEARCH_GREY);
        this.lblIcon.setCursor(Cursor.getPredefinedCursor(12));
        this.lblIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StringUtils.isNotBlank((CharSequence)TmmTreeTextFilter.this.getText())) {
                    TmmTreeTextFilter.this.setText("");
                }
            }
        });
        this.initDocumentListener();
    }

    protected void initDocumentListener() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changeIcon();
                this.updateFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changeIcon();
                this.updateFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changeIcon();
                this.updateFilter();
            }

            private void changeIcon() {
                if (StringUtils.isBlank((CharSequence)TmmTreeTextFilter.this.getText())) {
                    TmmTreeTextFilter.this.lblIcon.setIcon(IconManager.SEARCH_GREY);
                } else {
                    TmmTreeTextFilter.this.lblIcon.setIcon(IconManager.CLEAR_GREY);
                }
            }

            private void updateFilter() {
                String oldValue = TmmTreeTextFilter.this.filterText;
                TmmTreeTextFilter.this.filterText = TmmTreeTextFilter.this.getText();
                TmmTreeTextFilter.this.firePropertyChange("treeFilterChanged", oldValue, TmmTreeTextFilter.this.filterText);
            }
        });
    }

    @Override
    public boolean isActive() {
        return StringUtils.isNotBlank((CharSequence)this.filterText);
    }

    @Override
    public boolean accept(E node) {
        if (StringUtils.isBlank((CharSequence)this.filterText)) {
            return true;
        }
        Pattern pattern = Pattern.compile("(?i)" + Pattern.quote(this.filterText));
        Matcher matcher = pattern.matcher(((TmmTreeNode)node).toString());
        if (matcher.find()) {
            return true;
        }
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)node).children();
        while (e.hasMoreElements()) {
            if (!this.accept((TmmTreeNode)e.nextElement())) continue;
            return true;
        }
        return this.checkParent((TmmTreeNode)((TmmTreeNode)node).getDataProvider().getParent(node), pattern);
    }

    private boolean checkParent(TmmTreeNode node, Pattern pattern) {
        if (node == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(node.toString());
        if (matcher.find()) {
            return true;
        }
        return this.checkParent(node.getDataProvider().getParent(node), pattern);
    }
}

