/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.toolbar;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;

class ToolbarButton
extends JButton {
    private Icon baseIcon;
    private Icon hoverIcon;
    private final JPopupMenu popupMenu;

    ToolbarButton(Icon baseIcon, Icon hoverIcon) {
        this(baseIcon, hoverIcon, null);
    }

    ToolbarButton(Icon baseIcon, Icon hoverIcon, JPopupMenu popupMenu) {
        super(baseIcon);
        this.baseIcon = baseIcon;
        this.hoverIcon = hoverIcon;
        this.popupMenu = popupMenu;
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.putClientProperty("flatButton", Boolean.TRUE);
        this.setHideActionText(true);
        this.updateUI();
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarButton.this.setIcon(ToolbarButton.this.baseIcon);
                ToolbarButton.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                ToolbarButton.this.setIcon(ToolbarButton.this.hoverIcon);
                ToolbarButton.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (ToolbarButton.this.popupMenu != null) {
                    ToolbarButton.this.popupMenu.show(ToolbarButton.this, ToolbarButton.this.getWidth() - (int)ToolbarButton.this.popupMenu.getPreferredSize().getWidth(), ToolbarButton.this.getHeight());
                }
            }
        });
    }

    @Override
    public void setAction(Action a) {
        super.setAction(a);
        this.setEnabled(a != null);
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        this.setToolTipText(a != null ? (String)a.getValue("ShortDescription") : null);
    }

    void setIcons(Icon baseIcon, Icon hoverIcon) {
        this.setIcon(baseIcon);
        this.baseIcon = baseIcon;
        this.hoverIcon = hoverIcon;
    }
}

