/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.table.TmmTableColumnModel;
import org.tinymediamanager.ui.components.table.TmmTableColumnSelectionPopup;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.components.table.TmmViewport;

public class TmmTable
extends JTable {
    private static final long serialVersionUID = 6150939811851709115L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final CellRendererPane CELL_RENDER_PANE = new CellRendererPane();

    public TmmTable() {
        this.init();
    }

    public TmmTable(TableModel dm) {
        this.setModel(dm);
        this.init();
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new TmmTableColumnModel();
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        if (!(aColumn.getHeaderRenderer() instanceof BottomBorderHeaderRenderer)) {
            aColumn.setHeaderRenderer(new BottomBorderHeaderRenderer());
        }
        if (aColumn.getIdentifier() == null && this.getModel() instanceof TmmTableModel) {
            TmmTableModel tableModel = (TmmTableModel)((Object)this.getModel());
            tableModel.setUpColumn(aColumn);
        }
        super.addColumn(aColumn);
    }

    private void init() {
        this.setTableHeader(this.createTableHeader());
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setOpaque(false);
        this.setOpaque(false);
        this.setRowHeight(22);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                TmmTable.this.adjustColumnPreferredWidths(3);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                TmmTable.this.adjustColumnPreferredWidths(3);
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    public void writeHiddenColumns(Consumer<List<String>> setting) {
        ArrayList<String> hiddenColumns = new ArrayList<String>();
        if (this.getColumnModel() instanceof TmmTableColumnModel) {
            List<TableColumn> cols = ((TmmTableColumnModel)this.getColumnModel()).getHiddenColumns();
            for (TableColumn col : cols) {
                if (!(col.getIdentifier() instanceof String) || !StringUtils.isNotBlank((CharSequence)((String)col.getIdentifier()))) continue;
                hiddenColumns.add((String)col.getIdentifier());
            }
        }
        setting.accept(hiddenColumns);
    }

    public void readHiddenColumns(List<String> hiddenColumns) {
        if (this.getColumnModel() instanceof TmmTableColumnModel) {
            ((TmmTableColumnModel)this.getColumnModel()).setHiddenColumns(hiddenColumns);
        }
    }

    public void adjustColumnPreferredWidths(int margin) {
        TableColumnModel columnModel = this.getColumnModel();
        for (int col = 0; col < this.getColumnCount(); ++col) {
            int maxWidth = 0;
            int minWidth = columnModel.getColumn(col).getMinWidth();
            TableCellRenderer rend = columnModel.getColumn(col).getHeaderRenderer();
            Object value = columnModel.getColumn(col).getHeaderValue();
            if (rend == null) {
                rend = this.getTableHeader().getDefaultRenderer();
            }
            Component comp = rend.getTableCellRendererComponent(this, value, false, false, -1, col);
            maxWidth = Math.max(comp.getPreferredSize().width + 2 * margin, maxWidth);
            for (int row = 0; row < this.getRowCount(); ++row) {
                rend = this.getCellRenderer(row, col);
                value = this.getValueAt(row, col);
                comp = rend.getTableCellRendererComponent(this, value, false, false, row, col);
                maxWidth = Math.max(comp.getPreferredSize().width + margin, maxWidth);
            }
            if (maxWidth < minWidth) {
                maxWidth = minWidth;
            }
            TableColumn column = columnModel.getColumn(col);
            column.setPreferredWidth(maxWidth);
            if (column.getResizable()) continue;
            column.setMinWidth(minWidth);
            column.setMaxWidth(maxWidth);
        }
    }

    protected JTableHeader createTableHeader() {
        return new JTableHeader(this.getColumnModel()){
            private static final long serialVersionUID = 1652463935117013248L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                JViewport viewport = (JViewport)this.table.getParent();
                if (viewport != null && this.table.getWidth() < viewport.getWidth()) {
                    int x = this.table.getWidth();
                    int width = viewport.getWidth() - this.table.getWidth();
                    TmmTable.paintHeader(g, this.getTable(), x, width);
                }
            }
        };
    }

    public void setNewFontSize(float size) {
        this.setFont(this.getFont().deriveFont(size));
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.setRowHeight(fm.getHeight() + 4);
    }

    protected static void paintHeader(Graphics g, JTable table, int x, int width) {
        BottomBorderHeaderRenderer renderer = new BottomBorderHeaderRenderer();
        Component component = renderer.getTableCellRendererComponent(table, "", false, false, -1, 2);
        component.setBounds(0, 0, width, table.getTableHeader().getHeight());
        ((JComponent)component).setOpaque(false);
        CELL_RENDER_PANE.paintComponent(g, component, null, x, 0, width, table.getTableHeader().getHeight(), true);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(this.getSelectionModel().isSelectedIndex(row));
        }
        return component;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container parent;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (parent = p.getParent()) instanceof JScrollPane) {
            final JScrollPane scrollPane = (JScrollPane)parent;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            final JButton b = new JButton(IconManager.CONFIGURE);
            b.setOpaque(false);
            b.putClientProperty("flatButton", Boolean.TRUE);
            b.setToolTipText(BUNDLE.getString("Button.selectvisiblecolumns"));
            b.setBorder(BorderFactory.createEmptyBorder());
            b.updateUI();
            b.addActionListener(evt -> TmmTableColumnSelectionPopup.showColumnSelectionPopup(b, this));
            b.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    scrollPane.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    scrollPane.setCursor(Cursor.getPredefinedCursor(0));
                }

                @Override
                public void mouseClicked(MouseEvent me) {
                    TmmTableColumnSelectionPopup.showColumnSelectionPopup(b, TmmTable.this);
                }
            });
            b.setFocusable(false);
            scrollPane.setCorner("UPPER_RIGHT_CORNER", b);
        }
    }

    public void configureScrollPane(JScrollPane scrollPane) {
        int[] columnsWithoutRightVerticalGrid = new int[]{};
        this.configureScrollPane(scrollPane, columnsWithoutRightVerticalGrid);
    }

    public void configureScrollPane(JScrollPane scrollPane, int[] columnsWithoutRightVerticalGrid) {
        if (!(scrollPane.getViewport() instanceof TmmViewport)) {
            scrollPane.setViewport(new TmmViewport(this, columnsWithoutRightVerticalGrid));
            scrollPane.getViewport().setView(this);
        }
        scrollPane.setVerticalScrollBarPolicy(22);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (!(this.getModel() instanceof TmmTableModel)) {
            return super.getToolTipText(e);
        }
        TmmTableModel tableModel = (TmmTableModel)((Object)this.getModel());
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        return tableModel.getTooltipAt(rowIndex, realColumnIndex);
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        if (StringUtils.isBlank((CharSequence)this.getToolTipText(e))) {
            return null;
        }
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        Rectangle r = this.getCellRect(rowIndex, colIndex, false);
        Point point = new Point(r.x + 20, r.y + (int)(1.2 * (double)r.height));
        return point;
    }

    protected static class BottomBorderHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 7963585655106103415L;

        public BottomBorderHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            JTableHeader h;
            JTableHeader jTableHeader = h = table != null ? table.getTableHeader() : null;
            if (h != null) {
                this.setEnabled(h.isEnabled());
                this.setComponentOrientation(h.getComponentOrientation());
                this.setForeground(h.getForeground());
                this.setBackground(h.getBackground());
                this.setFont(h.getFont());
            } else {
                this.setEnabled(true);
                this.setComponentOrientation(ComponentOrientation.UNKNOWN);
                this.setForeground(UIManager.getColor("TableHeader.foreground"));
                this.setBackground(UIManager.getColor("TableHeader.background"));
                this.setFont(UIManager.getFont("TableHeader.font"));
            }
            if (value instanceof ImageIcon) {
                this.setIcon((ImageIcon)value);
                this.setText("");
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setIcon(null);
                this.setHorizontalAlignment(0);
            }
            return this;
        }
    }
}

