/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.tinymediamanager.ui.components.JFXDirectoryChooser;
import org.tinymediamanager.ui.components.JFXFileChooser;

public class NativeFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 1713280883666050112L;
    public static final boolean JAVAFX_AVAILABLE = NativeFileChooser.isJavaFXAvailable();
    private JFXFileChooser fileChooser;
    private JFXDirectoryChooser directoryChooser;
    private List<File> currentFiles;
    private File currentFile;

    private static boolean isJavaFXAvailable() {
        try {
            Class.forName("javafx.stage.FileChooser");
            Class<?> clazz = Class.forName("javafx.application.Platform");
            Method method = clazz.getMethod("setImplicitExit", Boolean.TYPE);
            method.invoke(null, Boolean.FALSE);
            Class.forName("javafx.embed.swing.JFXPanel").newInstance();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public NativeFileChooser() {
        this.initFxFileChooser(null);
    }

    public NativeFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.initFxFileChooser(new File(currentDirectoryPath));
    }

    public NativeFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.initFxFileChooser(currentDirectory);
    }

    public NativeFileChooser(FileSystemView fsv) {
        super(fsv);
        this.initFxFileChooser(fsv.getDefaultDirectory());
    }

    public NativeFileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.initFxFileChooser(currentDirectory);
    }

    public NativeFileChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
        this.initFxFileChooser(new File(currentDirectoryPath));
    }

    @Override
    public int showOpenDialog(Component parent) throws HeadlessException {
        if (JAVAFX_AVAILABLE) {
            try {
                CountDownLatch countDownLatch = new CountDownLatch(1);
                Runnable runnable = () -> {
                    if (this.isDirectorySelectionEnabled()) {
                        this.currentFile = this.directoryChooser.showDialog();
                    } else if (this.isMultiSelectionEnabled()) {
                        this.currentFiles = this.fileChooser.showOpenMultipleDialog();
                    } else {
                        this.currentFile = this.fileChooser.showOpenDialog();
                    }
                    countDownLatch.countDown();
                };
                Class<?> clazz = Class.forName("javafx.application.Platform");
                Method method = clazz.getMethod("runLater", Runnable.class);
                method.invoke(null, runnable);
                countDownLatch.await();
                if (this.isMultiSelectionEnabled()) {
                    if (this.currentFiles != null) {
                        return 0;
                    }
                    return 1;
                }
                if (this.currentFile != null) {
                    return 0;
                }
                return 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.showOpenDialog(parent);
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        if (!JAVAFX_AVAILABLE) {
            return super.showSaveDialog(parent);
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable runnable = () -> {
            this.currentFile = this.isDirectorySelectionEnabled() ? this.directoryChooser.showDialog() : this.fileChooser.showSaveDialog();
            countDownLatch.countDown();
        };
        try {
            Class<?> clazz = Class.forName("javafx.application.Platform");
            Method method = clazz.getMethod("runLater", Runnable.class);
            method.invoke(null, runnable);
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (Exception e) {
            return 1;
        }
        if (this.currentFile != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        if (!JAVAFX_AVAILABLE) {
            return super.showDialog(parent, approveButtonText);
        }
        return this.showOpenDialog(parent);
    }

    @Override
    public File[] getSelectedFiles() {
        if (!JAVAFX_AVAILABLE) {
            return super.getSelectedFiles();
        }
        if (this.currentFiles == null) {
            return null;
        }
        return this.currentFiles.toArray(new File[this.currentFiles.size()]);
    }

    @Override
    public File getSelectedFile() {
        if (!JAVAFX_AVAILABLE) {
            return super.getSelectedFile();
        }
        return this.currentFile;
    }

    @Override
    public void setSelectedFiles(File[] selectedFiles) {
        if (!JAVAFX_AVAILABLE) {
            super.setSelectedFiles(selectedFiles);
            return;
        }
        if (selectedFiles == null || selectedFiles.length == 0) {
            this.currentFiles = null;
        } else {
            this.setSelectedFile(selectedFiles[0]);
            this.currentFiles = new ArrayList<File>(Arrays.asList(selectedFiles));
        }
    }

    @Override
    public void setSelectedFile(File file) {
        if (!JAVAFX_AVAILABLE) {
            super.setSelectedFile(file);
            return;
        }
        this.currentFile = file;
        if (file != null) {
            if (file.isDirectory()) {
                this.fileChooser.setInitialDirectory(file.getAbsoluteFile());
                if (this.directoryChooser != null) {
                    this.directoryChooser.setInitialDirectory(file.getAbsoluteFile());
                }
            } else if (file.isFile()) {
                this.fileChooser.setInitialDirectory(file.getParentFile());
                this.fileChooser.setInitialFileName(file.getName());
                if (this.directoryChooser != null) {
                    this.directoryChooser.setInitialDirectory(file.getParentFile());
                }
            } else if (this.directoryChooser == null) {
                this.fileChooser.setInitialFileName(file.getName());
            }
        }
    }

    @Override
    public void setFileSelectionMode(int mode) {
        super.setFileSelectionMode(mode);
        if (!JAVAFX_AVAILABLE) {
            return;
        }
        if (mode == 1) {
            if (this.directoryChooser == null) {
                try {
                    this.directoryChooser = new JFXDirectoryChooser();
                }
                catch (Exception e) {
                    return;
                }
            }
            this.setSelectedFile(this.currentFile);
            this.setDialogTitle(this.getDialogTitle());
        }
    }

    @Override
    public void setDialogTitle(String dialogTitle) {
        if (!JAVAFX_AVAILABLE) {
            super.setDialogTitle(dialogTitle);
            return;
        }
        this.fileChooser.setTitle(dialogTitle);
        if (this.directoryChooser != null) {
            this.directoryChooser.setTitle(dialogTitle);
        }
    }

    @Override
    public String getDialogTitle() {
        if (!JAVAFX_AVAILABLE) {
            return super.getDialogTitle();
        }
        return this.fileChooser.getTitle();
    }

    @Override
    public void changeToParentDirectory() {
        if (!JAVAFX_AVAILABLE) {
            super.changeToParentDirectory();
            return;
        }
        File parentDir = this.fileChooser.getInitialDirectory().getParentFile();
        if (parentDir.isDirectory()) {
            this.fileChooser.setInitialDirectory(parentDir);
            if (this.directoryChooser != null) {
                this.directoryChooser.setInitialDirectory(parentDir);
            }
        }
    }

    @Override
    public void addChoosableFileFilter(FileFilter filter) {
        super.addChoosableFileFilter(filter);
        if (!JAVAFX_AVAILABLE || filter == null) {
            return;
        }
        if (filter.getClass().equals(FileNameExtensionFilter.class)) {
            FileNameExtensionFilter f = (FileNameExtensionFilter)filter;
            ArrayList<String> ext = new ArrayList<String>();
            for (String extension : f.getExtensions()) {
                ext.add(extension.replaceAll("^\\*?\\.?(.*)$", "*.$1"));
            }
            this.fileChooser.addExtensionFilter(f.getDescription(), ext);
        }
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean bool) {
        boolean differs = this.isAcceptAllFileFilterUsed() ^ bool;
        super.setAcceptAllFileFilterUsed(bool);
        if (!JAVAFX_AVAILABLE) {
            return;
        }
        if (differs && bool) {
            this.fileChooser.addExtensionFilter("All files", Collections.singletonList("*.*"));
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        if (this.fileChooser != null) {
            this.fileChooser.setInitialDirectory(dir);
        } else if (this.directoryChooser != null) {
            this.directoryChooser.setInitialDirectory(dir);
        } else {
            super.setCurrentDirectory(dir);
        }
    }

    private void initFxFileChooser(File currentFile) {
        if (JAVAFX_AVAILABLE) {
            try {
                this.fileChooser = new JFXFileChooser();
                this.currentFile = currentFile;
                if (currentFile != null) {
                    this.setSelectedFile(currentFile);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

