/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.plaf.TmmTheme;
import org.tinymediamanager.ui.thirdparty.ShadowRenderer;

public class ImageLabel
extends JLabel {
    private static final long serialVersionUID = -2524445544386464158L;
    private static final char ICON_ID = '\uf03e';
    private static final Color EMPTY_BACKGROUND_COLOR = new Color(141, 165, 179);
    private static final Dimension EMPTY_SIZE = new Dimension(0, 0);
    protected byte[] originalImageBytes;
    protected Dimension originalImageSize = EMPTY_SIZE;
    protected BufferedImage scaledImage;
    protected String imageUrl;
    protected String imagePath;
    protected Position position = Position.TOP_LEFT;
    protected boolean drawBorder;
    protected boolean drawFullWidth;
    protected boolean enabledLightbox = false;
    protected boolean preferCache = true;
    protected boolean isLightBox = false;
    protected float desiredAspectRatio = 0.0f;
    protected boolean drawShadow = false;
    protected boolean cacheUrl = false;
    protected SwingWorker<BufferedImage, Void> worker = null;
    protected MouseListener lightboxListener = null;

    public ImageLabel() {
        super("");
        this.drawBorder = true;
        this.drawFullWidth = false;
    }

    public ImageLabel(boolean drawBorder) {
        super("");
        this.drawBorder = drawBorder;
        this.drawFullWidth = false;
    }

    public ImageLabel(boolean drawBorder, boolean drawFullWidth) {
        super("");
        this.drawBorder = drawBorder;
        this.drawFullWidth = drawFullWidth;
    }

    public ImageLabel(boolean drawBorder, boolean drawFullWidth, boolean drawShadow) {
        super("");
        this.drawBorder = drawBorder;
        this.drawFullWidth = drawFullWidth;
        this.drawShadow = drawShadow;
    }

    public void setOriginalImage(byte[] originalImageBytes) {
        try {
            this.originalImageBytes = originalImageBytes;
            BufferedImage originalImage = ImageUtils.createImage(originalImageBytes);
            this.originalImageSize = new Dimension(originalImage.getWidth(), originalImage.getHeight());
            this.scaledImage = Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)this.getSize().width, (int)this.getSize().height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        }
        catch (Exception e) {
            this.clearImageData();
        }
        this.repaint();
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String newValue) {
        String oldValue = this.imagePath;
        if (StringUtils.isNotEmpty((CharSequence)oldValue) && oldValue.equals(newValue)) {
            return;
        }
        this.imagePath = newValue;
        this.firePropertyChange("imagePath", oldValue, newValue);
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.clearImageData();
        if (StringUtils.isBlank((CharSequence)newValue)) {
            this.repaint();
            return;
        }
        this.worker = new ImageLoader(this.imagePath, this.getSize());
        this.worker.execute();
        this.repaint();
    }

    public void clearImage() {
        this.imagePath = "";
        this.imageUrl = "";
        this.clearImageData();
        this.repaint();
    }

    protected void clearImageData() {
        this.scaledImage = null;
        this.originalImageBytes = null;
        this.originalImageSize = EMPTY_SIZE;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String newValue) {
        String oldValue = this.imageUrl;
        this.imageUrl = newValue;
        this.firePropertyChange("imageUrl", oldValue, newValue);
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.clearImageData();
        if (StringUtils.isEmpty((CharSequence)newValue)) {
            this.repaint();
            return;
        }
        this.worker = new ImageFetcher(this.getSize());
        this.worker.execute();
        this.repaint();
    }

    public void setDesiredAspectRatio(float desiredAspectRatio) {
        this.desiredAspectRatio = desiredAspectRatio;
    }

    public float getDesiredAspectRatio() {
        return this.desiredAspectRatio;
    }

    public byte[] getOriginalImageBytes() {
        return this.originalImageBytes;
    }

    public Dimension getOriginalImageSize() {
        return this.originalImageSize;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.desiredAspectRatio == 0.0f) {
            return super.getPreferredSize();
        }
        if (this.originalImageSize != EMPTY_SIZE) {
            return new Dimension(this.getParent().getWidth(), (int)((float)this.getParent().getWidth() / (float)this.originalImageSize.width * (float)this.originalImageSize.height));
        }
        return new Dimension(this.getParent().getWidth(), (int)((float)this.getParent().getWidth() / this.desiredAspectRatio) + 1);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.scaledImage != null) {
            int scaledImageWidth = this.scaledImage.getWidth(null);
            int scaledImageHeight = this.scaledImage.getHeight(null);
            int newWidth = 0;
            int newHeight = 0;
            int offsetX = 0;
            int offsetY = 0;
            if (this.drawBorder && !this.drawFullWidth && !this.drawShadow) {
                Point size = ImageUtils.calculateSize(this.getWidth() - 8, this.getHeight() - 8, this.originalImageSize.width, this.originalImageSize.height, true);
                if (this.position == Position.TOP_RIGHT || this.position == Position.BOTTOM_RIGHT) {
                    offsetX = this.getWidth() - size.x - 8;
                }
                if (this.position == Position.BOTTOM_LEFT || this.position == Position.BOTTOM_RIGHT) {
                    offsetY = this.getHeight() - size.y - 8;
                }
                if (this.position == Position.CENTER) {
                    offsetX = (this.getWidth() - size.x - 8) / 2;
                    offsetY = (this.getHeight() - size.y - 8) / 2;
                }
                newWidth = size.x;
                newHeight = size.y;
                this.recreateScaledImageIfNeeded(scaledImageWidth, scaledImageHeight, newWidth, newHeight);
                g.setColor(Color.BLACK);
                g.drawRect(offsetX, offsetY, size.x + 7, size.y + 7);
                g.setColor(Color.WHITE);
                g.fillRect(offsetX + 1, offsetY + 1, size.x + 6, size.y + 6);
                g.drawImage(this.scaledImage, offsetX + 4, offsetY + 4, newWidth, newHeight, this);
            } else if (this.drawShadow && !this.drawFullWidth) {
                Point size = ImageUtils.calculateSize(this.getWidth(), this.getHeight(), this.originalImageSize.width, this.originalImageSize.height, true);
                newWidth = size.x;
                newHeight = size.y;
                this.recreateScaledImageIfNeeded(scaledImageWidth, scaledImageHeight, this.getWidth() - 8, this.getHeight() - 8);
                if (this.scaledImage != null) {
                    ShadowRenderer shadow = new ShadowRenderer(8, 0.3f, Color.BLACK);
                    BufferedImage shadowImage = shadow.createShadow(this.scaledImage);
                    g.drawImage(shadowImage, 8, 8, newWidth - 8, newHeight - 8, this);
                }
                g.drawImage(this.scaledImage, 0, 0, newWidth - 8, newHeight - 8, this);
            } else {
                Point size = null;
                size = this.drawFullWidth ? new Point(this.getWidth(), this.getWidth() * this.originalImageSize.height / this.originalImageSize.width) : ImageUtils.calculateSize(this.getWidth(), this.getHeight(), this.originalImageSize.width, this.originalImageSize.height, true);
                if (this.position == Position.TOP_RIGHT || this.position == Position.BOTTOM_RIGHT) {
                    offsetX = this.getWidth() - size.x;
                }
                if (this.position == Position.BOTTOM_LEFT || this.position == Position.BOTTOM_RIGHT) {
                    offsetY = this.getHeight() - size.y;
                }
                if (this.position == Position.CENTER) {
                    offsetX = (this.getWidth() - size.x) / 2;
                    offsetY = (this.getHeight() - size.y) / 2;
                }
                newWidth = size.x;
                newHeight = size.y;
                this.recreateScaledImageIfNeeded(scaledImageWidth, scaledImageHeight, newWidth, newHeight);
                g.drawImage(this.scaledImage, offsetX, offsetY, newWidth, newHeight, this);
            }
        } else if (!this.isLoading() && !this.isLightBox) {
            int newHeight;
            int newWidth;
            if (this.drawShadow) {
                newWidth = this.getWidth() - 8;
                newHeight = this.getHeight() - 8;
            } else {
                newWidth = this.getWidth();
                newHeight = this.getHeight();
            }
            float fontSize = (float)((double)(newWidth < newHeight ? newWidth : newHeight) * 0.5 / 0.75);
            Font font = TmmTheme.FONT_AWESOME.deriveFont(fontSize);
            BufferedImage tmp = new BufferedImage(newWidth, newHeight, 2);
            Graphics2D g2 = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(tmp);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(EMPTY_BACKGROUND_COLOR);
            g2.fillRect(0, 0, newWidth, newHeight);
            g2.setFont(font);
            g2.setColor(UIManager.getColor("Panel.background"));
            Rectangle2D bounds = font.createGlyphVector(g2.getFontRenderContext(), String.valueOf('\uf03e')).getVisualBounds();
            int iconWidth = (int)Math.ceil(bounds.getWidth()) + 2;
            int iconHeight = (int)Math.ceil(bounds.getHeight()) + 2;
            g2.drawString(String.valueOf('\uf03e'), (newWidth - iconWidth) / 2, (newHeight + iconHeight) / 2);
            g2.dispose();
            if (this.drawShadow) {
                ShadowRenderer shadow = new ShadowRenderer(8, 0.3f, Color.BLACK);
                BufferedImage shadowImage = shadow.createShadow(tmp);
                g.drawImage(shadowImage, 8, 8, newWidth, newHeight, this);
            }
            g.drawImage(tmp, 0, 0, newWidth, newHeight, this);
        }
    }

    protected boolean isLoading() {
        return this.worker != null && !this.worker.isDone();
    }

    private void recreateScaledImageIfNeeded(int originalWidth, int originalHeight, int newWidth, int newHeight) {
        if (originalWidth < 20 || originalHeight < 20 || newWidth != originalWidth || newHeight != originalHeight) {
            try {
                this.scaledImage = Scalr.resize((BufferedImage)ImageUtils.createImage(this.originalImageBytes), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)newWidth, (int)newHeight, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            }
            catch (Exception e) {
                this.scaledImage = null;
            }
        }
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void enableLightbox() {
        this.enabledLightbox = true;
        if (this.lightboxListener == null) {
            this.lightboxListener = new ImageLabelClickListener();
            this.addMouseListener(this.lightboxListener);
        }
    }

    public void disableLightbox() {
        this.enabledLightbox = false;
        if (this.lightboxListener != null) {
            this.removeMouseListener(this.lightboxListener);
            this.lightboxListener = null;
        }
    }

    public void setPreferCache(boolean preferCache) {
        this.preferCache = preferCache;
    }

    public void setIsLightbox(boolean value) {
        this.isLightBox = value;
    }

    public void setCacheUrl(boolean cacheUrl) {
        this.cacheUrl = cacheUrl;
    }

    private class ImageLabelClickListener
    extends MouseAdapter {
        private ImageLabelClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getClickCount() == 1 && ImageLabel.this.scaledImage != null) {
                MainWindow.getActiveInstance().createLightbox(ImageLabel.this.getImagePath(), ImageLabel.this.getImageUrl());
            }
        }
    }

    protected class ImageLoader
    extends SwingWorker<BufferedImage, Void> {
        private String imagePath;
        private Dimension newSize;

        public ImageLoader(String imagePath, Dimension newSize) {
            this.imagePath = imagePath;
            this.newSize = newSize;
        }

        @Override
        protected BufferedImage doInBackground() {
            Path file = null;
            if (ImageLabel.this.preferCache) {
                file = ImageCache.getCachedFile(Paths.get(this.imagePath, new String[0]));
            }
            if (file == null) {
                file = Paths.get(this.imagePath, new String[0]);
            }
            if (!(file != null && Files.exists(file, new LinkOption[0]) || ImageLabel.this.preferCache)) {
                file = ImageCache.getCachedFile(Paths.get(this.imagePath, new String[0]));
            }
            if (file != null && Files.exists(file, new LinkOption[0])) {
                try {
                    ImageLabel.this.originalImageBytes = Files.readAllBytes(file);
                    BufferedImage originalImage = ImageUtils.createImage(ImageLabel.this.originalImageBytes);
                    ImageLabel.this.originalImageSize = new Dimension(originalImage.getWidth(), originalImage.getHeight());
                    return Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)this.newSize.width, (int)this.newSize.height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
                }
                catch (Exception e) {
                    ImageLabel.this.imagePath = "";
                    ImageLabel.this.clearImageData();
                    return null;
                }
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            try {
                ImageLabel.this.scaledImage = (BufferedImage)this.get();
                ImageLabel.this.firePropertyChange("originalImageBytes", null, ImageLabel.this.originalImageBytes);
                ImageLabel.this.firePropertyChange("originalImageSize", null, ImageLabel.this.originalImageSize);
            }
            catch (Exception e) {
                ImageLabel.this.scaledImage = null;
            }
            ImageLabel.this.revalidate();
            ImageLabel.this.repaint();
        }
    }

    protected class ImageFetcher
    extends SwingWorker<BufferedImage, Void> {
        private Dimension newSize;

        public ImageFetcher(Dimension newSize) {
            this.newSize = newSize;
        }

        @Override
        protected BufferedImage doInBackground() {
            try {
                Object url = ImageLabel.this.cacheUrl ? new InMemoryCachedUrl(ImageLabel.this.imageUrl) : new Url(ImageLabel.this.imageUrl);
                ImageLabel.this.originalImageBytes = url.getBytesWithRetry(5);
                BufferedImage originalImage = ImageUtils.createImage(ImageLabel.this.originalImageBytes);
                ImageLabel.this.originalImageSize = new Dimension(originalImage.getWidth(), originalImage.getHeight());
                return Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)this.newSize.width, (int)this.newSize.height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            }
            catch (Exception e) {
                ImageLabel.this.imageUrl = "";
                ImageLabel.this.clearImageData();
                return null;
            }
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            try {
                ImageLabel.this.scaledImage = (BufferedImage)this.get();
                ImageLabel.this.firePropertyChange("originalImageBytes", null, ImageLabel.this.originalImageBytes);
                ImageLabel.this.firePropertyChange("originalImageSize", null, ImageLabel.this.originalImageSize);
            }
            catch (Exception e) {
                ImageLabel.this.scaledImage = null;
            }
            ImageLabel.this.revalidate();
            ImageLabel.this.repaint();
        }
    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CENTER;

    }
}

