/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreePopupListener
extends MouseAdapter {
    private final JPopupMenu popup;
    private final JTree tree;

    public TreePopupListener(JPopupMenu popupMenu, JTree tree) {
        this.popup = popupMenu;
        this.tree = tree;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            boolean selected = false;
            int row = this.tree.getClosestRowForLocation(e.getPoint().x, e.getPoint().y);
            TreePath[] paths = this.tree.getSelectionPaths();
            if (paths != null) {
                for (TreePath path : paths) {
                    if (path.getPathCount() <= 1 || this.tree.getRowForPath(path) != row) continue;
                    selected = true;
                }
            }
            if (!selected) {
                this.tree.getSelectionModel().setSelectionPath(this.tree.getPathForRow(row));
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

