/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.entities.Rating;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;

public class VSMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(VSMeta.class);
    private HashMap<String, Object> ids = new HashMap(0);
    private String title1 = "";
    private String title2 = "";
    private String title3 = "";
    private String description = "";
    private String json = "";
    private MovieSet movieSet = null;
    private float rating = 0.0f;
    private String year = "";
    private String date = "";
    private Certification certification = Certification.UNKNOWN;
    private List<MediaArtwork> artworks = new ArrayList<MediaArtwork>(0);
    private List<MediaGenres> genres = new ArrayList<MediaGenres>(0);
    private List<MediaCastMember> cast = new ArrayList<MediaCastMember>(0);
    private byte[] fileArray = new byte[0];
    private int currentpos;

    public void parseFile(Path file) {
        try {
            this.fileArray = Files.readAllBytes(file);
            if (this.fileArray.length < 30) {
                LOGGER.warn("SYNO: Invalid file", (Object)file);
                return;
            }
            LOGGER.debug("SYNO: found valid .vsmeta - try to parse metadata...");
            int maxLength = this.fileArray.length > 5000 ? 5000 : this.fileArray.length - 1;
            this.currentpos = 0;
            while (this.currentpos < maxLength) {
                int b = this.fileArray[this.currentpos] & 0xFF;
                String ret = "";
                switch (b) {
                    case 18: 
                    case 26: 
                    case 34: 
                    case 50: 
                    case 66: 
                    case 74: 
                    case 90: {
                        ret = this.parseLengthString();
                        break;
                    }
                    case 82: {
                        ret = this.parseLengthString();
                        this.parseCaseGenre(ret.getBytes());
                        break;
                    }
                    case 40: {
                        ++this.currentpos;
                        int length = this.getLength(this.fileArray[this.currentpos], this.fileArray[this.currentpos + 1]);
                        if (length > 127) {
                            ++this.currentpos;
                        }
                        ret = String.valueOf(length);
                        break;
                    }
                    case 96: {
                        this.currentpos = maxLength + 1;
                        break;
                    }
                    default: {
                        LOGGER.trace("*** skip " + this.currentpos);
                    }
                }
                switch (b) {
                    case 18: {
                        this.title1 = ret;
                        break;
                    }
                    case 26: {
                        this.title2 = ret;
                        break;
                    }
                    case 34: {
                        this.title3 = ret;
                        break;
                    }
                    case 40: {
                        this.year = ret;
                        break;
                    }
                    case 50: {
                        this.date = ret;
                        break;
                    }
                    case 66: {
                        this.description = ret;
                        break;
                    }
                    case 74: {
                        this.json = ret;
                        break;
                    }
                    case 90: {
                        this.certification = Certification.findCertification((String)ret);
                        break;
                    }
                }
                ++this.currentpos;
            }
            this.fileArray = null;
            this.parseJSON();
        }
        catch (Exception e) {
            LOGGER.warn("SYNO: Error parsing file", (Throwable)e);
        }
    }

    private String parseLengthString() {
        String ret = "";
        int length = 0;
        LOGGER.trace("SYNO: Pos: " + this.currentpos + " Byt: 0x" + Integer.toHexString(this.fileArray[this.currentpos]));
        ++this.currentpos;
        length = this.getLength(this.fileArray[this.currentpos], this.fileArray[this.currentpos + 1]);
        LOGGER.trace("SYNO: Len: " + length);
        ++this.currentpos;
        if (length > 127) {
            ++this.currentpos;
        }
        if ("null".equals(ret = new String(Arrays.copyOfRange(this.fileArray, this.currentpos, this.currentpos + length)))) {
            ret = "";
        }
        this.currentpos += length - 1;
        LOGGER.trace("SYNO: " + ret);
        return ret;
    }

    private void parseCaseGenre(byte[] array) {
        MediaCastMember mcm = null;
        int length = 0;
        String ret = "";
        block6: for (int i = 0; i < array.length - 1; ++i) {
            int b = array[i] & 0xFF;
            LOGGER.trace("SYNO: Pos: " + this.currentpos + " Byt: 0x" + Integer.toHexString(this.fileArray[this.currentpos]));
            length = this.getLength(array[++i], array[i + 1]);
            LOGGER.trace("SYNO: Len: " + length);
            ++i;
            if (length > 127) {
                ++i;
            }
            ret = new String(Arrays.copyOfRange(array, i, i + length));
            i += length - 1;
            LOGGER.trace("SYNO: " + ret);
            switch (b) {
                case 10: {
                    mcm = new MediaCastMember(MediaCastMember.CastType.ACTOR);
                    mcm.setName(ret);
                    this.cast.add(mcm);
                    continue block6;
                }
                case 18: {
                    mcm = new MediaCastMember(MediaCastMember.CastType.DIRECTOR);
                    mcm.setName(ret);
                    this.cast.add(mcm);
                    continue block6;
                }
                case 34: {
                    mcm = new MediaCastMember(MediaCastMember.CastType.WRITER);
                    mcm.setName(ret);
                    this.cast.add(mcm);
                    continue block6;
                }
                case 26: {
                    this.genres.add(MediaGenres.getGenre((String)ret));
                    continue block6;
                }
            }
        }
    }

    private void parseJSON() {
        if (StringUtils.isBlank((CharSequence)this.json)) {
            return;
        }
        try {
            LOGGER.trace("SYNO: try to parse additional JSON info...");
            JsonReader reader = new JsonReader((Reader)new StringReader(this.json));
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.startsWith("com.synology")) {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        String value;
                        String key;
                        MediaArtwork ma;
                        String value2;
                        name = reader.nextName();
                        if (name.equals("backdrop")) {
                            reader.beginArray();
                            while (reader.hasNext()) {
                                value2 = reader.nextString();
                                LOGGER.trace("SYNO: found backdrop: " + value2);
                                ma = new MediaArtwork("com.synology", MediaArtwork.MediaArtworkType.BACKGROUND);
                                ma.setDefaultUrl(value2);
                                this.artworks.add(ma);
                            }
                            reader.endArray();
                            continue;
                        }
                        if (name.equals("poster")) {
                            reader.beginArray();
                            while (reader.hasNext()) {
                                value2 = reader.nextString();
                                LOGGER.trace("SYNO: found poster: " + value2);
                                ma = new MediaArtwork("com.synology", MediaArtwork.MediaArtworkType.POSTER);
                                ma.setDefaultUrl(value2);
                                this.artworks.add(ma);
                            }
                            reader.endArray();
                            continue;
                        }
                        if (name.equals("rating")) {
                            reader.beginObject();
                            while (reader.hasNext()) {
                                key = reader.nextName();
                                value = reader.nextString();
                                LOGGER.trace("SYNO: found rating: " + key + " - " + value);
                                try {
                                    float f;
                                    this.rating = f = Float.parseFloat(value);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                            reader.endObject();
                            continue;
                        }
                        if (name.equals("reference")) {
                            reader.beginObject();
                            while (reader.hasNext()) {
                                key = reader.nextName();
                                value = reader.nextString();
                                LOGGER.trace("SYNO: found ID: " + key + " = " + value);
                                switch (key) {
                                    case "imdb": {
                                        this.ids.put("imdb", value);
                                        break;
                                    }
                                    case "thetvdb": {
                                        this.ids.put("tvdb", value);
                                        break;
                                    }
                                    case "themoviedb": {
                                        try {
                                            int t = Integer.parseInt(value);
                                            this.ids.put("tmdb", t);
                                        }
                                        catch (NumberFormatException t) {}
                                        break;
                                    }
                                }
                            }
                            reader.endObject();
                            continue;
                        }
                        if (name.equals("collection_id")) {
                            reader.beginObject();
                            while (reader.hasNext()) {
                                key = reader.nextName();
                                value = reader.nextString();
                                LOGGER.trace("SYNO: found SetID: " + key + " = " + value);
                                switch (key) {
                                    case "themoviedb": {
                                        try {
                                            int t = Integer.parseInt(value);
                                            this.movieSet = MovieList.getInstance().getMovieSet(this.title1 + "_col", t);
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                        break;
                                    }
                                }
                            }
                            reader.endObject();
                            continue;
                        }
                        reader.skipValue();
                    }
                } else {
                    reader.skipValue();
                }
                reader.endObject();
            }
            reader.endObject();
            reader.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not parse Synology VSMETA file: ", (Throwable)e);
        }
    }

    public Movie getMovie() {
        Movie m = new Movie();
        m.setIds(this.ids);
        m.setTitle(this.title1);
        m.setTagline(this.title3);
        m.setPlot(this.description);
        m.setReleaseDate(this.date);
        try {
            m.setYear(Integer.parseInt(this.year));
        }
        catch (Exception e) {
            m.setYear(0);
        }
        if (this.rating > 0.0f) {
            Rating r = new Rating("NFO", this.rating);
            m.setRating(r);
        }
        m.setCertification(this.certification);
        if (this.movieSet != null) {
            m.setMovieSet(this.movieSet);
        }
        for (MediaArtwork ma : this.artworks) {
            m.setArtworkUrl(ma.getDefaultUrl(), MediaFileType.getMediaFileType(ma.getType()));
        }
        for (MediaGenres g : this.genres) {
            m.addGenre(g);
        }
        for (MediaCastMember mcm : this.cast) {
            switch (mcm.getType()) {
                case ACTOR: {
                    m.addActor(new Person(mcm));
                    break;
                }
                case DIRECTOR: {
                    m.addDirector(new Person(mcm));
                    break;
                }
                case WRITER: {
                    m.addDirector(new Person(mcm));
                    break;
                }
            }
        }
        return m;
    }

    public TvShowEpisode getTvShowEpisode() {
        TvShowEpisode ep = new TvShowEpisode();
        ep.setIds(this.ids);
        ep.setTitle(this.title3);
        ep.setPlot(this.description);
        ep.setFirstAired(this.date);
        try {
            ep.setYear(Integer.parseInt(this.year));
        }
        catch (Exception e) {
            ep.setYear(0);
        }
        if (this.rating > 0.0f) {
            Rating r = new Rating("NFO", this.rating);
            ep.setRating(r);
        }
        for (MediaArtwork ma : this.artworks) {
            ep.setArtworkUrl(ma.getDefaultUrl(), MediaFileType.getMediaFileType(ma.getType()));
        }
        for (MediaCastMember mcm : this.cast) {
            switch (mcm.getType()) {
                case ACTOR: {
                    ep.addActor(new Person(mcm));
                    break;
                }
                case DIRECTOR: {
                    ep.addDirector(new Person(mcm));
                    break;
                }
                case WRITER: {
                    ep.addWriter(new Person(mcm));
                    break;
                }
            }
        }
        return ep;
    }

    private int getLength(byte by1, byte by2) {
        int length = 0;
        int b1 = by1 & 0xFF;
        int b2 = by2 & 0xFF;
        length = b2 > 0 && b2 < 20 ? b1 + (b2 - 1) * 128 : b1;
        return length;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

