/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.types.UDN;
import org.fourthline.cling.registry.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.thirdparty.upnp.Upnp;

public class SplitUri {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplitUri.class);
    public String file = "";
    public String datasource = "";
    public String label = "";
    public String type = "";
    public String ip = "";
    public String hostname = "";
    private Map<String, String> lookup = new HashMap<String, String>();

    private SplitUri() {
    }

    public SplitUri(String ds, String file) {
        this(ds, file, "", "");
    }

    public SplitUri(String ds, String file, String label, String ipForLocal) {
        if (ds.matches(".*[\\\\/]$")) {
            ds = ds.substring(0, ds.length() - 1);
        }
        if (file.startsWith(ds)) {
            file = file.substring(ds.length());
        }
        this.datasource = ds;
        this.file = file;
        int schema = file.indexOf("://");
        if (schema == -1) {
            schema = file.indexOf(":\\\\");
        }
        if (schema > 0) {
            this.file = this.file.substring(schema + 3);
        }
        this.file = Paths.get(this.file, new String[0]).toString();
        this.label = label;
        URI u = null;
        try {
            try {
                ds = URLDecoder.decode(ds, "UTF-8");
                ds = URLDecoder.decode(ds, "UTF-8");
                ds = URLDecoder.decode(ds, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.warn("Could not decode uri '{}': {}", (Object)ds, (Object)e.getMessage());
            }
            ds = ds.replaceAll("\\\\", "/");
            if (ds.endsWith("/")) {
                ds = ds.substring(0, ds.length() - 1);
            }
            if (ds.contains(":///")) {
                ds = ds.replaceAll(" ", "%20");
                ds = ds.replaceAll("#", "%23");
                u = new URI(ds.substring(ds.indexOf(":///") + 3));
            } else if (ds.contains("://")) {
                ds = ds.replaceAll(" ", "%20");
                ds = ds.replaceAll("#", "%23");
                u = new URI(ds);
            } else {
                u = Paths.get(ds, new String[0]).toUri();
            }
        }
        catch (URISyntaxException e) {
            try {
                ds = ds.replaceAll(".*?:/{2,3}", "");
                u = Paths.get(ds, new String[0]).toAbsolutePath().toUri();
            }
            catch (InvalidPathException e2) {
                LOGGER.warn("Invalid path: {} - {}", (Object)ds, (Object)e2.getMessage());
            }
        }
        catch (InvalidPathException e) {
            LOGGER.warn("Invalid path: {} - {}", (Object)ds, (Object)e.getMessage());
        }
        if (u != null && !StringUtils.isBlank((CharSequence)u.getHost())) {
            if (ds.startsWith("upnp")) {
                Device foundDevice;
                Registry registry;
                this.type = "UPNP";
                this.hostname = SplitUri.getMacFromUpnpUUID(u.getHost());
                UpnpService us = Upnp.getInstance().getUpnpService();
                if (us != null && (registry = us.getRegistry()) != null && (foundDevice = registry.getDevice(UDN.valueOf((String)u.getHost()), true)) != null) {
                    this.ip = foundDevice.getDetails().getPresentationURI().getHost();
                }
            } else {
                this.type = u.getScheme().toUpperCase(Locale.ROOT);
                this.hostname = u.getHost();
                try {
                    String ip = this.lookup.get(u.getHost());
                    if (ip == null) {
                        InetAddress i = InetAddress.getByName(u.getHost());
                        ip = i.getHostAddress();
                        this.lookup.put(u.getHost(), ip);
                    }
                    this.ip = ip;
                }
                catch (Exception e) {
                    LOGGER.warn("Could not lookup IP for {}: {}", (Object)u.getHost(), (Object)e.getMessage());
                }
            }
            this.datasource = u.getPath();
        } else {
            this.type = "LOCAL";
            if (ipForLocal.isEmpty()) {
                this.ip = "127.0.0.1";
                this.hostname = "localhost";
            } else {
                try {
                    String tmp = this.lookup.get(ipForLocal);
                    if (tmp == null) {
                        InetAddress i = InetAddress.getByName(ipForLocal);
                        this.ip = i.getHostAddress();
                        this.hostname = i.getHostName();
                        this.lookup.put(ipForLocal, this.ip);
                        this.lookup.put(this.hostname, this.ip);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Could not lookup hostname for {}: {}", (Object)ipForLocal, (Object)e.getMessage());
                }
            }
        }
        try {
            this.datasource = Paths.get(this.datasource, new String[0]).toString();
        }
        catch (Exception e) {
            LOGGER.warn("Invalid path: {} - {}", (Object)ds, (Object)e.getMessage());
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SplitUri other = (SplitUri)obj;
        if (this.datasource == null || this.datasource.isEmpty() || other.datasource == null || other.datasource.isEmpty()) {
            return false;
        }
        if (this.file.equals(other.file) && this.datasource.equals(other.datasource)) {
            return true;
        }
        if (this.file.equals(other.file) && this.ip != null && !this.ip.isEmpty() && this.ip.equals(other.ip)) {
            return true;
        }
        return this.file.equals(other.file) && this.hostname != null && !this.hostname.isEmpty() && this.hostname.equalsIgnoreCase(other.hostname);
    }

    private static String getMacFromUpnpUUID(String uuid) {
        String s = uuid.substring(uuid.lastIndexOf(45) + 1);
        StringBuilder result = new StringBuilder();
        for (int i = s.length() - 2; i >= 0; i -= 2) {
            result.append((CharSequence)new StringBuilder(s.substring(i, i + 2)));
            result.append(i > 1 ? ":" : "");
        }
        return result.toString().toUpperCase(Locale.ROOT);
    }
}

