/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util.youtube.model.quality;

public enum VideoQuality {
    UNKNOWN("UNKNOWN"),
    HIGHRES("3072p"),
    HD_2160("2160p"),
    HD_1440("1440p"),
    HD_1080("1080p"),
    HD_720("720p"),
    LARGE("480p"),
    MEDIUM("360p"),
    SMALL("240p"),
    TINY("144p"),
    NO_VIDEO("NO_VIDEO");

    private String text;

    private VideoQuality(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public static VideoQuality getVideoQuality(String text) {
        for (VideoQuality v : VideoQuality.values()) {
            if (!v.text.equalsIgnoreCase(text)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with text: " + text + "found");
    }
}

