/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util.youtube.model.formats;

import com.fasterxml.jackson.databind.JsonNode;
import org.tinymediamanager.scraper.util.youtube.YoutubeHelper;
import org.tinymediamanager.scraper.util.youtube.model.Itag;
import org.tinymediamanager.scraper.util.youtube.model.formats.Format;
import org.tinymediamanager.scraper.util.youtube.model.quality.AudioQuality;

public class AudioFormat
extends Format {
    private final Integer audioSampleRate;

    public AudioFormat(JsonNode json, Itag itag) {
        super(json, itag);
        this.audioSampleRate = YoutubeHelper.getInt(json, "audio_sample_rate");
    }

    @Override
    public String type() {
        return "audio";
    }

    public AudioQuality audioQuality() {
        return this.itag.audioQuality();
    }

    public Integer audioSampleRate() {
        return this.audioSampleRate;
    }
}

