/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util.youtube.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.util.UrlUtil;
import org.tinymediamanager.scraper.util.youtube.model.Extension;
import org.tinymediamanager.scraper.util.youtube.model.Itag;
import org.tinymediamanager.scraper.util.youtube.model.MediaDetails;
import org.tinymediamanager.scraper.util.youtube.model.formats.AudioFormat;
import org.tinymediamanager.scraper.util.youtube.model.formats.Format;
import org.tinymediamanager.scraper.util.youtube.model.formats.VideoFormat;
import org.tinymediamanager.scraper.util.youtube.model.quality.AudioQuality;
import org.tinymediamanager.scraper.util.youtube.model.quality.VideoQuality;

public class YoutubeMedia {
    private MediaDetails videoDetails;
    private List<Format> formats;
    private String videoId;
    private static final Logger LOGGER = LoggerFactory.getLogger(YoutubeMedia.class);
    private static final String CONFIG_START = "ytplayer.config = ";
    private static final String CONFIG_END = ";ytplayer.load";
    private static final String ERROR = "\"status\":\"ERROR\",\"reason\":\"";
    private static final String URL = "https://www.youtube.com/watch?v=";

    public YoutubeMedia(String videoId) {
        this.videoId = videoId;
        this.videoDetails = new MediaDetails(videoId);
    }

    public MediaDetails getDetails() {
        return this.videoDetails;
    }

    public List<Format> getFormats() {
        return this.formats;
    }

    public VideoFormat findVideo(VideoQuality videoQuality, Extension extension) {
        for (Format format : this.formats) {
            if (!(format instanceof VideoFormat) || ((VideoFormat)format).videoQuality() != videoQuality || !format.extension().equals((Object)extension)) continue;
            return (VideoFormat)format;
        }
        LOGGER.error("could not find video with quality {} and format {}", (Object)videoQuality.getText(), (Object)extension.getText());
        return null;
    }

    public AudioFormat findBestAudio(Extension extension) {
        for (AudioQuality quality : Itag.getAudioQualityList()) {
            for (Format format : this.formats) {
                if (!(format instanceof AudioFormat) || ((AudioFormat)format).audioQuality() != quality || !format.extension().equals((Object)extension)) continue;
                return (AudioFormat)format;
            }
        }
        LOGGER.error("Could not find audio format for extension {}", (Object)extension.getText());
        return null;
    }

    public void parseVideo() throws InterruptedException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String page = UrlUtil.getStringFromUrl((String)(URL + this.videoId));
        int start = page.indexOf(CONFIG_START);
        int end = page.indexOf(CONFIG_END);
        if (start == -1 || end == -1) {
            int errorIndex = page.indexOf(ERROR);
            if (errorIndex != -1) {
                String reason = page.substring(errorIndex + ERROR.length(), page.indexOf(34, errorIndex + ERROR.length() + 1));
                LOGGER.error("Could not parse webpage: {} ", (Object)reason);
            } else {
                LOGGER.error("Could not parse webpage");
            }
        }
        JsonNode cfgArgs = objectMapper.readTree(page.substring(start + CONFIG_START.length(), end)).get("args");
        this.videoDetails.setDetails(objectMapper.readTree(cfgArgs.get("player_response").asText()).get("videoDetails"));
        ArrayNode jsonAdaptiveFormats = this.parseFormats(cfgArgs.get("adaptive_fmts").asText());
        this.formats = new ArrayList<Format>(jsonAdaptiveFormats.size() + 1);
        for (int i = 0; i < jsonAdaptiveFormats.size(); ++i) {
            JsonNode json = jsonAdaptiveFormats.get(i);
            try {
                Itag itag = Itag.findItag(json.get("itag").asInt(0));
                if (itag == null) continue;
                if (itag.isVideo()) {
                    this.formats.add(new VideoFormat(json, itag));
                    continue;
                }
                if (!itag.isAudio()) continue;
                this.formats.add(new AudioFormat(json, itag));
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error while getting video and audioformats");
            }
        }
    }

    private ArrayNode parseFormats(String formats) {
        ArrayNode array = new ObjectMapper().createArrayNode();
        String splitBy = formats.substring(0, formats.indexOf(61) + 1);
        Pattern pattern = Pattern.compile("&" + splitBy + "|^" + splitBy + "|," + splitBy);
        for (String s : pattern.split(formats)) {
            ObjectNode params;
            if (!StringUtils.isNotBlank((CharSequence)s) || !(params = this.splitQuery(splitBy + s)).has("url")) continue;
            array.add((JsonNode)params);
        }
        return array;
    }

    private ObjectNode splitQuery(String requestString) {
        ObjectNode queryPairs = new ObjectMapper().createObjectNode();
        try {
            if (requestString != null) {
                String[] pairs;
                for (String pair : pairs = requestString.split("&")) {
                    String[] commaPairs;
                    for (String commaPair : commaPairs = pair.split(",")) {
                        int idx = commaPair.indexOf(61);
                        if (idx <= 0) continue;
                        queryPairs.put(URLDecoder.decode(commaPair.substring(0, idx), "UTF-8"), URLDecoder.decode(commaPair.substring(idx + 1), "UTF-8"));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot split request string: {}", (Object)requestString);
        }
        return queryPairs;
    }
}

