/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.util.Pair;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.w3c.tidy.Tidy;

public class ParserUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserUtils.class);
    private static final String DELIMITER = "[\\[\\](){} _,.-]";
    public static String[] stopwords = new String[]{"1080", "1080i", "1080p", "2160p", "2160i", "3d", "480i", "480p", "576i", "576p", "720", "720i", "720p", "ac3", "ac3ld", "ac3md", "aoe", "atmos", "bd5", "bdrip", "bdrip", "blueray", "bluray", "brrip", "cam", "cd1", "cd2", "cd3", "cd4", "cd5", "cd6", "cd7", "cd8", "cd9", "complete", "custom", "dc", "disc1", "disc2", "disc3", "disc4", "disc5", "disc6", "disc7", "disc8", "disc9", "divx", "divx5", "dl", "docu", "dsr", "dsrip", "dts", "dtv", "dubbed", "dutch", "dvd", "dvd1", "dvd2", "dvd3", "dvd4", "dvd5", "dvd6", "dvd7", "dvd8", "dvd9", "dvdivx", "dvdrip", "dvdscr", "dvdscreener", "emule", "etm", "extended", "fragment", "fs", "fps", "german", "h264", "hd", "hddvd", "hdrip", "hdtv", "hdtvrip", "hevc", "hrhd", "hrhdtv", "ind", "internal", "ld", "limited", "ma", "md", "multisubs", "nfo", "nfofix", "ntg", "ntsc", "ogg", "ogm", "pal", "pdtv", "proper", "pso", "r3", "r5", "read", "repack", "rerip", "remux", "retail", "roor", "rs", "rsvcd", "screener", "se", "subbed", "svcd", "swedish", "tc", "telecine", "telesync", "ts", "truehd", "uncut", "unrated", "vcf", "webdl", "webrip", "workprint", "ws", "www", "x264", "xf", "xvid", "xvidvd", "xxx"};
    public static String[] cleanwords = new String[]{"24\\.000", "23\\.976", "23\\.98", "24\\.00"};

    @Deprecated
    public static String detectCleanMoviename(String filename) {
        return ParserUtils.detectCleanMovienameAndYear(filename)[0];
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String[] detectCleanMovienameAndYearOLD(String filename) {
        void var7_12;
        String[] ret = new String[]{"", ""};
        LOGGER.trace("Parse filename for movie title: \"" + filename + "\"");
        if (filename == null || filename.isEmpty()) {
            LOGGER.warn("Filename empty?!");
            return ret;
        }
        String fname = filename.replaceFirst("\\.\\w{2,4}$", "");
        String cleaned = fname.replaceFirst("(?i)\\W\\d{3,4}x\\d{3,4}", " ");
        for (String string : cleanwords) {
            cleaned = cleaned.replaceFirst("(?i)\\W" + string, " ");
        }
        String[] s = cleaned.split(DELIMITER);
        int firstFoundStopwordPosition = s.length;
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null || s[i].isEmpty()) continue;
            for (String stop : stopwords) {
                if (!s[i].equalsIgnoreCase(stop)) continue;
                s[i] = "";
                if (i >= firstFoundStopwordPosition || i < 2) continue;
                firstFoundStopwordPosition = i;
            }
            if (!Utils.isValidImdbId(s[i])) continue;
            s[i] = "";
        }
        String year = "";
        int n = s.length - 1;
        while (var7_12 > 0) {
            if (!s[var7_12].isEmpty() && s[var7_12].matches("\\d{4}")) {
                int currentYear = Calendar.getInstance().get(1);
                int parsedYear = Integer.parseInt(s[var7_12]);
                if (parsedYear > 1800 && parsedYear < currentYear + 5) {
                    LOGGER.trace("removed token '" + s[var7_12] + "'- seems to be year");
                    year = s[var7_12];
                    s[var7_12] = "";
                    break;
                }
            }
            --var7_12;
        }
        StringBuilder stringBuilder = new StringBuilder();
        block19: for (int i = 0; i < firstFoundStopwordPosition; ++i) {
            if (s[i] != null && s[i].isEmpty() || MovieModuleManager.SETTINGS.getBadWord().contains(s[i].toLowerCase(Locale.ROOT))) continue;
            String word = s[i];
            switch (word.toUpperCase(Locale.ROOT)) {
                case "I": 
                case "II": 
                case "III": 
                case "IV": 
                case "V": 
                case "VI": 
                case "VII": 
                case "VIII": 
                case "IX": 
                case "X": {
                    stringBuilder.append(word.toUpperCase(Locale.ROOT)).append(" ");
                    continue block19;
                }
                default: {
                    stringBuilder.append(WordUtils.capitalizeFully((String)word)).append(" ");
                }
            }
        }
        ret[0] = stringBuilder.length() == 0 ? fname : stringBuilder.toString().trim();
        ret[1] = year.trim();
        LOGGER.trace("Movie title should be: \"" + ret[0] + "\", from " + ret[1]);
        return ret;
    }

    public static String[] detectCleanMovienameAndYear(String filename) {
        String[] s;
        String[] ret = new String[]{"", ""};
        LOGGER.trace("Parse filename for movie title: \"" + filename + "\"");
        if (filename == null || filename.isEmpty()) {
            LOGGER.warn("Filename empty?!");
            return ret;
        }
        String fname = filename.replaceFirst("\\.\\w{2,4}$", "");
        fname = fname.replaceFirst("(?i)\\W\\d{3,4}x\\d{3,4}", " ");
        for (String cw : cleanwords) {
            fname = fname.replaceFirst("(?i)\\W" + cw, " ");
        }
        LOGGER.trace("--------------------");
        LOGGER.trace("IN:  " + fname);
        ArrayList<String> opt = new ArrayList<String>();
        Pattern p = Pattern.compile("\\[(.*?)\\]");
        Matcher m = p.matcher(fname);
        while (m.find()) {
            LOGGER.trace("OPT: " + m.group(1));
            String[] o = StringUtils.split((String)m.group(1), (String)DELIMITER);
            opt.addAll(Arrays.asList(o));
            fname = fname.replace(m.group(), "");
        }
        LOGGER.trace("ARR: " + opt);
        p = Pattern.compile(".*?(_\\d{2}\\.\\d{2}\\.\\d{2}[_ ]+\\d{2}\\-\\d{2}\\_).*");
        m = p.matcher(fname);
        if (m.matches() && m.start(1) > 10) {
            LOGGER.trace("OTR: " + m.group(1));
            fname = fname.substring(0, m.start(1));
        }
        if ((s = StringUtils.split((String)fname, (String)DELIMITER)).length == 0) {
            s = opt.toArray(new String[opt.size()]);
        }
        int firstFoundStopwordPosition = s.length;
        for (int i = 0; i < s.length; ++i) {
            for (String stop : stopwords) {
                if (!s[i].equalsIgnoreCase(stop)) continue;
                s[i] = "";
                if (i >= firstFoundStopwordPosition || i < 2) continue;
                firstFoundStopwordPosition = i;
            }
            if (!Utils.isValidImdbId(s[i])) continue;
            s[i] = "";
        }
        int currentYear = Calendar.getInstance().get(1);
        String year = "";
        for (int i = s.length - 1; i > 0; --i) {
            int parsedYear;
            if (!s[i].matches("\\d{4}") || (parsedYear = Integer.parseInt(s[i])) <= 1800 || parsedYear >= currentYear + 5) continue;
            LOGGER.trace("removed token '" + s[i] + "'- seems to be year");
            year = s[i];
            s[i] = "";
            break;
        }
        if (year.isEmpty()) {
            for (String o : opt) {
                int parsedYear;
                if (!o.matches("\\d{4}") || (parsedYear = Integer.parseInt(o)) <= 1800 || parsedYear >= currentYear + 5) continue;
                year = String.valueOf(parsedYear);
                LOGGER.trace("found possible year " + o);
            }
        }
        StringBuilder name = new StringBuilder();
        block21: for (int i = 0; i < firstFoundStopwordPosition; ++i) {
            if (s[i].isEmpty() || MovieModuleManager.SETTINGS.getBadWord().contains(s[i].toLowerCase(Locale.ROOT))) continue;
            String word = s[i];
            switch (word.toUpperCase(Locale.ROOT)) {
                case "I": 
                case "II": 
                case "III": 
                case "IV": 
                case "V": 
                case "VI": 
                case "VII": 
                case "VIII": 
                case "IX": 
                case "X": {
                    name.append(word.toUpperCase(Locale.ROOT)).append(" ");
                    continue block21;
                }
                default: {
                    name.append(WordUtils.capitalizeFully((String)word)).append(" ");
                }
            }
        }
        ret[0] = name.length() == 0 ? fname : name.toString().trim();
        ret[1] = year.trim();
        LOGGER.trace("Movie title should be: \"" + ret[0] + "\", from " + ret[1]);
        return ret;
    }

    public static String detectImdbId(String text) {
        String imdb = "";
        if (text != null && !text.isEmpty() && (imdb = StrgUtils.substr((String)text, (String)".*(tt\\d{7}).*")).isEmpty() && !(imdb = StrgUtils.substr((String)text, (String)".*imdb\\.com\\/Title\\?(\\d{7}).*")).isEmpty()) {
            imdb = "tt" + imdb;
        }
        return imdb;
    }

    public static String removeStopwordsAndBadwordsFromTvEpisodeName(String filename) {
        String before = filename;
        filename = filename.replaceFirst("(?i)\\W\\d{3,4}x\\d{3,4}", " ");
        for (String s : stopwords) {
            filename = filename.replaceAll("(?i)\\W" + s + "(\\W|$)", " ");
            if (!LOGGER.isTraceEnabled() || filename.length() == before.length()) continue;
            LOGGER.trace("Removed some TV stopword (" + s + "): " + before + " -> " + filename);
            before = filename;
        }
        for (String s : TvShowModuleManager.SETTINGS.getBadWord()) {
            filename = filename.replaceAll("(?i)\\W" + s + "(\\W|$)", " ");
            if (!LOGGER.isTraceEnabled() || filename.length() == before.length()) continue;
            LOGGER.trace("Removed some TV bad word (" + s + "): " + before + " -> " + filename);
            before = filename;
        }
        return filename;
    }

    public static String[] parseTitle(String title) {
        String[] v = new String[]{"", ""};
        if (title == null) {
            return v;
        }
        Pattern p = Pattern.compile("(.*)\\s+\\(?([0-9]{4})\\)?", 2);
        Matcher m = p.matcher(title);
        if (m.find()) {
            v[0] = m.group(1);
            v[1] = m.group(2);
        } else {
            v[0] = title;
        }
        return v;
    }

    public static Pair<String, String> parseTitleAndDateInBrackets(String title) {
        if (title == null) {
            return new Pair(null, null);
        }
        Pattern p = Pattern.compile("(.*)\\s+\\(?([0-9]{4})\\)?", 2);
        Matcher m = p.matcher(title);
        if (m.find()) {
            return new Pair((Object)m.group(1), (Object)m.group(2));
        }
        return new Pair((Object)title, null);
    }

    public static String cleanNfo(String sourceNfoContent) {
        try {
            Tidy tidy = new Tidy();
            tidy.setInputEncoding("UTF-8");
            tidy.setOutputEncoding("UTF-8");
            tidy.setWraplen(Integer.MAX_VALUE);
            tidy.setXmlOut(true);
            tidy.setSmartIndent(true);
            tidy.setXmlTags(true);
            tidy.setMakeClean(true);
            tidy.setForceOutput(true);
            tidy.setQuiet(true);
            tidy.setShowWarnings(false);
            StringReader in = new StringReader(sourceNfoContent);
            StringWriter out = new StringWriter();
            tidy.parse((Reader)in, (Writer)out);
            return out.toString();
        }
        catch (Exception exception) {
            return sourceNfoContent;
        }
    }

    public static ParserInfo getCleanerString(String ... names) {
        ArrayList<ParserInfo> info = new ArrayList<ParserInfo>(1);
        ParserInfo ret = null;
        int rate = -10000;
        for (String s : names) {
            info.add(new ParserInfo(s));
        }
        for (ParserInfo i : info) {
            int tmp = ParserUtils.rateCleanness(i);
            if (tmp <= rate) continue;
            ret = i;
            rate = tmp;
        }
        return ret;
    }

    public static int rateCleanness(ParserInfo info) {
        if (info.clean.isEmpty()) {
            return -1;
        }
        int rate = 0;
        int words = info.clean.split(" ").length;
        int seps = info.clean.split("[_.-]").length - 1;
        int uc = info.clean.replaceAll("[^A-Z]", "").length();
        int lc = info.clean.replaceAll("[A-Z]", "").length();
        double cleaned = 100 - info.clean.length() * 100 / info.name.length();
        int cc = 0;
        Pattern pattern = Pattern.compile("[A-Z][a-z]");
        Matcher matcher = pattern.matcher(info.clean);
        while (matcher.find()) {
            ++cc;
        }
        rate = cc * 20 + (10 - words * 2) * 2 + seps * -20 - info.clean.length() * 2 + (int)cleaned;
        if (!info.year.isEmpty()) {
            rate += 20;
        }
        LOGGER.trace(info + " - Rate:" + rate + "    PERC:" + cleaned + " LEN:" + info.clean.length() + " WRD:" + words + " UC:" + uc + " LC:" + lc + " CC:" + cc + " SEP:" + seps);
        return rate;
    }

    public static class ParserInfo {
        public String name = "";
        public String year = "";
        public String clean = "";

        ParserInfo(String name) {
            this.name = name.trim();
            String[] ty = ParserUtils.detectCleanMovienameAndYear(this.name);
            this.clean = ty[0];
            this.year = ty[1];
        }

        public String toString() {
            return this.clean + " (" + this.year + ")";
        }
    }
}

