/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakttv;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.TraktV2Interceptor;
import com.uwetrottmann.trakt5.entities.AccessToken;
import com.uwetrottmann.trakt5.entities.BaseEpisode;
import com.uwetrottmann.trakt5.entities.BaseMovie;
import com.uwetrottmann.trakt5.entities.BaseSeason;
import com.uwetrottmann.trakt5.entities.BaseShow;
import com.uwetrottmann.trakt5.entities.MovieIds;
import com.uwetrottmann.trakt5.entities.ShowIds;
import com.uwetrottmann.trakt5.entities.SyncEpisode;
import com.uwetrottmann.trakt5.entities.SyncErrors;
import com.uwetrottmann.trakt5.entities.SyncItems;
import com.uwetrottmann.trakt5.entities.SyncMovie;
import com.uwetrottmann.trakt5.entities.SyncResponse;
import com.uwetrottmann.trakt5.entities.SyncSeason;
import com.uwetrottmann.trakt5.entities.SyncShow;
import com.uwetrottmann.trakt5.entities.SyncStats;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.DateTimeUtils;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.util.ApiKey;
import retrofit2.Response;

public class TraktTv {
    private static final String CLIENT_ID = "a8e7e30fd7fd3f397b6e079f9f023e790f9cbd80a2be57c104089174fa8c6d89";
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktTv.class);
    private static final TraktV2 TRAKT = TraktTv.createTraktApi();
    private static TraktTv instance;
    private static MediaProviderInfo providerInfo;

    private static TraktV2 createTraktApi() {
        TraktV2 api = new TraktV2(CLIENT_ID, ApiKey.decryptApikey((String)"VD2h4jmnrrYWnP1Nk49UtTNRILiWsuelJKdza7DAw+ROh1wtVf2U6PQScm7QWCOTsxN0K3QluIykKs2ZT1af1GcPz1401005bDBDss1Pz2c="), "urn:ietf:wg:oauth:2.0:oob"){

            protected synchronized OkHttpClient okHttpClient() {
                OkHttpClient.Builder builder = TmmHttpClient.newBuilder();
                builder.addInterceptor((Interceptor)new TraktV2Interceptor((TraktV2)this));
                return builder.build();
            }
        };
        return api;
    }

    public static synchronized TraktTv getInstance() {
        if (instance == null) {
            instance = new TraktTv();
        }
        return instance;
    }

    public static Map<String, String> authenticateViaPin(String pin) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Response response = TRAKT.exchangeCodeForAccessToken(pin);
        String accessToken = ((AccessToken)response.body()).access_token;
        String refreshToken = ((AccessToken)response.body()).refresh_token;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken, refreshToken})) {
            result.put("accessToken", accessToken);
            result.put("refreshToken", refreshToken);
        }
        return result;
    }

    public static void refreshAccessToken() throws Exception {
        if (StringUtils.isBlank((CharSequence)Globals.settings.getTraktRefreshToken())) {
            throw new Exception("not trakt.tv refresh token found");
        }
        Response response = TRAKT.refreshToken(Globals.settings.getTraktRefreshToken()).refreshAccessToken(Globals.settings.getTraktRefreshToken());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((AccessToken)response.body()).access_token, ((AccessToken)response.body()).refresh_token})) {
            Globals.settings.setTraktAccessToken(((AccessToken)response.body()).access_token);
            Globals.settings.setTraktRefreshToken(((AccessToken)response.body()).refresh_token);
            TRAKT.accessToken(Globals.settings.getTraktAccessToken());
        }
    }

    private boolean isEnabled() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Globals.settings.getTraktAccessToken(), Globals.settings.getTraktRefreshToken()})) {
            TRAKT.accessToken(Globals.settings.getTraktAccessToken());
            return true;
        }
        return false;
    }

    public void syncTraktMovieCollection(List<Movie> moviesInTmm) {
        List traktMovies;
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<Movie> tmmMovies = new ArrayList<Movie>(moviesInTmm);
        LOGGER.info("got up to " + tmmMovies.size() + " movies for Trakt.tv collection sync");
        try {
            Response response = TRAKT.sync().collectionMovies(null).execute();
            if (!response.isSuccessful() && response.code() == 401) {
                TraktTv.refreshAccessToken();
                response = TRAKT.sync().collectionMovies(null).execute();
            }
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + response.message());
                return;
            }
            traktMovies = (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktMovies.size() + " movies in your Trakt.tv collection");
        for (BaseMovie traktMovie : traktMovies) {
            for (int i = tmmMovies.size() - 1; i >= 0; --i) {
                Movie tmmMovie = (Movie)tmmMovies.get(i);
                if (!this.matches(tmmMovie, traktMovie.movie.ids)) continue;
                boolean dirty = this.updateIDs(tmmMovie, traktMovie.movie.ids);
                if (traktMovie.collected_at != null) {
                    Date collectedAt = DateTimeUtils.toDate((Instant)traktMovie.collected_at.toInstant());
                    if (!collectedAt.equals(tmmMovie.getDateAdded())) {
                        LOGGER.trace("Marking movie '" + tmmMovie.getTitle() + "' as collected on " + collectedAt + " (was " + tmmMovie.getDateAddedAsString() + ")");
                    }
                    tmmMovie.setDateAdded(collectedAt);
                    dirty = true;
                }
                if (dirty) {
                    tmmMovie.writeNFO();
                    tmmMovie.saveToDb();
                }
                tmmMovies.remove(i);
            }
        }
        if (tmmMovies.size() == 0) {
            LOGGER.info("Already up-to-date - no need to add anything :)");
            return;
        }
        LOGGER.debug("prepare " + tmmMovies.size() + " movies for Trakt.tv collection sync");
        ArrayList<SyncMovie> movies = new ArrayList<SyncMovie>();
        int nosync = 0;
        for (Movie tmmMovie : tmmMovies) {
            if (tmmMovie.getIdAsInt(providerInfo.getId()) != 0 || !tmmMovie.getIdAsString("imdb").isEmpty() || tmmMovie.getIdAsInt("tmdb") != 0) {
                movies.add(this.toSyncMovie(tmmMovie, false));
                continue;
            }
            ++nosync;
        }
        if (nosync > 0) {
            LOGGER.debug("skipping " + nosync + " movies, because they have not been scraped yet!");
        }
        if (movies.size() == 0) {
            LOGGER.info("no new movies for Trakt collection sync found.");
            return;
        }
        try {
            LOGGER.info("Adding " + movies.size() + " movies to Trakt.tv collection");
            SyncItems items = new SyncItems().movies(movies);
            Response response = TRAKT.sync().addItemsToCollection(items).execute();
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + response.message());
                return;
            }
            LOGGER.info("Trakt add-to-library status:");
            this.printStatus((SyncResponse)response.body());
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
        }
    }

    public void syncTraktMovieCollection() {
        if (!this.isEnabled()) {
            return;
        }
        this.syncTraktMovieCollection(new ArrayList<Movie>(MovieList.getInstance().getMovies()));
    }

    public void clearTraktMovies() {
        Response response;
        SyncItems items;
        List traktWatched;
        List traktCollection;
        try {
            Response traktCollectionResponse = TRAKT.sync().collectionMovies(null).execute();
            if (!traktCollectionResponse.isSuccessful() && traktCollectionResponse.code() == 401) {
                TraktTv.refreshAccessToken();
                traktCollectionResponse = TRAKT.sync().collectionMovies(null).execute();
            }
            if (!traktCollectionResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + traktCollectionResponse.message());
                return;
            }
            traktCollection = (List)traktCollectionResponse.body();
            Object traktWatchedResponse = TRAKT.sync().watchedMovies(null).execute();
            if (!traktWatchedResponse.isSuccessful() && traktWatchedResponse.code() == 401) {
                TraktTv.refreshAccessToken();
                traktWatchedResponse = TRAKT.sync().watchedMovies(null).execute();
            }
            if (!traktWatchedResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + traktWatchedResponse.message());
                return;
            }
            traktWatched = (List)traktWatchedResponse.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktCollection.size() + " movies in your Trakt.tv collection");
        LOGGER.info("You have " + traktWatched.size() + " movies watched");
        ArrayList<SyncMovie> movieToRemove = new ArrayList<SyncMovie>();
        for (BaseMovie traktMovie : traktCollection) {
            movieToRemove.add(this.toSyncMovie(traktMovie));
        }
        if (!movieToRemove.isEmpty()) {
            try {
                items = new SyncItems().movies(movieToRemove);
                response = TRAKT.sync().deleteItemsFromCollection(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.info("removed " + movieToRemove.size() + " movies from your trakt.tv collection");
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
                return;
            }
        }
        movieToRemove.clear();
        for (BaseMovie traktMovie : traktWatched) {
            movieToRemove.add(this.toSyncMovie(traktMovie));
        }
        if (!movieToRemove.isEmpty()) {
            try {
                items = new SyncItems().movies(movieToRemove);
                response = TRAKT.sync().deleteItemsFromWatchedHistory(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.info("removed " + movieToRemove.size() + " movies from your trakt.tv watched");
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void syncTraktMovieWatched(List<Movie> moviesInTmm) {
        void var6_15;
        List traktMovies;
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<Movie> tmmMovies = new ArrayList<Movie>(moviesInTmm);
        try {
            Response traktWatchedResponse = TRAKT.sync().watchedMovies(null).execute();
            if (!traktWatchedResponse.isSuccessful() && traktWatchedResponse.code() == 401) {
                TraktTv.refreshAccessToken();
                traktWatchedResponse = TRAKT.sync().watchedMovies(null).execute();
            }
            if (!traktWatchedResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + traktWatchedResponse.message());
                return;
            }
            traktMovies = (List)traktWatchedResponse.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktMovies.size() + " movies marked as 'watched' in your Trakt.tv collection");
        for (Object traktWatched : traktMovies) {
            for (Movie tmmMovie : tmmMovies) {
                Date lastWatchedAt;
                if (!this.matches(tmmMovie, ((BaseMovie)traktWatched).movie.ids)) continue;
                boolean dirty = this.updateIDs(tmmMovie, ((BaseMovie)traktWatched).movie.ids);
                if (!tmmMovie.isWatched()) {
                    LOGGER.info("Marking movie '" + tmmMovie.getTitle() + "' as watched");
                    tmmMovie.setWatched(true);
                    dirty = true;
                }
                if (((BaseMovie)traktWatched).last_watched_at != null && !(lastWatchedAt = DateTimeUtils.toDate((Instant)((BaseMovie)traktWatched).last_watched_at.toInstant())).equals(tmmMovie.getLastWatched())) {
                    LOGGER.trace("Marking movie '" + tmmMovie.getTitle() + "' as watched on " + lastWatchedAt + " (was " + tmmMovie.getLastWatched() + ")");
                    tmmMovie.setLastWatched(lastWatchedAt);
                }
                if (!dirty) continue;
                tmmMovie.writeNFO();
                tmmMovie.saveToDb();
            }
        }
        ArrayList<Movie> tmmWatchedMovies = new ArrayList<Movie>();
        for (Movie movie : tmmMovies) {
            if (!movie.isWatched()) continue;
            tmmWatchedMovies.add(movie);
        }
        LOGGER.info("You have now " + tmmWatchedMovies.size() + " movies marked as 'watched' in your TMM database");
        block7: for (int i = tmmWatchedMovies.size() - 1; i >= 0; --i) {
            for (Object traktWatched : traktMovies) {
                Movie tmmMovie = (Movie)tmmWatchedMovies.get(i);
                if (!this.matches(tmmMovie, ((BaseMovie)traktWatched).movie.ids)) continue;
                tmmWatchedMovies.remove(i);
                continue block7;
            }
        }
        if (tmmWatchedMovies.size() == 0) {
            LOGGER.info("no new watched movies for Trakt sync found.");
            return;
        }
        LOGGER.debug("prepare " + tmmWatchedMovies.size() + " movies for Trakt.tv sync");
        ArrayList<SyncMovie> movies = new ArrayList<SyncMovie>();
        boolean bl = false;
        for (Movie tmmMovie : tmmWatchedMovies) {
            if (tmmMovie.getIdAsInt(providerInfo.getId()) != 0 || !tmmMovie.getIdAsString("imdb").isEmpty() || tmmMovie.getIdAsInt("tmdb") != 0) {
                movies.add(this.toSyncMovie(tmmMovie, true));
                continue;
            }
            ++var6_15;
        }
        if (var6_15 > 0) {
            LOGGER.debug("skipping " + (int)var6_15 + " movies, because they have not been scraped yet!");
        }
        if (movies.size() == 0) {
            LOGGER.info("no new watched movies for Trakt sync found.");
            return;
        }
        try {
            LOGGER.info("Marking " + movies.size() + " movies as 'watched' to Trakt.tv collection");
            SyncItems items = new SyncItems().movies(movies);
            Response response = TRAKT.sync().addItemsToWatchedHistory(items).execute();
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + response.message());
                return;
            }
            LOGGER.info("Trakt mark-as-watched status:");
            this.printStatus((SyncResponse)response.body());
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
        }
    }

    public void syncTraktMovieWatched() {
        if (!this.isEnabled()) {
            return;
        }
        this.syncTraktMovieWatched(MovieList.getInstance().getMovies());
    }

    public void syncTraktTvShowCollection(List<TvShow> tvShowsInTmm) {
        List traktShows;
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<TvShow> tvShows = new ArrayList<TvShow>(tvShowsInTmm);
        try {
            Response response = TRAKT.sync().collectionShows(null).execute();
            if (!response.isSuccessful() && response.code() == 401) {
                TraktTv.refreshAccessToken();
                response = TRAKT.sync().collectionShows(null).execute();
            }
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + response.message());
                return;
            }
            traktShows = (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktShows.size() + " TvShows in your Trakt.tv collection");
        HashSet<TvShowEpisode> episodesInTrakt = new HashSet<TvShowEpisode>();
        for (BaseShow traktShow : traktShows) {
            for (TvShow tmmShow : tvShows) {
                Date collectedAt;
                if (!this.matches(tmmShow, traktShow.show.ids)) continue;
                boolean dirty = this.updateIDs(tmmShow, traktShow.show.ids);
                if (traktShow.last_collected_at != null && !(collectedAt = DateTimeUtils.toDate((Instant)traktShow.last_collected_at.toInstant())).equals(tmmShow.getDateAdded())) {
                    LOGGER.trace("Marking TvShow '" + tmmShow.getTitle() + "' as collected on " + collectedAt + " (was " + tmmShow.getDateAddedAsString() + ")");
                    tmmShow.setDateAdded(collectedAt);
                    dirty = true;
                }
                for (BaseSeason bs : traktShow.seasons) {
                    for (BaseEpisode be : bs.episodes) {
                        Date collectedAt2;
                        TvShowEpisode tmmEP = tmmShow.getEpisode(bs.number, be.number);
                        if (tmmEP == null) continue;
                        episodesInTrakt.add(tmmEP);
                        if (be.collected_at == null || (collectedAt2 = DateTimeUtils.toDate((Instant)be.collected_at.toInstant())).equals(tmmEP.getDateAdded())) continue;
                        tmmEP.setDateAdded(collectedAt2);
                        tmmEP.writeNFO();
                        tmmEP.saveToDb();
                    }
                }
                if (!dirty) continue;
                tmmShow.writeNFO();
                tmmShow.saveToDb();
            }
        }
        LOGGER.info("Adding " + tvShows.size() + " TvShows to Trakt.tv collection");
        for (TvShow tvShow : tvShows) {
            SyncShow show = this.toSyncShow(tvShow, false, episodesInTrakt);
            if (show == null) continue;
            try {
                SyncItems items = new SyncItems().shows(show);
                Response response = TRAKT.sync().addItemsToCollection(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.debug("Trakt add-to-library status: " + tvShow.getTitle());
                this.printStatus((SyncResponse)response.body());
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
                return;
            }
        }
    }

    public void syncTraktTvShowCollection() {
        if (!this.isEnabled()) {
            return;
        }
        this.syncTraktTvShowCollection(new ArrayList<TvShow>(TvShowList.getInstance().getTvShows()));
    }

    public void syncTraktTvShowWatched(List<TvShow> tvShowsInTmm) {
        List traktShows;
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<TvShow> tvShows = new ArrayList<TvShow>(tvShowsInTmm);
        try {
            Response response = TRAKT.sync().watchedShows(null).execute();
            if (!response.isSuccessful() && response.code() == 401) {
                TraktTv.refreshAccessToken();
                response = TRAKT.sync().watchedShows(null).execute();
            }
            if (!response.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + response.message());
                return;
            }
            traktShows = (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktShows.size() + " TvShows marked as watched on Trakt.tv");
        for (BaseShow traktShow : traktShows) {
            for (TvShow tmmShow : tvShows) {
                Date lastWatchedAt;
                if (!this.matches(tmmShow, traktShow.show.ids)) continue;
                boolean dirty = this.updateIDs(tmmShow, traktShow.show.ids);
                if (traktShow.last_watched_at != null && !(lastWatchedAt = DateTimeUtils.toDate((Instant)traktShow.last_watched_at.toInstant())).equals(tmmShow.getLastWatched())) {
                    LOGGER.trace("Marking TvShow '" + tmmShow.getTitle() + "' as watched on " + lastWatchedAt + " (was " + tmmShow.getLastWatched() + ")");
                    tmmShow.setLastWatched(lastWatchedAt);
                }
                for (BaseSeason bs : traktShow.seasons) {
                    for (BaseEpisode be : bs.episodes) {
                        Date lastWatchedAt2;
                        TvShowEpisode tmmEP = tmmShow.getEpisode(bs.number, be.number);
                        if (tmmEP == null) continue;
                        if (!tmmEP.isWatched()) {
                            tmmEP.setWatched(true);
                            tmmEP.writeNFO();
                            tmmEP.saveToDb();
                        }
                        if (be.last_watched_at == null || (lastWatchedAt2 = DateTimeUtils.toDate((Instant)be.last_watched_at.toInstant())).equals(tmmEP.getLastWatched())) continue;
                        tmmEP.setLastWatched(lastWatchedAt2);
                    }
                }
                if (!dirty) continue;
                tmmShow.writeNFO();
                tmmShow.saveToDb();
            }
        }
        LOGGER.info("Adding up to " + tvShows.size() + " TvShows as watched on Trakt.tv");
        for (TvShow show : tvShows) {
            SyncShow sync = this.toSyncShow(show, true, new HashSet<TvShowEpisode>());
            if (sync == null) continue;
            try {
                SyncItems items = new SyncItems().shows(sync);
                Response response = TRAKT.sync().addItemsToWatchedHistory(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.debug("Trakt add-to-library status: " + show.getTitle());
                this.printStatus((SyncResponse)response.body());
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
                return;
            }
        }
    }

    public void syncTraktTvShowWatched() {
        if (!this.isEnabled()) {
            return;
        }
        this.syncTraktTvShowWatched(new ArrayList<TvShow>(TvShowList.getInstance().getTvShows()));
    }

    public void clearTraktTvShows() {
        Response response;
        SyncItems items;
        List traktWatched;
        List traktCollection;
        try {
            Response traktCollectionResponse = TRAKT.sync().collectionShows(null).execute();
            if (!traktCollectionResponse.isSuccessful() && traktCollectionResponse.code() == 401) {
                TraktTv.refreshAccessToken();
                traktCollectionResponse = TRAKT.sync().collectionShows(null).execute();
            }
            if (!traktCollectionResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + traktCollectionResponse.message());
                return;
            }
            traktCollection = (List)traktCollectionResponse.body();
            Object traktWatchedResponse = TRAKT.sync().watchedShows(null).execute();
            if (!traktWatchedResponse.isSuccessful() && traktWatchedResponse.code() == 401) {
                TraktTv.refreshAccessToken();
                traktWatchedResponse = TRAKT.sync().watchedShows(null).execute();
            }
            if (!traktWatchedResponse.isSuccessful()) {
                LOGGER.error("failed syncing trakt: " + traktWatchedResponse.message());
                return;
            }
            traktWatched = (List)traktWatchedResponse.body();
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: " + e.getMessage());
            return;
        }
        LOGGER.info("You have " + traktCollection.size() + " shows in your Trakt.tv collection");
        LOGGER.info("You have " + traktWatched.size() + " shows watched");
        ArrayList<SyncShow> showToRemove = new ArrayList<SyncShow>();
        for (BaseShow traktShow : traktCollection) {
            showToRemove.add(this.toSyncShow(traktShow));
        }
        if (!showToRemove.isEmpty()) {
            try {
                items = new SyncItems().shows(showToRemove);
                response = TRAKT.sync().deleteItemsFromCollection(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.debug("removed " + showToRemove.size() + " shows from your trakt.tv collection");
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
                return;
            }
        }
        showToRemove.clear();
        for (BaseShow traktShow : traktWatched) {
            showToRemove.add(this.toSyncShow(traktShow));
        }
        if (!showToRemove.isEmpty()) {
            try {
                items = new SyncItems().shows(showToRemove);
                response = TRAKT.sync().deleteItemsFromWatchedHistory(items).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("failed syncing trakt: " + response.message());
                    return;
                }
                LOGGER.debug("removed " + showToRemove.size() + " shows from your trakt.tv watched");
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: " + e.getMessage());
            }
        }
    }

    private boolean updateIDs(TvShow tmmShow, ShowIds ids) {
        boolean dirty = false;
        if (tmmShow.getIdAsString("imdb").isEmpty() && !StringUtils.isEmpty((CharSequence)ids.imdb)) {
            tmmShow.setId("imdb", ids.imdb);
            dirty = true;
        }
        if (tmmShow.getIdAsInt("tmdb") == 0 && ids.tmdb != null && ids.tmdb != 0) {
            tmmShow.setId("tmdb", ids.tmdb);
            dirty = true;
        }
        if (tmmShow.getIdAsInt(providerInfo.getId()) == 0 && ids.trakt != null && ids.trakt != 0) {
            tmmShow.setId(providerInfo.getId(), ids.trakt);
            dirty = true;
        }
        if (tmmShow.getIdAsInt("tvdb") == 0 && ids.tvdb != null && ids.tvdb != 0) {
            tmmShow.setId("tvdb", ids.tvdb);
            dirty = true;
        }
        return dirty;
    }

    private boolean updateIDs(Movie tmmMovie, MovieIds ids) {
        boolean dirty = false;
        if (tmmMovie.getIdAsString("imdb").isEmpty() && !StringUtils.isEmpty((CharSequence)ids.imdb)) {
            tmmMovie.setId("imdb", ids.imdb);
            dirty = true;
        }
        if (tmmMovie.getIdAsInt("tmdb") == 0 && ids.tmdb != null && ids.tmdb != 0) {
            tmmMovie.setId("tmdb", ids.tmdb);
            dirty = true;
        }
        if (tmmMovie.getIdAsInt(providerInfo.getId()) == 0 && ids.trakt != null && ids.trakt != 0) {
            tmmMovie.setId(providerInfo.getId(), ids.trakt);
            dirty = true;
        }
        return dirty;
    }

    private boolean matches(TvShow tmmShow, ShowIds ids) {
        if (ids.trakt != null && ids.trakt != 0 && ids.trakt.intValue() == tmmShow.getIdAsInt(providerInfo.getId())) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)ids.imdb) && ids.imdb.equals(tmmShow.getIdAsString("imdb"))) {
            return true;
        }
        if (ids.tmdb != null && ids.tmdb != 0 && ids.tmdb.intValue() == tmmShow.getIdAsInt("tmdb")) {
            return true;
        }
        return ids.tvdb != null && ids.tvdb != 0 && ids.tvdb.intValue() == tmmShow.getIdAsInt("tvdb");
    }

    private boolean matches(Movie tmmMovie, MovieIds ids) {
        if (ids.trakt != null && ids.trakt != 0 && ids.trakt.intValue() == tmmMovie.getIdAsInt(providerInfo.getId())) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)ids.imdb) && ids.imdb.equals(tmmMovie.getIdAsString("imdb"))) {
            return true;
        }
        return ids.tmdb != null && ids.tmdb != 0 && ids.tmdb.intValue() == tmmMovie.getIdAsInt("tmdb");
    }

    private SyncMovie toSyncMovie(Movie tmmMovie, boolean watched) {
        boolean hasId = false;
        SyncMovie movie = null;
        MovieIds ids = new MovieIds();
        if (!tmmMovie.getIdAsString("imdb").isEmpty()) {
            ids.imdb = tmmMovie.getIdAsString("imdb");
            hasId = true;
        }
        if (tmmMovie.getIdAsInt("tmdb") != 0) {
            ids.tmdb = tmmMovie.getIdAsInt("tmdb");
            hasId = true;
        }
        if (tmmMovie.getIdAsInt(providerInfo.getId()) != 0) {
            ids.trakt = tmmMovie.getIdAsInt(providerInfo.getId());
            hasId = true;
        }
        if (!hasId) {
            return movie;
        }
        if (watched) {
            if (tmmMovie.isWatched() && tmmMovie.getLastWatched() == null) {
                OffsetDateTime watchedAt = OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)new Date()), (ZoneId)ZoneId.systemDefault());
                movie = new SyncMovie().id(ids).watchedAt(watchedAt);
            }
        } else {
            OffsetDateTime collectedAt = OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)tmmMovie.getDateAdded()), (ZoneId)ZoneId.systemDefault());
            movie = new SyncMovie().id(ids).collectedAt(collectedAt);
        }
        return movie;
    }

    private SyncMovie toSyncMovie(BaseMovie baseMovie) {
        return new SyncMovie().id(baseMovie.movie.ids).collectedAt(baseMovie.collected_at).watchedAt(baseMovie.last_watched_at);
    }

    private SyncShow toSyncShow(TvShow tmmShow, boolean watched, Set<TvShowEpisode> episodesInTrakt) {
        boolean hasId = false;
        SyncShow show = null;
        ShowIds ids = new ShowIds();
        if (!tmmShow.getIdAsString("imdb").isEmpty()) {
            ids.imdb = tmmShow.getIdAsString("imdb");
            hasId = true;
        }
        if (tmmShow.getIdAsInt("tmdb") != 0) {
            ids.tmdb = tmmShow.getIdAsInt("tmdb");
            hasId = true;
        }
        if (tmmShow.getIdAsInt("tvdb") != 0) {
            ids.tvdb = tmmShow.getIdAsInt("tvdb");
            hasId = true;
        }
        if (tmmShow.getIdAsInt(providerInfo.getId()) != 0) {
            ids.trakt = tmmShow.getIdAsInt(providerInfo.getId());
            hasId = true;
        }
        if (!hasId) {
            return show;
        }
        ArrayList<SyncSeason> ss = new ArrayList<SyncSeason>();
        boolean foundS = false;
        for (TvShowSeason tmmSeason : tmmShow.getSeasons()) {
            boolean foundEP = false;
            ArrayList<SyncEpisode> se = new ArrayList<SyncEpisode>();
            for (TvShowEpisode tmmEp : tmmSeason.getEpisodes()) {
                if (watched) {
                    if (!tmmEp.isWatched() || tmmEp.getLastWatched() != null) continue;
                    OffsetDateTime watchedAt = OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)new Date()), (ZoneId)ZoneId.systemDefault());
                    se.add(new SyncEpisode().number(tmmEp.getEpisode()).watchedAt(watchedAt));
                    foundEP = true;
                    continue;
                }
                if (episodesInTrakt.contains(tmmEp)) continue;
                OffsetDateTime collectedAt = OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)tmmEp.getDateAdded()), (ZoneId)ZoneId.systemDefault());
                se.add(new SyncEpisode().number(tmmEp.getEpisode()).collectedAt(collectedAt));
                foundEP = true;
            }
            if (!foundEP) continue;
            foundS = true;
            ss.add(new SyncSeason().number(tmmSeason.getSeason()).episodes(se));
        }
        if (foundS) {
            OffsetDateTime collectedAt = OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)tmmShow.getDateAdded()), (ZoneId)ZoneId.systemDefault());
            show = new SyncShow().id(ids).collectedAt(collectedAt).seasons(ss);
        }
        return show;
    }

    private SyncShow toSyncShow(BaseShow baseShow) {
        ArrayList<SyncSeason> ss = new ArrayList<SyncSeason>();
        for (BaseSeason baseSeason : baseShow.seasons) {
            ArrayList<SyncEpisode> se = new ArrayList<SyncEpisode>();
            for (BaseEpisode baseEp : baseSeason.episodes) {
                se.add(new SyncEpisode().number(baseEp.number.intValue()).collectedAt(baseEp.collected_at).watchedAt(baseEp.collected_at));
            }
            ss.add(new SyncSeason().number(baseSeason.number.intValue()).episodes(se));
        }
        return new SyncShow().id(baseShow.show.ids).collectedAt(baseShow.last_collected_at).watchedAt(baseShow.last_watched_at).seasons(ss);
    }

    private void printStatus(SyncResponse resp) {
        if (resp != null) {
            String info = this.getStatusString(resp.added);
            if (!info.isEmpty()) {
                LOGGER.debug("Added       : " + info);
            }
            if (!(info = this.getStatusString(resp.existing)).isEmpty()) {
                LOGGER.debug("Existing    : " + info);
            }
            if (!(info = this.getStatusString(resp.deleted)).isEmpty()) {
                LOGGER.debug("Deleted     : " + info);
            }
            if (!(info = this.getStatusString(resp.not_found)).isEmpty()) {
                LOGGER.debug("Errors      : " + info);
            }
        }
    }

    private String getStatusString(SyncStats ss) {
        if (ss == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(50);
        if (ss.movies != null && ss.movies > 0) {
            sb.append(ss.movies + " Movies ");
        }
        if (ss.shows != null && ss.shows > 0) {
            sb.append(ss.shows + " Shows ");
        }
        if (ss.seasons != null && ss.seasons > 0) {
            sb.append(ss.seasons + " Seasons ");
        }
        if (ss.episodes != null && ss.episodes > 0) {
            sb.append(ss.episodes + " Episodes");
        }
        return sb.toString();
    }

    private String getStatusString(SyncErrors ss) {
        if (ss == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(50);
        if (ss.movies != null && ss.movies.size() > 0) {
            sb.append(ss.movies.size() + " Movies ");
        }
        if (ss.shows != null && ss.shows.size() > 0) {
            sb.append(ss.shows.size() + " Shows ");
        }
        if (ss.seasons != null && ss.seasons.size() > 0) {
            sb.append(ss.seasons.size() + " Seasons ");
        }
        if (ss.episodes != null && ss.episodes.size() > 0) {
            sb.append(ss.episodes.size() + " Episodes");
        }
        return sb.toString();
    }

    static {
        providerInfo = new MediaProviderInfo("trakt", "Trakt.tv", "Scraper for Trakt.tv; yes, we can scrape here too :)");
    }
}

