/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import com.sun.jna.Platform;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.AbstractFileVisitor;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.connector.TvShowNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.thirdparty.VSMeta;
import org.tinymediamanager.ui.UTF8Control;

public class TvShowUpdateDatasourceTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowUpdateDatasourceTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final String VIDEO_TS = "VIDEO_TS";
    private static final String BDMV = "BDMV";
    private static final String HVDVD_TS = "HVDVD_TS";
    private static final List<String> skipFolders = Arrays.asList(".", "..", "CERTIFICATE", "BACKUP", "PLAYLIST", "CLPINF", "SSIF", "AUXDATA", "AUDIO_TS", "$RECYCLE.BIN", "RECYCLER", "SYSTEM VOLUME INFORMATION", "@EADIR", "ADV_OBJ", "EXTRAS", "EXTRA", "EXTRATHUMBS");
    private static final String skipRegex = "^[.][\\w@]+.*";
    private static final Pattern seasonNumber = Pattern.compile("(?i)season([0-9]{1,4}).*");
    private static long preDir = 0L;
    private static long postDir = 0L;
    private static long visFile = 0L;
    private List<String> dataSources;
    private List<Path> tvShowFolders = new ArrayList<Path>();
    private TvShowList tvShowList;
    private HashSet<Path> filesFound = new HashSet();

    public TvShowUpdateDatasourceTask() {
        super(BUNDLE.getString("update.datasource"));
        this.tvShowList = TvShowList.getInstance();
        this.dataSources = new ArrayList<String>(TvShowModuleManager.SETTINGS.getTvShowDataSource());
    }

    public TvShowUpdateDatasourceTask(String datasource) {
        super(BUNDLE.getString("update.datasource") + " (" + datasource + ")");
        this.tvShowList = TvShowList.getInstance();
        this.dataSources = new ArrayList<String>(1);
        this.dataSources.add(datasource);
    }

    public TvShowUpdateDatasourceTask(List<Path> tvShowFolders) {
        super(BUNDLE.getString("update.datasource"));
        this.tvShowList = TvShowList.getInstance();
        this.dataSources = new ArrayList<String>(0);
        this.tvShowFolders.addAll(tvShowFolders);
    }

    @Override
    public void doInBackground() {
        Utils.removeEmptyStringsFromList(this.dataSources);
        if (this.dataSources.isEmpty() && this.tvShowFolders.isEmpty()) {
            LOGGER.info("no datasource to update");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "update.datasource.nonespecified"));
            return;
        }
        TvShowUpdateDatasourceTask.resetCounters();
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.start();
            ArrayList<Path> existing = new ArrayList<Path>();
            for (TvShow show : this.tvShowList.getTvShows()) {
                existing.add(show.getPathNIO());
            }
            if (this.tvShowFolders.isEmpty()) {
                for (String ds : this.dataSources) {
                    LOGGER.info("Start UDS on datasource: {}", (Object)ds);
                    this.initThreadPool(3, "update");
                    this.setTaskName(BUNDLE.getString("update.datasource") + " '" + ds + "'");
                    this.publishState();
                    Path dsAsPath = Paths.get(ds, new String[0]);
                    if (!Files.exists(dsAsPath, new LinkOption[0])) {
                        LOGGER.warn("Datasource not available/empty {}", (Object)ds);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    this.publishState();
                    ArrayList<Path> newTvShowDirs = new ArrayList<Path>();
                    ArrayList<Path> existingTvShowDirs = new ArrayList<Path>();
                    List<Path> rootList = TvShowUpdateDatasourceTask.listFilesAndDirs(dsAsPath);
                    if (rootList.isEmpty() && !Platform.isWindows()) {
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    for (Path path : rootList) {
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            if (path.getFileName().toString().length() == 1) {
                                List<Path> subList = TvShowUpdateDatasourceTask.listFilesAndDirs(path);
                                for (Path sub : subList) {
                                    if (!Files.isDirectory(sub, new LinkOption[0])) continue;
                                    if (existing.contains(sub)) {
                                        existingTvShowDirs.add(sub);
                                        continue;
                                    }
                                    newTvShowDirs.add(sub);
                                }
                                continue;
                            }
                            if (existing.contains(path)) {
                                existingTvShowDirs.add(path);
                                continue;
                            }
                            newTvShowDirs.add(path);
                            continue;
                        }
                        String ext = FilenameUtils.getExtension((String)path.getFileName().toString()).toLowerCase(Locale.ROOT);
                        if (!Globals.settings.getVideoFileType().contains("." + ext)) continue;
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.episodeinroot", new String[]{path.getFileName().toString()}));
                    }
                    for (Path subdir : newTvShowDirs) {
                        this.submitTask(new FindTvShowTask(subdir, dsAsPath.toAbsolutePath()));
                    }
                    for (Path subdir : existingTvShowDirs) {
                        this.submitTask(new FindTvShowTask(subdir, dsAsPath.toAbsolutePath()));
                    }
                    this.waitForCompletionOrCancel();
                    if (!this.cancel) {
                        this.cleanupDatasource(ds);
                        this.waitForCompletionOrCancel();
                        if (!this.cancel) continue;
                    }
                    break;
                }
            } else {
                this.initThreadPool(3, "update");
                for (Path path : this.tvShowFolders) {
                    if (!Files.exists(path, new LinkOption[0])) {
                        LOGGER.warn("Datasource not available/empty - {}", (Object)path.toAbsolutePath());
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{path.toAbsolutePath().toString()}));
                        continue;
                    }
                    this.submitTask(new FindTvShowTask(path, path.getParent().toAbsolutePath()));
                }
                this.waitForCompletionOrCancel();
                if (!this.cancel) {
                    this.cleanupShows();
                    this.waitForCompletionOrCancel();
                }
            }
            LOGGER.info("getting Mediainfo...");
            this.initThreadPool(1, "mediainfo");
            this.setTaskName(BUNDLE.getString("update.mediainfo"));
            this.setTaskDescription(null);
            this.setProgressDone(0);
            if (!this.cancel) {
                TvShow tvShow;
                if (this.tvShowFolders.isEmpty()) {
                    for (int i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
                        tvShow = this.tvShowList.getTvShows().get(i);
                        if (!this.dataSources.contains(tvShow.getDataSource())) continue;
                        this.gatherMediaInformationForUngatheredMediaFiles(tvShow);
                    }
                } else {
                    for (int i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
                        tvShow = this.tvShowList.getTvShows().get(i);
                        if (!this.tvShowFolders.contains(tvShow.getPathNIO())) continue;
                        this.gatherMediaInformationForUngatheredMediaFiles(tvShow);
                    }
                }
                this.waitForCompletionOrCancel();
            }
            stopWatch.stop();
            LOGGER.info("Done updating datasource :) - took {}", (Object)stopWatch);
            LOGGER.debug("FilesFound: {}", (Object)this.filesFound.size());
            LOGGER.debug("tvShowsFound: {}", (Object)this.tvShowList.getTvShowCount());
            LOGGER.debug("episodesFound: {}", (Object)this.tvShowList.getEpisodeCount());
            LOGGER.debug("PreDir: {}", (Object)preDir);
            LOGGER.debug("PostDir: {}", (Object)postDir);
            LOGGER.debug("VisFile: {}", (Object)visFile);
            TvShowUpdateDatasourceTask.resetCounters();
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "message.update.threadcrashed"));
        }
    }

    private void cleanupShows() {
        this.setTaskName(BUNDLE.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned movies/files...");
        for (int i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
            TvShow tvShow = this.tvShowList.getTvShows().get(i);
            if (!this.tvShowFolders.contains(tvShow.getPathNIO())) continue;
            if (!Files.exists(tvShow.getPathNIO(), new LinkOption[0])) {
                this.tvShowList.removeTvShow(tvShow);
                continue;
            }
            this.cleanup(tvShow);
        }
    }

    private void cleanupDatasource(String datasource) {
        this.setTaskName(BUNDLE.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned tv shows/files...");
        for (int i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
            TvShow tvShow = this.tvShowList.getTvShows().get(i);
            if (!Paths.get(datasource, new String[0]).toAbsolutePath().equals(Paths.get(tvShow.getDataSource(), new String[0]).toAbsolutePath())) continue;
            if (!Files.exists(tvShow.getPathNIO(), new LinkOption[0])) {
                this.tvShowList.removeTvShow(tvShow);
                continue;
            }
            this.cleanup(tvShow);
        }
    }

    private void cleanup(TvShow tvShow) {
        boolean dirty = false;
        if (!tvShow.isNewlyAdded() || tvShow.hasNewlyAddedEpisodes()) {
            ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(tvShow.getMediaFiles());
            for (MediaFile mf : mediaFiles) {
                if (this.filesFound.contains(mf.getFileAsPath())) continue;
                if (!mf.exists()) {
                    LOGGER.debug("removing orphaned file: " + mf.getFileAsPath());
                    tvShow.removeFromMediaFiles(mf);
                    dirty = true;
                    continue;
                }
                LOGGER.warn("file " + mf.getFileAsPath() + " not in hashset, but on hdd!");
            }
            ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(tvShow.getEpisodes());
            for (TvShowEpisode episode : episodes) {
                mediaFiles = new ArrayList<MediaFile>(episode.getMediaFiles());
                for (MediaFile mf : mediaFiles) {
                    if (this.filesFound.contains(mf.getFileAsPath())) continue;
                    if (!mf.exists()) {
                        LOGGER.debug("removing orphaned file: " + mf.getFileAsPath());
                        episode.removeFromMediaFiles(mf);
                        dirty = true;
                        continue;
                    }
                    LOGGER.warn("file " + mf.getFileAsPath() + " not in hashset, but on hdd!");
                }
                List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
                if (!mfs.isEmpty()) continue;
                tvShow.removeEpisode(episode);
                dirty = true;
            }
        }
        if (dirty) {
            tvShow.saveToDb();
        }
    }

    private void gatherMediaInformationForUngatheredMediaFiles(TvShow tvShow) {
        for (MediaFile mf : tvShow.getMediaFiles()) {
            if (!StringUtils.isBlank((CharSequence)mf.getContainerFormat())) continue;
            this.submitTask(new MediaFileInformationFetcherTask(mf, (MediaEntity)tvShow, false));
        }
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
            for (MediaFile mf : episode.getMediaFiles()) {
                if (!StringUtils.isBlank((CharSequence)mf.getContainerFormat())) continue;
                this.submitTask(new MediaFileInformationFetcherTask(mf, (MediaEntity)episode, false));
            }
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private static List<Path> listFilesAndDirs(Path directory) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                String fn = path.getFileName().toString().toUpperCase(Locale.ROOT);
                if (!(skipFolders.contains(fn) || fn.matches(skipRegex) || TvShowModuleManager.SETTINGS.getSkipFolder().contains(path.toFile().getAbsolutePath()))) {
                    fileNames.add(path.toAbsolutePath());
                    continue;
                }
                LOGGER.debug("Skipping: {}", (Object)path);
            }
        }
        catch (IOException e) {
            LOGGER.error("list files failed: {}", (Object)e.getMessage());
            LOGGER.trace("visit file failed", (Throwable)e);
        }
        return fileNames;
    }

    private static void resetCounters() {
        visFile = 0L;
        preDir = 0L;
        postDir = 0L;
    }

    private static synchronized void incVisFile() {
        ++visFile;
    }

    private static synchronized void incPreDir() {
        ++preDir;
    }

    private static synchronized void incPostDir() {
        ++postDir;
    }

    private static class AllFilesRecursive
    extends AbstractFileVisitor {
        private HashSet<Path> fFound = new HashSet();

        private AllFilesRecursive() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            TvShowUpdateDatasourceTask.incVisFile();
            if (Utils.isRegularFile(attr) && !file.getFileName().toString().matches(TvShowUpdateDatasourceTask.skipRegex)) {
                this.fFound.add(file.toAbsolutePath());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            TvShowUpdateDatasourceTask.incPreDir();
            if (dir.getFileName() != null && (Files.exists(dir.resolve(".tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve("tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve(".nomedia"), new LinkOption[0]) || skipFolders.contains(dir.getFileName().toString().toUpperCase(Locale.ROOT)) || dir.getFileName().toString().matches(TvShowUpdateDatasourceTask.skipRegex)) || TvShowModuleManager.SETTINGS.getSkipFolder().contains(dir.toFile().getAbsolutePath())) {
                LOGGER.debug("Skipping dir: {}", (Object)dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            TvShowUpdateDatasourceTask.incPostDir();
            return FileVisitResult.CONTINUE;
        }
    }

    private class FindTvShowTask
    implements Callable<Object> {
        private Path showDir;
        private Path datasource;
        private long uniqueId;

        public FindTvShowTask(Path showDir, Path datasource) {
            this.showDir = showDir;
            this.datasource = datasource;
            this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
        }

        @Override
        public String call() throws Exception {
            String name = Thread.currentThread().getName();
            if (!name.contains("-G")) {
                name = name + "-G0";
            }
            name = name.replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName(name);
            if (this.showDir.getFileName().toString().matches(TvShowUpdateDatasourceTask.skipRegex)) {
                LOGGER.debug("Skipping dir: {}", (Object)this.showDir);
                return "";
            }
            Set<Path> allFiles = this.getAllFilesRecursive(this.showDir, Integer.MAX_VALUE);
            if (allFiles == null || allFiles.isEmpty()) {
                LOGGER.info("skip empty directory: {}", (Object)this.showDir);
                return "";
            }
            LOGGER.info("start parsing {}", (Object)this.showDir);
            TvShowUpdateDatasourceTask.this.filesFound.add(this.showDir.toAbsolutePath());
            TvShowUpdateDatasourceTask.this.filesFound.addAll(allFiles);
            ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
            for (Path file : allFiles) {
                if (file.getFileName().toString().matches(TvShowUpdateDatasourceTask.skipRegex)) continue;
                MediaFile mf = new MediaFile(file);
                if (mf.getType() == MediaFileType.POSTER && !mf.getFileAsPath().getParent().equals(this.showDir)) {
                    if (mf.getFileAsPath().getParent().getParent().equals(this.showDir)) {
                        mf.setType(MediaFileType.SEASON_POSTER);
                    } else {
                        mf.setType(MediaFileType.GRAPHIC);
                    }
                }
                if (mf.getType() == MediaFileType.UNKNOWN) continue;
                mfs.add(mf);
            }
            allFiles.clear();
            if (this.getMediaFiles(mfs, MediaFileType.VIDEO).isEmpty()) {
                LOGGER.info("no video file found in directory {}", (Object)this.showDir);
                return "";
            }
            TvShow tvShow = TvShowUpdateDatasourceTask.this.tvShowList.getTvShowByPath(this.showDir);
            MediaFile showNFO = new MediaFile(this.showDir.resolve("tvshow.nfo"), MediaFileType.NFO);
            if (tvShow == null) {
                if (Files.exists(showNFO.getFileAsPath(), new LinkOption[0])) {
                    try {
                        TvShowNfoParser parser = TvShowNfoParser.parseNfo(showNFO.getFileAsPath());
                        tvShow = parser.toTvShow();
                    }
                    catch (Exception e) {
                        LOGGER.warn("problem parsing NFO: {}", (Object)e.getMessage());
                    }
                }
                if (tvShow == null) {
                    tvShow = new TvShow();
                }
                if (StringUtils.isBlank((CharSequence)tvShow.getTitle()) || tvShow.getYear() <= 0) {
                    String[] ty = ParserUtils.detectCleanMovienameAndYear(this.showDir.getFileName().toString());
                    if (StringUtils.isBlank((CharSequence)tvShow.getTitle()) && StringUtils.isNotBlank((CharSequence)ty[0])) {
                        tvShow.setTitle(ty[0]);
                    }
                    if (tvShow.getYear() <= 0 && !ty[1].isEmpty()) {
                        try {
                            tvShow.setYear(Integer.parseInt(ty[1]));
                        }
                        catch (Exception e) {
                            LOGGER.trace("could not parse int: {}", (Object)e.getMessage());
                        }
                    }
                }
                tvShow.setPath(this.showDir.toAbsolutePath().toString());
                tvShow.setDataSource(this.datasource.toString());
                tvShow.setNewlyAdded(true);
                TvShowUpdateDatasourceTask.this.tvShowList.addTvShow(tvShow);
            }
            HashSet<Path> discFolders = new HashSet<Path>();
            for (MediaFile mf : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
                List<TvShowEpisode> episodes;
                ArrayList<MediaFile> epFiles = new ArrayList<MediaFile>();
                if (mf.isDiscFile()) {
                    Path discRoot = mf.getFileAsPath().getParent().toAbsolutePath();
                    Object folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                    while (((String)folder).contains(TvShowUpdateDatasourceTask.BDMV) || ((String)folder).contains(TvShowUpdateDatasourceTask.VIDEO_TS) || ((String)folder).contains(TvShowUpdateDatasourceTask.HVDVD_TS)) {
                        discRoot = discRoot.getParent();
                        folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                    }
                    if (discFolders.contains(discRoot)) continue;
                    discFolders.add(discRoot);
                    for (MediaFile em : mfs) {
                        if (!em.getFileAsPath().startsWith(discRoot) || em.getType() == MediaFileType.UNKNOWN) continue;
                        epFiles.add(em);
                    }
                } else {
                    String basename = FilenameUtils.getBaseName((String)mf.getFilenameWithoutStacking());
                    LOGGER.trace("UDS: basename - {}", (Object)basename);
                    for (MediaFile em : mfs) {
                        String emBasename = FilenameUtils.getBaseName((String)em.getFilename());
                        String epNameRegexp = Pattern.quote(basename) + "[\\s.,_-].*";
                        if (!emBasename.equals(basename) && !emBasename.matches(epNameRegexp)) continue;
                        if (em.getType() == MediaFileType.GRAPHIC) {
                            em.setType(MediaFileType.THUMB);
                        }
                        epFiles.add(em);
                        LOGGER.trace("UDS: found matching MF - {}", (Object)em);
                    }
                }
                if ((episodes = TvShowList.getTvEpisodesByFile(tvShow, mf.getFile())).isEmpty()) {
                    Object ep;
                    MediaFile epNfo;
                    MediaFile meta = this.getMediaFile(epFiles, MediaFileType.VSMETA);
                    TvShowEpisode vsMetaEP = null;
                    if (meta != null) {
                        VSMeta vsmeta = new VSMeta();
                        vsmeta.parseFile(meta.getFileAsPath());
                        vsMetaEP = vsmeta.getTvShowEpisode();
                    }
                    if ((epNfo = this.getMediaFile(epFiles, MediaFileType.NFO)) != null) {
                        LOGGER.info("found episode NFO - try to parse '{}'", (Object)this.showDir.relativize(epNfo.getFileAsPath()));
                        ArrayList<TvShowEpisode> episodesInNfo = new ArrayList<TvShowEpisode>();
                        TvShowEpisodeNfoParser parser = TvShowEpisodeNfoParser.parseNfo(epNfo.getFileAsPath());
                        if (parser.isValidNfo()) {
                            episodesInNfo.addAll(parser.toTvShowEpisodes());
                        }
                        if (!episodesInNfo.isEmpty()) {
                            for (TvShowEpisode episode : episodesInNfo) {
                                episode.setPath(mf.getPath());
                                episode.setTvShow(tvShow);
                                episode.setDateAddedFromMediaFile(mf);
                                if (episode.getMediaSource() == MediaSource.UNKNOWN) {
                                    episode.setMediaSource(MediaSource.parseMediaSource(mf.getFile().toString()));
                                }
                                episode.setNewlyAdded(true);
                                episode.addToMediaFiles(epFiles);
                                if (mf.isDiscFile()) {
                                    episode.setDisc(true);
                                    Path discRoot = mf.getFileAsPath().getParent().toAbsolutePath();
                                    String folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                                    while (folder.contains(TvShowUpdateDatasourceTask.BDMV) || folder.contains(TvShowUpdateDatasourceTask.VIDEO_TS) || folder.contains(TvShowUpdateDatasourceTask.HVDVD_TS)) {
                                        discRoot = discRoot.getParent();
                                        folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                                    }
                                    episode.setPath(discRoot.toAbsolutePath().toString());
                                }
                                if (episodesInNfo.size() > 1) {
                                    episode.setMultiEpisode(true);
                                } else {
                                    episode.setMultiEpisode(false);
                                }
                                episode.merge(vsMetaEP);
                                episode.saveToDb();
                                tvShow.addEpisode(episode);
                            }
                            continue;
                        }
                    }
                    String relativePath = this.showDir.relativize(mf.getFileAsPath()).toString();
                    TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(relativePath, tvShow.getTitle());
                    if (result.episodes.size() == 1 && result.season > -1 && result.stackingMarkerFound && (ep = tvShow.getEpisode(result.season, result.episodes.get(0))) != null) {
                        ((MediaEntity)ep).setNewlyAdded(true);
                        ((MediaEntity)ep).addToMediaFiles(mf);
                        continue;
                    }
                    if (!result.episodes.isEmpty()) {
                        ep = result.episodes.iterator();
                        while (ep.hasNext()) {
                            int ep2 = ep.next();
                            TvShowEpisode episode = new TvShowEpisode();
                            episode.setDvdOrder(TvShowModuleManager.SETTINGS.isDvdOrder());
                            episode.setEpisode(ep2);
                            episode.setSeason(result.season);
                            episode.setFirstAired(result.date);
                            if (result.name.isEmpty()) {
                                result.name = FilenameUtils.getBaseName((String)mf.getFilename());
                            }
                            episode.setTitle(TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(result.name, tvShow.getTitle()));
                            episode.setPath(mf.getPath());
                            episode.setTvShow(tvShow);
                            episode.addToMediaFiles(epFiles);
                            episode.setDateAddedFromMediaFile(mf);
                            if (episode.getMediaSource() == MediaSource.UNKNOWN) {
                                episode.setMediaSource(MediaSource.parseMediaSource(mf.getFile().toString()));
                            }
                            episode.setNewlyAdded(true);
                            if (mf.isDiscFile()) {
                                episode.setDisc(true);
                                Path discRoot = mf.getFileAsPath().getParent().toAbsolutePath();
                                String folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                                while (folder.contains(TvShowUpdateDatasourceTask.BDMV) || folder.contains(TvShowUpdateDatasourceTask.VIDEO_TS) || folder.contains(TvShowUpdateDatasourceTask.HVDVD_TS)) {
                                    discRoot = discRoot.getParent();
                                    folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                                }
                                episode.setPath(discRoot.toAbsolutePath().toString());
                            }
                            if (result.episodes.size() > 1) {
                                episode.setMultiEpisode(true);
                            } else {
                                episode.setMultiEpisode(false);
                            }
                            episode.merge(vsMetaEP);
                            episode.saveToDb();
                            tvShow.addEpisode(episode);
                        }
                        continue;
                    }
                    TvShowEpisode episode = new TvShowEpisode();
                    episode.setDvdOrder(TvShowModuleManager.SETTINGS.isDvdOrder());
                    episode.setEpisode(-1);
                    episode.setSeason(-1);
                    episode.setPath(mf.getPath());
                    if (mf.isDiscFile()) {
                        episode.setDisc(true);
                        Path discRoot = mf.getFileAsPath().getParent().toAbsolutePath();
                        String folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                        while (folder.contains(TvShowUpdateDatasourceTask.BDMV) || folder.contains(TvShowUpdateDatasourceTask.VIDEO_TS) || folder.contains(TvShowUpdateDatasourceTask.HVDVD_TS)) {
                            discRoot = discRoot.getParent();
                            folder = this.showDir.relativize(discRoot).toString().toUpperCase(Locale.ROOT);
                        }
                        episode.setPath(discRoot.toAbsolutePath().toString());
                    }
                    episode.setTitle(TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(FilenameUtils.getBaseName((String)mf.getFilename()), tvShow.getTitle()));
                    episode.setTvShow(tvShow);
                    episode.setFirstAired(result.date);
                    episode.addToMediaFiles(epFiles);
                    episode.setDateAddedFromMediaFile(mf);
                    if (episode.getMediaSource() == MediaSource.UNKNOWN) {
                        episode.setMediaSource(MediaSource.parseMediaSource(mf.getFile().toString()));
                    }
                    episode.setNewlyAdded(true);
                    episode.merge(vsMetaEP);
                    episode.saveToDb();
                    tvShow.addEpisode(episode);
                    continue;
                }
                for (TvShowEpisode episode : episodes) {
                    episode.addToMediaFiles(epFiles);
                    episode.setDisc(mf.isDiscFile());
                    if (episodes.size() > 1) {
                        episode.setMultiEpisode(true);
                    } else {
                        episode.setMultiEpisode(false);
                    }
                    episode.saveToDb();
                }
            }
            mfs.removeAll(tvShow.getEpisodesMediaFiles());
            for (MediaFile mf : mfs) {
                if (mf.getType() == MediaFileType.SEASON_POSTER || mf.getType() == MediaFileType.SEASON_BANNER || mf.getType() == MediaFileType.SEASON_THUMB) continue;
                String relativePath = this.showDir.relativize(mf.getFileAsPath()).toString();
                TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(relativePath, tvShow.getTitle());
                if (result.season <= 0 || result.episodes.isEmpty()) continue;
                Iterator<Comparable<TvShowEpisode>> iterator = result.episodes.iterator();
                while (iterator.hasNext()) {
                    int epnr = (Integer)iterator.next();
                    TvShowEpisode ep = tvShow.getEpisode(result.season, epnr);
                    if (ep == null) continue;
                    ep.addToMediaFiles(mf);
                }
            }
            mfs.removeAll(tvShow.getEpisodesMediaFiles());
            tvShow.addToMediaFiles(mfs);
            for (MediaFile mf : this.getMediaFiles(mfs, MediaFileType.SEASON_POSTER, MediaFileType.SEASON_BANNER, MediaFileType.SEASON_THUMB)) {
                try {
                    int season;
                    if (mf.getFilename().startsWith("season-specials")) {
                        season = 0;
                    } else if (mf.getFilename().startsWith("season-all")) {
                        season = -1;
                    } else {
                        Matcher matcher = seasonNumber.matcher(mf.getFilename());
                        if (matcher.matches()) {
                            season = Integer.parseInt(matcher.group(1));
                        } else {
                            throw new IllegalStateException("did not find a season number");
                        }
                    }
                    LOGGER.debug("found {} - {}", (Object)mf.getType(), (Object)mf.getFileAsPath());
                    tvShow.setSeasonArtwork(season, mf);
                }
                catch (Exception e) {
                    LOGGER.warn("could not parse season number: {} MF:", (Object)e.getMessage(), (Object)mf.getFileAsPath().toAbsolutePath());
                }
            }
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                episode.reEvaluateStacking();
                episode.saveToDb();
            }
            tvShow.saveToDb();
            return this.showDir.getFileName().toString();
        }

        private MediaFile getMediaFile(List<MediaFile> mfs, MediaFileType ... types) {
            MediaFile mf = null;
            for (MediaFile mediaFile : mfs) {
                boolean match = false;
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type)) continue;
                    match = true;
                }
                if (!match) continue;
                mf = new MediaFile(mediaFile);
            }
            return mf;
        }

        private List<MediaFile> getMediaFiles(List<MediaFile> mfs, MediaFileType ... types) {
            ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
            for (MediaFile mediaFile : mfs) {
                boolean match = false;
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type)) continue;
                    match = true;
                }
                if (!match) continue;
                mf.add(new MediaFile(mediaFile));
            }
            return mf;
        }

        private List<MediaFile> getMediaFilesExceptType(List<MediaFile> mfs, MediaFileType ... types) {
            ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
            for (MediaFile mediaFile : mfs) {
                boolean match = false;
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type)) continue;
                    match = true;
                }
                if (match) continue;
                mf.add(new MediaFile(mediaFile));
            }
            return mf;
        }

        private Set<Path> getAllFilesRecursive(Path path, int deep) {
            Path folder = path.toAbsolutePath();
            AllFilesRecursive visitor = new AllFilesRecursive();
            try {
                Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), deep, visitor);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return visitor.fFound;
        }
    }
}

