/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowSubtitleDownloadTask;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.SubtitleSearchOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.mediaprovider.IMediaSubtitleProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.ui.UTF8Control;

public class TvShowSubtitleSearchAndDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowSubtitleSearchAndDownloadTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final List<TvShowEpisode> episodes;
    private final List<MediaScraper> subtitleScrapers;
    private final MediaLanguages language;

    public TvShowSubtitleSearchAndDownloadTask(List<TvShowEpisode> episodes, List<MediaScraper> subtitleScrapers, MediaLanguages language) {
        super(BUNDLE.getString("tvshow.download.subtitles"));
        this.episodes = episodes;
        this.subtitleScrapers = subtitleScrapers;
        this.language = language;
    }

    @Override
    protected void doInBackground() {
        this.initThreadPool(3, "searchAndDownloadSubtitles");
        this.start();
        for (TvShowEpisode episode : this.episodes) {
            this.submitTask(new Worker(episode));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done searching and downloading subtitles");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private TvShowEpisode episode;

        Worker(TvShowEpisode episode) {
            this.episode = episode;
        }

        @Override
        public void run() {
            try {
                for (MediaScraper scraper : TvShowSubtitleSearchAndDownloadTask.this.subtitleScrapers) {
                    try {
                        List searchResults;
                        MediaFile mf = this.episode.getMediaFiles(MediaFileType.VIDEO).get(0);
                        IMediaSubtitleProvider subtitleProvider = (IMediaSubtitleProvider)scraper.getMediaProvider();
                        SubtitleSearchOptions options = new SubtitleSearchOptions(mf.getFileAsPath().toFile());
                        options.setLanguage(TvShowSubtitleSearchAndDownloadTask.this.language.toLocale());
                        options.setSeason(this.episode.getSeason());
                        options.setEpisode(this.episode.getEpisode());
                        String imdbId = this.episode.getTvShow().getImdbId();
                        if (StringUtils.isBlank((CharSequence)imdbId)) {
                            MediaIdUtil.getImdbIdFromTvdbId(this.episode.getTvShow().getTvdbId());
                        }
                        if (StringUtils.isNotBlank((CharSequence)imdbId)) {
                            options.setImdbId(imdbId);
                        }
                        if ((searchResults = subtitleProvider.search(options)).isEmpty()) continue;
                        Collections.sort(searchResults);
                        Collections.reverse(searchResults);
                        SubtitleSearchResult firstResult = (SubtitleSearchResult)searchResults.get(0);
                        if (firstResult.getScore() < 1.0f || StringUtils.isBlank((CharSequence)firstResult.getUrl())) continue;
                        String filename = FilenameUtils.getBaseName((String)mf.getFilename()) + "." + TvShowSubtitleSearchAndDownloadTask.this.language.name();
                        TmmTaskManager.getInstance().addDownloadTask(new TvShowSubtitleDownloadTask(firstResult.getUrl(), this.episode.getPathNIO().resolve(filename), this.episode));
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getSubtitles", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.episode, "message.scrape.subtitlefailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                    catch (MissingIdException missingIdException) {}
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"SubtitleDownloader", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

