/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tasks.DownloadTask;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowSubtitleDownloadTask
extends DownloadTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowSubtitleDownloadTask.class);
    private final TvShowEpisode episode;

    public TvShowSubtitleDownloadTask(String url, Path toFile, TvShowEpisode episode2) {
        super(url, toFile);
        this.episode = episode2;
    }

    @Override
    protected void doInBackground() {
        super.doInBackground();
        MediaFile mf = new MediaFile(this.file);
        Path old = mf.getFileAsPath();
        if (mf.getType() != MediaFileType.SUBTITLE) {
            String basename = FilenameUtils.getBaseName((String)this.file.getFileName().toString());
            try (FileInputStream fis = new FileInputStream(this.file.toFile());
                 ZipInputStream is = new ZipInputStream(fis);){
                byte[] buffer = new byte[1024];
                ZipEntry ze = is.getNextEntry();
                while (ze != null) {
                    String zipEntryFilename = ze.getName();
                    String extension = FilenameUtils.getExtension((String)zipEntryFilename).toLowerCase(Locale.ROOT);
                    if (!Globals.settings.getSubtitleFileType().contains("." + extension)) {
                        ze = is.getNextEntry();
                        continue;
                    }
                    Path destination = this.file.getParent().resolve(basename + "." + extension);
                    try (FileOutputStream os = new FileOutputStream(destination.toFile());){
                        int len;
                        while ((len = is.read(buffer)) > 0) {
                            os.write(buffer, 0, len);
                        }
                        mf = new MediaFile(destination);
                        break;
                    }
                }
                is.closeEntry();
            }
            catch (Exception e) {
                LOGGER.debug("could not extract subtitle: {}", (Object)e.getMessage());
            }
        }
        if (!old.equals(mf.getFileAsPath())) {
            Utils.deleteFileSafely(old);
        }
        mf.gatherMediaInformation();
        this.episode.removeFromMediaFiles(mf);
        this.episode.addToMediaFiles(mf);
        this.episode.saveToDb();
    }
}

