/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.mediaprovider.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.ui.UTF8Control;

public class TvShowMissingArtworkDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowMissingArtworkDownloadTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<TvShow> tvShows;
    private List<TvShowEpisode> episodes;

    public TvShowMissingArtworkDownloadTask(List<TvShow> tvShows, List<TvShowEpisode> episodes) {
        super(BUNDLE.getString("task.missingartwork"));
        this.tvShows = new ArrayList<TvShow>(tvShows);
        this.episodes = new ArrayList<TvShowEpisode>(episodes);
        for (TvShow show : this.tvShows) {
            for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(show.getEpisodes())) {
                if (this.episodes.contains(episode)) continue;
                this.episodes.add(episode);
            }
        }
    }

    @Override
    protected void doInBackground() {
        LOGGER.info("Getting missing artwork");
        this.initThreadPool(3, "scrapeMissingMovieArtwork");
        this.start();
        for (TvShow show : this.tvShows) {
            if (this.cancel) break;
            if (!TvShowArtworkHelper.hasMissingArtwork(show)) continue;
            this.submitTask(new TvShowWorker(show));
        }
        for (TvShowEpisode episode : this.episodes) {
            if (this.cancel) break;
            if (!TvShowArtworkHelper.hasMissingArtwork(episode)) continue;
            this.submitTask(new TvShowEpisodeWorker(episode));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done getting missing artwork");
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private class TvShowEpisodeWorker
    implements Runnable {
        private TvShowList tvShowList = TvShowList.getInstance();
        private TvShowEpisode episode;

        public TvShowEpisodeWorker(TvShowEpisode episode) {
            this.episode = episode;
        }

        @Override
        public void run() {
            try {
                ArrayList artwork = new ArrayList();
                MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_EPISODE);
                options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
                options.setLanguage(TvShowModuleManager.SETTINGS.getScraperLanguage().toLocale());
                options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
                for (Map.Entry<String, Object> entry : this.episode.getTvShow().getIds().entrySet()) {
                    options.setId(entry.getKey(), entry.getValue().toString());
                }
                if (this.episode.isDvdOrder()) {
                    options.setId("dvdSeasonNr", String.valueOf(this.episode.getDvdSeason()));
                    options.setId("dvdEpisodeNr", String.valueOf(this.episode.getDvdEpisode()));
                } else {
                    options.setId("seasonNr", String.valueOf(this.episode.getAiredSeason()));
                    options.setId("episodeNr", String.valueOf(this.episode.getAiredEpisode()));
                }
                options.setArtworkType(MediaArtwork.MediaArtworkType.THUMB);
                MediaMetadata metadata = ((ITvShowMetadataProvider)this.tvShowList.getDefaultMediaScraper().getMediaProvider()).getMetadata(options);
                List mas = metadata.getMediaArt(MediaArtwork.MediaArtworkType.THUMB);
                if (!mas.isEmpty()) {
                    this.episode.setArtworkUrl(((MediaArtwork)mas.get(0)).getDefaultUrl(), MediaFileType.THUMB);
                    this.episode.writeThumbImage();
                }
            }
            catch (ScrapeException e) {
                LOGGER.error("getArtwork", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
            catch (MissingIdException e) {
                LOGGER.warn("missing id for scrape");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.episode, "scraper.error.missingid"));
            }
            catch (NothingFoundException | UnsupportedMediaTypeException throwable) {
                // empty catch block
            }
        }
    }

    private class TvShowWorker
    implements Runnable {
        private TvShowList tvShowList = TvShowList.getInstance();
        private TvShow tvShow;

        public TvShowWorker(TvShow tvShow) {
            this.tvShow = tvShow;
        }

        @Override
        public void run() {
            try {
                TvShowScraperMetadataConfig scraperMetadataConfig = new TvShowScraperMetadataConfig(false);
                scraperMetadataConfig.setArtwork(true);
                ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_SHOW);
                options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
                options.setLanguage(TvShowModuleManager.SETTINGS.getScraperLanguage().toLocale());
                options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
                for (Map.Entry<String, Object> entry : this.tvShow.getIds().entrySet()) {
                    options.setId(entry.getKey(), entry.getValue().toString());
                }
                for (MediaScraper artworkScraper : this.tvShowList.getDefaultArtworkScrapers()) {
                    ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                    try {
                        artwork.addAll(artworkProvider.getArtwork(options));
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getArtwork", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                    catch (MissingIdException missingIdException) {}
                }
                if (!artwork.isEmpty()) {
                    TvShowArtworkHelper.downloadMissingArtwork(this.tvShow, artwork);
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

