/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class TvShowExtraImageFetcherTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowExtraImageFetcherTask.class);
    private TvShow tvShow;
    private MediaFileType type;

    public TvShowExtraImageFetcherTask(TvShow tvShow, MediaFileType type) {
        this.tvShow = tvShow;
        this.type = type;
    }

    @Override
    public void run() {
        try {
            switch (this.type) {
                case EXTRAFANART: {
                    this.downloadExtraFanart();
                    break;
                }
                default: {
                    return;
                }
            }
            if (Thread.interrupted()) {
                return;
            }
            this.tvShow.callbackForWrittenArtwork(MediaArtwork.MediaArtworkType.ALL);
            this.tvShow.saveToDb();
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed: ", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "message.extraimage.threadcrashed"));
        }
    }

    private void downloadExtraFanart() {
        List<String> fanartUrls = this.tvShow.getExtraFanartUrls();
        if (fanartUrls.isEmpty()) {
            return;
        }
        Path folder = this.tvShow.getPathNIO().resolve("extrafanart");
        try {
            if (Files.isDirectory(folder, new LinkOption[0])) {
                Utils.deleteDirectorySafely(folder, this.tvShow.getDataSource());
                this.tvShow.removeAllMediaFiles(MediaFileType.EXTRAFANART);
            }
            Files.createDirectory(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("could not create extrafanarts folder: {}", (Object)e.getMessage());
            return;
        }
        int i = 1;
        for (String urlAsString : fanartUrls) {
            try {
                String filename = "fanart" + i + "." + FilenameUtils.getExtension((String)urlAsString);
                Path destFile = ImageUtils.downloadImage(urlAsString, folder, filename);
                MediaFile mf = new MediaFile(destFile, MediaFileType.EXTRAFANART);
                mf.gatherMediaInformation();
                this.tvShow.addToMediaFiles(mf);
                ImageCache.invalidateCachedImage(mf);
                ImageCache.cacheImageSilently(mf);
                ++i;
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.warn("problem downloading extrafanart {} - {} ", (Object)urlAsString, (Object)e.getMessage());
            }
        }
    }
}

