/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.Rating;
import org.tinymediamanager.core.tvshow.connector.TvShowGenericXmlConnector;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.w3c.dom.Element;

public class TvShowToKodiConnector
extends TvShowGenericXmlConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowToKodiConnector.class);

    public TvShowToKodiConnector(TvShow tvShow) {
        super(tvShow);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void addRating() {
        Element ratings = this.document.createElement("ratings");
        for (Rating r : this.tvShow.getRatings().values()) {
            if ("user".equals(r.getId())) continue;
            Element rating = this.document.createElement("rating");
            rating.setAttribute("name", r.getId());
            rating.setAttribute("max", String.valueOf(r.getMaxValue()));
            Rating mainRating = this.tvShow.getRating();
            rating.setAttribute("default", r == mainRating ? "true" : "false");
            Element value = this.document.createElement("value");
            value.setTextContent(Float.toString(r.getRating()));
            rating.appendChild(value);
            Element votes = this.document.createElement("votes");
            votes.setTextContent(Integer.toString(r.getVotes()));
            rating.appendChild(votes);
            ratings.appendChild(rating);
        }
        this.root.appendChild(ratings);
    }

    @Override
    protected void addVotes() {
    }

    @Override
    protected void addOwnTags() {
    }
}

