/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.entities.Rating;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.ITvShowConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.filenaming.TvShowNfoNaming;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class TvShowGenericXmlConnector
implements ITvShowConnector {
    protected final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";
    protected final TvShow tvShow;
    protected TvShowNfoParser parser = null;
    protected Document document;
    protected Element root;

    public TvShowGenericXmlConnector(TvShow tvShow) {
        this.tvShow = tvShow;
    }

    protected abstract Logger getLogger();

    protected abstract void addOwnTags();

    @Override
    public void write(List<TvShowNfoNaming> nfoNames) {
        if (!TvShowModuleManager.SETTINGS.isWriteCleanNfo()) {
            for (MediaFile mf : this.tvShow.getMediaFiles(MediaFileType.NFO)) {
                try {
                    this.parser = TvShowNfoParser.parseNfo(mf.getFileAsPath());
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        ArrayList<MediaFile> newNfos = new ArrayList<MediaFile>(1);
        for (TvShowNfoNaming nfoNaming : nfoNames) {
            String nfoFilename = nfoNaming.getFilename(this.tvShow.getTitle(), "nfo");
            if (StringUtils.isBlank((CharSequence)nfoFilename)) continue;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.document = factory.newDocumentBuilder().newDocument();
                this.document.setXmlStandalone(true);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dat = formatter.format((Object)new Date());
                this.document.appendChild(this.document.createComment("created on " + dat + " - tinyMediaManager " + Globals.settings.getVersion()));
                this.root = this.document.createElement("tvshow");
                this.document.appendChild(this.root);
                this.addTitle();
                this.addOriginalTitle();
                this.addShowTitle();
                this.addSortTitle();
                this.addYear();
                this.addRating();
                this.addUserrating();
                this.addVotes();
                this.addOutline();
                this.addPlot();
                this.addTagline();
                this.addRuntime();
                this.addPoster();
                this.addSeasonPoster();
                this.addSeasonBanner();
                this.addSeasonThumb();
                this.addFanart();
                this.addMpaa();
                this.addCertification();
                this.addEpisodeguide();
                this.addId();
                this.addImdbid();
                this.addIds();
                this.addPremiered();
                this.addStatus();
                this.addWatched();
                this.addPlaycount();
                this.addGenres();
                this.addStudios();
                this.addTags();
                this.addActors();
                this.addTrailer();
                this.addDateAdded();
                this.addOwnTags();
                this.addUnsupportedTags();
                StringWriter out = new StringWriter();
                this.getTransformer().transform(new DOMSource(this.document), new StreamResult(out));
                String xml = ((Object)out).toString().replaceAll("(?<!\r)\n", "\r\n");
                Path f = this.tvShow.getPathNIO().resolve(nfoFilename);
                Utils.writeStringToFile(f, xml);
                MediaFile mf = new MediaFile(f);
                mf.gatherMediaInformation(true);
                newNfos.add(mf);
            }
            catch (Exception e) {
                this.getLogger().error("write {}: {}", (Object)this.tvShow.getPathNIO().resolve(nfoFilename), (Object)e.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.nfo.writeerror", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        if (!newNfos.isEmpty()) {
            this.tvShow.removeAllMediaFiles(MediaFileType.NFO);
            this.tvShow.addToMediaFiles(newNfos);
        }
    }

    protected void addTitle() {
        Element title = this.document.createElement("title");
        title.setTextContent(this.tvShow.getTitle());
        this.root.appendChild(title);
    }

    protected void addOriginalTitle() {
        Element originaltitle = this.document.createElement("originaltitle");
        originaltitle.setTextContent(this.tvShow.getOriginalTitle());
        this.root.appendChild(originaltitle);
    }

    protected void addShowTitle() {
        Element title = this.document.createElement("showtitle");
        title.setTextContent(this.tvShow.getTitle());
        this.root.appendChild(title);
    }

    protected void addSortTitle() {
        Element sorttitle = this.document.createElement("sorttitle");
        sorttitle.setTextContent(this.tvShow.getSortTitle());
        this.root.appendChild(sorttitle);
    }

    protected void addYear() {
        Element year = this.document.createElement("year");
        year.setTextContent(this.tvShow.getYear() == 0 ? "" : Integer.toString(this.tvShow.getYear()));
        this.root.appendChild(year);
    }

    protected void addRating() {
        Map<String, Rating> ratings = this.tvShow.getRatings();
        Rating mainRating = ratings.get(TvShowModuleManager.SETTINGS.getPreferredRating());
        if (mainRating == null) {
            for (Rating r : ratings.values()) {
                if ("user".equals(r.getId())) continue;
                mainRating = r;
            }
        }
        if (mainRating == null) {
            mainRating = new Rating();
        }
        Float rating10 = mainRating.getMaxValue() > 0 ? Float.valueOf(mainRating.getRating() * 10.0f / (float)mainRating.getMaxValue()) : Float.valueOf(mainRating.getRating());
        Element rating = this.document.createElement("rating");
        rating.setTextContent(String.format(Locale.US, "%.1f", rating10));
        this.root.appendChild(rating);
    }

    protected void addUserrating() {
        Rating rating = this.tvShow.getRating("user");
        Float rating10 = rating.getMaxValue() > 0 ? Float.valueOf(rating.getRating() * 10.0f / (float)rating.getMaxValue()) : Float.valueOf(rating.getRating());
        Element UserRating = this.document.createElement("userrating");
        UserRating.setTextContent(String.format(Locale.US, "%.1f", rating10));
        this.root.appendChild(UserRating);
    }

    protected void addVotes() {
        Element votes = this.document.createElement("votes");
        votes.setTextContent(Integer.toString(this.tvShow.getRating().getVotes()));
        this.root.appendChild(votes);
    }

    protected void addOutline() {
        Element outline = this.document.createElement("outline");
        this.root.appendChild(outline);
    }

    protected void addPlot() {
        Element plot = this.document.createElement("plot");
        plot.setTextContent(this.tvShow.getPlot());
        this.root.appendChild(plot);
    }

    protected void addTagline() {
        Element tagline = this.document.createElement("tagline");
        this.root.appendChild(tagline);
    }

    protected void addRuntime() {
        Element runtime = this.document.createElement("runtime");
        runtime.setTextContent(Integer.toString(this.tvShow.getRuntime()));
        this.root.appendChild(runtime);
    }

    protected void addPoster() {
        Element thumb = this.document.createElement("thumb");
        String posterUrl = this.tvShow.getArtworkUrl(MediaFileType.POSTER);
        if (StringUtils.isNotBlank((CharSequence)posterUrl)) {
            thumb.setAttribute("aspect", "poster");
            thumb.setTextContent(posterUrl);
            this.root.appendChild(thumb);
        }
    }

    protected void addSeasonPoster() {
        for (Map.Entry<Integer, String> entry : this.tvShow.getSeasonArtworkUrls(MediaArtwork.MediaArtworkType.SEASON_POSTER).entrySet()) {
            Element thumb = this.document.createElement("thumb");
            String posterUrl = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)posterUrl)) continue;
            thumb.setAttribute("aspect", "poster");
            thumb.setAttribute("type", "season");
            thumb.setAttribute("season", String.valueOf(entry.getKey()));
            thumb.setTextContent(posterUrl);
            this.root.appendChild(thumb);
        }
    }

    protected void addSeasonBanner() {
        for (Map.Entry<Integer, String> entry : this.tvShow.getSeasonArtworkUrls(MediaArtwork.MediaArtworkType.SEASON_BANNER).entrySet()) {
            Element thumb = this.document.createElement("thumb");
            String bannerUrl = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)bannerUrl)) continue;
            thumb.setAttribute("aspect", "banner");
            thumb.setAttribute("type", "season");
            thumb.setAttribute("season", String.valueOf(entry.getKey()));
            thumb.setTextContent(bannerUrl);
            this.root.appendChild(thumb);
        }
    }

    protected void addSeasonThumb() {
        for (Map.Entry<Integer, String> entry : this.tvShow.getSeasonArtworkUrls(MediaArtwork.MediaArtworkType.SEASON_THUMB).entrySet()) {
            Element thumb = this.document.createElement("thumb");
            String thumbUrl = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)thumbUrl)) continue;
            thumb.setAttribute("aspect", "thumb");
            thumb.setAttribute("type", "season");
            thumb.setAttribute("season", String.valueOf(entry.getKey()));
            thumb.setTextContent(thumbUrl);
            this.root.appendChild(thumb);
        }
    }

    protected void addFanart() {
        Element fanart = this.document.createElement("fanart");
        String fanarUrl = this.tvShow.getArtworkUrl(MediaFileType.FANART);
        if (StringUtils.isNotBlank((CharSequence)fanarUrl)) {
            Element thumb = this.document.createElement("thumb");
            thumb.setTextContent(fanarUrl);
            fanart.appendChild(thumb);
        }
        this.root.appendChild(fanart);
    }

    protected void addMpaa() {
        Element mpaa = this.document.createElement("mpaa");
        if (this.tvShow.getCertification() != null) {
            if (this.tvShow.getCertification().getCountry() == CountryCode.US) {
                mpaa.setTextContent(Certification.getMPAAString((Certification)this.tvShow.getCertification()));
            } else {
                mpaa.setTextContent(CertificationStyle.formatCertification(this.tvShow.getCertification(), TvShowModuleManager.SETTINGS.getCertificationStyle()));
            }
        }
        this.root.appendChild(mpaa);
    }

    protected void addCertification() {
        Element certification = this.document.createElement("certification");
        if (this.tvShow.getCertification() != null) {
            certification.setTextContent(CertificationStyle.formatCertification(this.tvShow.getCertification(), TvShowModuleManager.SETTINGS.getCertificationStyle()));
        }
        this.root.appendChild(certification);
    }

    protected void addEpisodeguide() {
        if (StringUtils.isNotBlank((CharSequence)this.tvShow.getTvdbId())) {
            Element episodeguide = this.document.createElement("episodeguide");
            Element url = this.document.createElement("url");
            url.setAttribute("post", "yes");
            url.setAttribute("cache", "auth.json");
            url.setTextContent("https://api.thetvdb.com/login?{\"apikey\":\"439DFEBA9D3059C6\",\"id\":" + this.tvShow.getTvdbId() + "}|Content-Type=application/json");
            episodeguide.appendChild(url);
            this.root.appendChild(episodeguide);
        } else if (StringUtils.isNotBlank((CharSequence)this.tvShow.getIdAsString("tmdb"))) {
            Element episodeguide = this.document.createElement("episodeguide");
            Element url = this.document.createElement("url");
            url.setTextContent("http://api.themoviedb.org/3/tv/" + this.tvShow.getIdAsString("tmdb") + "?api_key=6a5be4999abf74eba1f9a8311294c267&language=" + TvShowModuleManager.SETTINGS.getScraperLanguage().getLanguage());
            episodeguide.appendChild(url);
            this.root.appendChild(episodeguide);
        } else if (this.parser != null && StringUtils.isNotBlank((CharSequence)this.parser.episodeguide)) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                Element episodeguide = this.document.createElement("episodeguide");
                Document unsupported = factory.newDocumentBuilder().parse(new ByteArrayInputStream(this.parser.episodeguide.getBytes("UTF-8")));
                episodeguide.appendChild(this.document.importNode(unsupported.getFirstChild(), true));
                this.root.appendChild(episodeguide);
            }
            catch (Exception e) {
                this.getLogger().warn("could not set episodeguide");
            }
        }
    }

    protected void addId() {
        Element id = this.document.createElement("id");
        id.setTextContent(this.tvShow.getTvdbId());
        this.root.appendChild(id);
    }

    protected void addImdbid() {
        Element imdbid = this.document.createElement("imdbid");
        imdbid.setTextContent(this.tvShow.getImdbId());
        this.root.appendChild(imdbid);
    }

    protected void addIds() {
        for (Map.Entry<String, Object> entry : this.tvShow.getIds().entrySet()) {
            Element uniqueid = this.document.createElement("uniqueid");
            uniqueid.setAttribute("type", entry.getKey());
            if ("tvdb".equals(entry.getKey()) || this.tvShow.getIds().size() == 1) {
                uniqueid.setAttribute("default", "true");
            } else {
                uniqueid.setAttribute("default", "false");
            }
            uniqueid.setTextContent(entry.getValue().toString());
            this.root.appendChild(uniqueid);
        }
    }

    protected void addPremiered() {
        Element premiered = this.document.createElement("premiered");
        if (this.tvShow.getFirstAired() != null) {
            premiered.setTextContent(new SimpleDateFormat("yyyy-MM-dd").format(this.tvShow.getFirstAired()));
        }
        this.root.appendChild(premiered);
    }

    protected void addDateAdded() {
        Element dateadded = this.document.createElement("dateadded");
        if (this.tvShow.getDateAdded() != null) {
            dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.tvShow.getDateAdded()));
        }
        this.root.appendChild(dateadded);
    }

    protected void addStatus() {
        Element status = this.document.createElement("status");
        status.setTextContent(this.tvShow.getStatus().getName());
        this.root.appendChild(status);
    }

    protected void addWatched() {
        Element watched = this.document.createElement("watched");
        watched.setTextContent(Boolean.toString(this.tvShow.isWatched()));
        this.root.appendChild(watched);
    }

    protected void addPlaycount() {
        Element playcount = this.document.createElement("playcount");
        if (this.tvShow.isWatched() && this.parser != null && this.parser.playcount > 0) {
            playcount.setTextContent(Integer.toString(this.parser.playcount));
        } else if (this.tvShow.isWatched()) {
            playcount.setTextContent("1");
        }
        this.root.appendChild(playcount);
    }

    protected void addGenres() {
        for (MediaGenres mediaGenre : this.tvShow.getGenres()) {
            Element genre = this.document.createElement("genre");
            genre.setTextContent(mediaGenre.getLocalizedName(TvShowModuleManager.SETTINGS.getNfoLanguage().toLocale()));
            this.root.appendChild(genre);
        }
    }

    protected void addStudios() {
        String[] studios;
        for (String s : studios = this.tvShow.getProductionCompany().split("\\s*[,\\/]\\s*")) {
            Element studio = this.document.createElement("studio");
            studio.setTextContent(s);
            this.root.appendChild(studio);
        }
    }

    protected void addTags() {
        for (String t : this.tvShow.getTags()) {
            Element tag = this.document.createElement("tag");
            tag.setTextContent(t);
            this.root.appendChild(tag);
        }
    }

    protected void addActors() {
        for (Person tvShowActor : this.tvShow.getActors()) {
            Element actor = this.document.createElement("actor");
            Element name = this.document.createElement("name");
            name.setTextContent(tvShowActor.getName());
            actor.appendChild(name);
            Element role = this.document.createElement("role");
            role.setTextContent(tvShowActor.getRole());
            actor.appendChild(role);
            Element thumb = this.document.createElement("thumb");
            thumb.setTextContent(tvShowActor.getThumbUrl());
            actor.appendChild(thumb);
            Element profile = this.document.createElement("profile");
            profile.setTextContent(tvShowActor.getProfileUrl());
            actor.appendChild(profile);
            this.root.appendChild(actor);
        }
    }

    protected void addTrailer() {
        Element trailer = this.document.createElement("trailer");
        if (this.parser != null && StringUtils.isNotBlank((CharSequence)this.parser.trailer)) {
            trailer.setTextContent(this.parser.trailer);
        }
        this.root.appendChild(trailer);
    }

    protected void addUnsupportedTags() {
        if (this.parser != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            for (String unsupportedString : this.parser.unsupportedElements) {
                try {
                    Document unsupported = factory.newDocumentBuilder().parse(new ByteArrayInputStream(unsupportedString.getBytes("UTF-8")));
                    this.root.appendChild(this.document.importNode(unsupported.getFirstChild(), true));
                }
                catch (Exception e) {
                    this.getLogger().error("import unsupported tags: {}", (Object)e.getMessage());
                }
            }
        }
    }

    protected Element getSingleElementByTag(String tag) {
        NodeList nodeList = this.document.getElementsByTagName(tag);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    protected Transformer getTransformer() throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "yes");
        transformer.setOutputProperty("http://www.oracle.com/xml/is-standalone", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        return transformer;
    }
}

