/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IFileNaming;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.tasks.MediaEntityImageFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonBannerNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonPosterNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonThumbNaming;
import org.tinymediamanager.core.tvshow.tasks.TvShowExtraImageFetcherTask;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class TvShowArtworkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowArtworkHelper.class);

    public static void downloadArtwork(TvShow show, MediaFileType type) {
        if (type == MediaFileType.EXTRAFANART) {
            TvShowArtworkHelper.downloadExtraArtwork(show, type);
            return;
        }
        String url = show.getArtworkUrl(type);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        ArrayList<Enum> fileNamings = new ArrayList<Enum>();
        switch (type) {
            case FANART: {
                fileNamings.addAll(TvShowModuleManager.SETTINGS.getFanartFilenames());
                break;
            }
            case POSTER: {
                fileNamings.addAll(TvShowModuleManager.SETTINGS.getPosterFilenames());
                break;
            }
            case BANNER: {
                fileNamings.addAll(TvShowModuleManager.SETTINGS.getBannerFilenames());
                break;
            }
            case LOGO: {
                fileNamings.addAll(TvShowModuleManager.SETTINGS.getLogoFilenames());
                break;
            }
            case CLEARLOGO: {
                fileNamings.addAll(TvShowModuleManager.SETTINGS.getClearlogoFilenames());
                break;
            }
            case CHARACTERART: {
                fileNamings.addAll(TvShowModuleManager.SETTINGS.getCharacterartFilenames());
                break;
            }
            case CLEARART: {
                fileNamings.addAll(TvShowModuleManager.SETTINGS.getClearartFilenames());
                break;
            }
            case THUMB: {
                fileNamings.addAll(TvShowModuleManager.SETTINGS.getThumbFilenames());
                break;
            }
            case KEYART: {
                fileNamings.addAll(TvShowModuleManager.SETTINGS.getKeyartFilenames());
                break;
            }
            default: {
                return;
            }
        }
        int i = 0;
        for (IFileNaming iFileNaming : fileNamings) {
            boolean firstImage = false;
            String filename = iFileNaming.getFilename("", Utils.getArtworkExtension(url));
            if (StringUtils.isBlank((CharSequence)filename)) continue;
            if (++i == 1) {
                firstImage = true;
            }
            MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(show, url, MediaFileType.getMediaArtworkType(type), filename, firstImage);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
        if (url.startsWith("file:")) {
            show.removeArtworkUrl(type);
        }
    }

    public static void downloadMissingArtwork(TvShow tvShow, List<MediaArtwork> artwork) {
        artwork.sort((Comparator<MediaArtwork>)new MediaArtwork.MediaArtworkComparator(TvShowModuleManager.SETTINGS.getScraperLanguage().name()));
        if (tvShow.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.POSTER);
        }
        if (tvShow.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.BACKGROUND);
        }
        if (tvShow.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.LOGO);
        }
        if (tvShow.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (tvShow.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (tvShow.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.BANNER);
        }
        if (tvShow.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.THUMB);
        }
        if (tvShow.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.DISC);
        }
        if (tvShow.getMediaFiles(MediaFileType.CHARACTERART).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CHARACTERART);
        }
        if (tvShow.getMediaFiles(MediaFileType.KEYART).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.KEYART);
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            if (StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_POSTER))) {
                for (MediaArtwork art : artwork) {
                    if (art.getSeason() != season.getSeason()) continue;
                    tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
                    TvShowArtworkHelper.downloadSeasonPoster(tvShow, art.getSeason());
                }
            }
            if (StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_BANNER))) {
                for (MediaArtwork art : artwork) {
                    if (art.getSeason() != season.getSeason()) continue;
                    tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
                    TvShowArtworkHelper.downloadSeasonBanner(tvShow, art.getSeason());
                }
            }
            if (!StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_THUMB))) continue;
            for (MediaArtwork art : artwork) {
                if (art.getSeason() != season.getSeason()) continue;
                tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_THUMB);
                TvShowArtworkHelper.downloadSeasonThumb(tvShow, art.getSeason());
            }
        }
        tvShow.saveToDb();
    }

    private static void setBestArtwork(TvShow tvShow, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type) {
        for (MediaArtwork art : artwork) {
            if (art.getType() != type || !StringUtils.isNotBlank((CharSequence)art.getDefaultUrl())) continue;
            tvShow.setArtworkUrl(art.getDefaultUrl(), MediaFileType.getMediaFileType(type));
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.getMediaFileType(type));
            break;
        }
    }

    public static boolean hasMissingArtwork(TvShow tvShow) {
        if (tvShow.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.CHARACTERART).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.KEYART).isEmpty()) {
            return true;
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            if (StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_POSTER))) {
                return true;
            }
            if (StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_BANNER))) {
                return true;
            }
            if (!StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_THUMB))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMissingArtwork(TvShowEpisode episode) {
        return episode.getMediaFiles(MediaFileType.THUMB).isEmpty();
    }

    public static void downloadSeasonArtwork(TvShow show, int season, MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                TvShowArtworkHelper.downloadSeasonPoster(show, season);
                break;
            }
            case SEASON_BANNER: {
                TvShowArtworkHelper.downloadSeasonBanner(show, season);
                break;
            }
            case SEASON_THUMB: {
                TvShowArtworkHelper.downloadSeasonThumb(show, season);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static void downloadSeasonPoster(TvShow show, int season) {
        String seasonPosterUrl = show.getSeasonArtworkUrl(season, MediaArtwork.MediaArtworkType.SEASON_POSTER);
        TvShowSeason tvShowSeason = null;
        for (TvShowSeason s : show.getSeasons()) {
            if (s.getSeason() != season) continue;
            tvShowSeason = s;
            break;
        }
        for (TvShowSeasonPosterNaming seasonPosterNaming : TvShowModuleManager.SETTINGS.getSeasonPosterFilenames()) {
            String filename = seasonPosterNaming.getFilename(show, season, Utils.getArtworkExtension(seasonPosterUrl));
            if (StringUtils.isBlank((CharSequence)filename)) {
                LOGGER.warn("empty filename for artwork: {} - {}", (Object)seasonPosterNaming.name(), (Object)show);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                continue;
            }
            Path destFile = show.getPathNIO().resolve(filename);
            if (!Files.exists(destFile.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectory(destFile.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error("could not create folder: {} - {}", (Object)destFile.getParent(), (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                    continue;
                }
            }
            SeasonArtworkImageFetcher task = new SeasonArtworkImageFetcher(show, destFile, tvShowSeason, seasonPosterUrl, MediaArtwork.MediaArtworkType.SEASON_POSTER);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
        if (tvShowSeason != null && seasonPosterUrl.startsWith("file:")) {
            tvShowSeason.removeArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_POSTER);
        }
    }

    private static void downloadSeasonBanner(TvShow show, int season) {
        String seasonBannerUrl = show.getSeasonArtworkUrl(season, MediaArtwork.MediaArtworkType.SEASON_BANNER);
        TvShowSeason tvShowSeason = null;
        for (TvShowSeason s : show.getSeasons()) {
            if (s.getSeason() != season) continue;
            tvShowSeason = s;
            break;
        }
        for (TvShowSeasonBannerNaming seasonBannerNaming : TvShowModuleManager.SETTINGS.getSeasonBannerFilenames()) {
            String filename = seasonBannerNaming.getFilename(show, season, Utils.getArtworkExtension(seasonBannerUrl));
            if (StringUtils.isBlank((CharSequence)filename)) {
                LOGGER.warn("empty filename for artwork: {} - {}", (Object)seasonBannerNaming.name(), (Object)show);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                continue;
            }
            Path destFile = Paths.get(show.getPathNIO() + File.separator + filename, new String[0]);
            if (!Files.exists(destFile.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectory(destFile.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error("could not create folder: {} - {}", (Object)destFile.getParent(), (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                    continue;
                }
            }
            SeasonArtworkImageFetcher task = new SeasonArtworkImageFetcher(show, destFile, tvShowSeason, seasonBannerUrl, MediaArtwork.MediaArtworkType.SEASON_BANNER);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
        if (tvShowSeason != null && seasonBannerUrl.startsWith("file:")) {
            tvShowSeason.removeArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_BANNER);
        }
    }

    private static void downloadSeasonThumb(TvShow show, int season) {
        String seasonThumbUrl = show.getSeasonArtworkUrl(season, MediaArtwork.MediaArtworkType.SEASON_THUMB);
        TvShowSeason tvShowSeason = null;
        for (TvShowSeason s : show.getSeasons()) {
            if (s.getSeason() != season) continue;
            tvShowSeason = s;
            break;
        }
        for (TvShowSeasonThumbNaming seasonThumbNaming : TvShowModuleManager.SETTINGS.getSeasonThumbFilenames()) {
            String filename = seasonThumbNaming.getFilename(show, season, Utils.getArtworkExtension(seasonThumbUrl));
            if (StringUtils.isBlank((CharSequence)filename)) {
                LOGGER.warn("empty filename for artwork: {} - {}", (Object)seasonThumbNaming.name(), (Object)show);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                continue;
            }
            Path destFile = show.getPathNIO().resolve(filename);
            if (!Files.exists(destFile.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectory(destFile.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error("could not create folder: {} - {}", (Object)destFile.getParent(), (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                    continue;
                }
            }
            SeasonArtworkImageFetcher task = new SeasonArtworkImageFetcher(show, destFile, tvShowSeason, seasonThumbUrl, MediaArtwork.MediaArtworkType.SEASON_THUMB);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
        if (tvShowSeason != null && seasonThumbUrl.startsWith("file:")) {
            tvShowSeason.removeArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_THUMB);
        }
    }

    public static void setArtwork(TvShow tvShow, List<MediaArtwork> artwork) {
        for (MediaArtwork mediaArtwork : artwork) {
            if (mediaArtwork.getType() != MediaArtwork.MediaArtworkType.POSTER) continue;
            tvShow.setArtworkUrl(mediaArtwork.getDefaultUrl(), MediaFileType.POSTER);
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.POSTER);
            break;
        }
        for (MediaArtwork mediaArtwork : artwork) {
            if (mediaArtwork.getType() != MediaArtwork.MediaArtworkType.BACKGROUND) continue;
            tvShow.setArtworkUrl(mediaArtwork.getDefaultUrl(), MediaFileType.FANART);
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.FANART);
            break;
        }
        for (MediaArtwork mediaArtwork : artwork) {
            if (mediaArtwork.getType() != MediaArtwork.MediaArtworkType.BANNER) continue;
            tvShow.setArtworkUrl(mediaArtwork.getDefaultUrl(), MediaFileType.BANNER);
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.BANNER);
            break;
        }
        for (MediaArtwork mediaArtwork : artwork) {
            if (mediaArtwork.getType() != MediaArtwork.MediaArtworkType.LOGO) continue;
            tvShow.setArtworkUrl(mediaArtwork.getDefaultUrl(), MediaFileType.LOGO);
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.LOGO);
            break;
        }
        for (MediaArtwork mediaArtwork : artwork) {
            if (mediaArtwork.getType() != MediaArtwork.MediaArtworkType.CLEARLOGO) continue;
            tvShow.setArtworkUrl(mediaArtwork.getDefaultUrl(), MediaFileType.CLEARLOGO);
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.CLEARLOGO);
            break;
        }
        for (MediaArtwork mediaArtwork : artwork) {
            if (mediaArtwork.getType() != MediaArtwork.MediaArtworkType.CLEARART) continue;
            tvShow.setArtworkUrl(mediaArtwork.getDefaultUrl(), MediaFileType.CLEARART);
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.CLEARART);
            break;
        }
        for (MediaArtwork mediaArtwork : artwork) {
            if (mediaArtwork.getType() != MediaArtwork.MediaArtworkType.THUMB) continue;
            tvShow.setArtworkUrl(mediaArtwork.getDefaultUrl(), MediaFileType.THUMB);
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.THUMB);
            break;
        }
        for (MediaArtwork mediaArtwork : artwork) {
            if (mediaArtwork.getType() != MediaArtwork.MediaArtworkType.CHARACTERART) continue;
            tvShow.setArtworkUrl(mediaArtwork.getDefaultUrl(), MediaFileType.CHARACTERART);
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.CHARACTERART);
            break;
        }
        for (MediaArtwork mediaArtwork : artwork) {
            if (mediaArtwork.getType() != MediaArtwork.MediaArtworkType.KEYART) continue;
            tvShow.setArtworkUrl(mediaArtwork.getDefaultUrl(), MediaFileType.KEYART);
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.KEYART);
            break;
        }
        HashMap<Integer, String> seasonPosters = new HashMap<Integer, String>();
        for (MediaArtwork mediaArtwork : artwork) {
            String string;
            if (mediaArtwork.getType() != MediaArtwork.MediaArtworkType.SEASON_POSTER || mediaArtwork.getSeason() < 0 || !StringUtils.isBlank((CharSequence)(string = (String)seasonPosters.get(mediaArtwork.getSeason())))) continue;
            tvShow.setSeasonArtworkUrl(mediaArtwork.getSeason(), mediaArtwork.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
            TvShowArtworkHelper.downloadSeasonArtwork(tvShow, mediaArtwork.getSeason(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
            seasonPosters.put(mediaArtwork.getSeason(), mediaArtwork.getDefaultUrl());
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (MediaArtwork mediaArtwork : artwork) {
            String url;
            if (mediaArtwork.getType() != MediaArtwork.MediaArtworkType.SEASON_BANNER || mediaArtwork.getSeason() < 0 || !StringUtils.isBlank((CharSequence)(url = (String)hashMap.get(mediaArtwork.getSeason())))) continue;
            tvShow.setSeasonArtworkUrl(mediaArtwork.getSeason(), mediaArtwork.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
            TvShowArtworkHelper.downloadSeasonArtwork(tvShow, mediaArtwork.getSeason(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
            hashMap.put(mediaArtwork.getSeason(), mediaArtwork.getDefaultUrl());
        }
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        for (MediaArtwork art : artwork) {
            String url;
            if (art.getType() != MediaArtwork.MediaArtworkType.SEASON_THUMB || art.getSeason() < 0 || !StringUtils.isBlank((CharSequence)(url = (String)hashMap2.get(art.getSeason())))) continue;
            tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_THUMB);
            TvShowArtworkHelper.downloadSeasonArtwork(tvShow, art.getSeason(), MediaArtwork.MediaArtworkType.SEASON_THUMB);
            hashMap2.put(art.getSeason(), art.getDefaultUrl());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (TvShowModuleManager.SETTINGS.isImageExtraFanart() && TvShowModuleManager.SETTINGS.getImageExtraFanartCount() > 0) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND) continue;
                arrayList.add(art.getDefaultUrl());
                if (arrayList.size() < TvShowModuleManager.SETTINGS.getImageExtraFanartCount()) continue;
                break;
            }
            tvShow.setExtraFanartUrls(arrayList);
            if (!arrayList.isEmpty()) {
                TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.EXTRAFANART);
            }
        }
        tvShow.saveToDb();
        tvShow.writeNFO();
    }

    private static void downloadExtraArtwork(TvShow tvShow, MediaFileType type) {
        TvShowExtraImageFetcherTask task = new TvShowExtraImageFetcherTask(tvShow, type);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    private static class SeasonArtworkImageFetcher
    implements Runnable {
        private TvShow tvShow;
        private TvShowSeason tvShowSeason;
        private MediaArtwork.MediaArtworkType artworkType;
        private Path destinationPath;
        private String filename;
        private String url;

        SeasonArtworkImageFetcher(TvShow show, Path destFile, TvShowSeason tvShowSeason, String url, MediaArtwork.MediaArtworkType type) {
            this.tvShow = show;
            this.destinationPath = destFile.getParent();
            this.filename = destFile.getFileName().toString();
            this.artworkType = type;
            this.tvShowSeason = tvShowSeason;
            this.url = url;
        }

        @Override
        public void run() {
            String oldFilename = "";
            if (this.tvShowSeason != null) {
                oldFilename = this.tvShow.getSeasonArtwork(this.tvShowSeason.getSeason(), this.artworkType);
                this.tvShowSeason.clearArtwork(this.artworkType);
            }
            LOGGER.debug("writing season artwork {}", (Object)this.filename);
            try {
                Path destFile = ImageUtils.downloadImage(this.url, this.destinationPath, this.filename);
                if (this.tvShowSeason != null) {
                    this.tvShowSeason.setArtwork(destFile, this.artworkType);
                }
                ImageCache.invalidateCachedImage(destFile);
                ImageCache.cacheImageSilently(destFile);
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("fetch image {} - {}", (Object)this.url, (Object)e);
                if (this.tvShowSeason != null && !oldFilename.isEmpty()) {
                    this.tvShowSeason.setArtwork(Paths.get(oldFilename, new String[0]), this.artworkType);
                }
                ImageCache.invalidateCachedImage(Paths.get(oldFilename, new String[0]));
                ImageCache.cacheImageSilently(Paths.get(oldFilename, new String[0]));
            }
            finally {
                this.tvShow.saveToDb();
            }
        }
    }
}

