/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.core.tasks.DownloadTask;

public class MovieTrailerDownloadTask
extends DownloadTask {
    public MovieTrailerDownloadTask(MovieTrailer trailer, Movie movie) throws Exception {
        super(trailer.getUrl(), movie.getPathNIO().resolve(movie.getTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER)), movie, MediaFileType.TRAILER);
        List<Object> trailernames = new ArrayList<MovieTrailerNaming>();
        if (movie.isMultiMovieDir()) {
            trailernames.add((Object)MovieTrailerNaming.FILENAME_TRAILER);
        } else {
            trailernames = MovieModuleManager.SETTINGS.getTrailerFilenames();
        }
        for (MovieTrailerNaming movieTrailerNaming : trailernames) {
            this.file = movie.getPathNIO().resolve(movie.getTrailerFilename(movieTrailerNaming));
        }
        if ("apple".equalsIgnoreCase(trailer.getProvider())) {
            this.setSpecialUserAgent("QuickTime");
        }
    }
}

